# Jasmine Core 2.0.1 Release Notes

## Summary

This release is for small bug fixes and enhancements ahead of a real-soon-now 2.1.

## Changes

### Features

* NodeJS is now supported with a jasmine-core npm
* [Support browsers that don't supply a `Date.now()` by having a `mockDate` object](http://www.pivotaltracker.com/story/66606132) - Closes #361
* [Show message if no specs where loaded](http://www.pivotaltracker.com/story/12784235)
* When using `jasmine.any`, the `class` will now be included in the error message
* Reporters now receive the number of passed expectations in a spec
* Use default failure message for `toBeNaN`
* Use the latest `jasmine_selenium_runner` so we use the fix for printing objects with cycles
* Add jasmine logo image to HTML runner
* Stop Jasmine's CSS affecting the style of the body tag - Closes #600
* Standardized location of the standalone distributions - they now live in the repo in `/dist` as well as on the Releases page

### Bugs

* Don't allow calling the same done callback multiple times - Fixes #523
* [Remove 'empty' as an option as a spec result](http://www.pivotaltracker.com/story/73741032) as this was a breaking change
    * Instead, we determine if a spec has no expectations using the added
key of `passedExpectations` in combination of the `failedExpectations`
to determine that there a spec is 'empty'
* Fix build in IE8 (IE8 doesn't support `Object.freeze`)
* Fix `ObjectContaining` to match recursively

### Documentation

* Update release doc to use GitHub releases
* Add installation instructions to README - Merges #621
* Add Ruby Gem and Python Egg to docs
* Add detailed steps on how to contribute - Merges #580 from @pablofiu

## Pull Requests and Issues

* Contains is explicitly false if actual is `undefined` or `null` - Fixes #627
* namespace `html-reporter` -> `jasmine_html-reporter` - Fixes #600
* Throw a more specific error when `expect` is used without a `currentSpec` - Fixes #602
* Reduced size of logo with PNG Gauntlet - Merges #588
* HTML Reporter resets previous DOM when re-initialized -  Merges #594 from @plukevdh
* Narrow down raise exceptions query selector; Finding by any input tag is a little bit broad - Closes #605
* Pass through custom equality testers in toHaveBeenCalledWith - Fixes #536
* Fix outdated copyright year (update to 2014) - Merges #550 from @slothmonster
* [Add package.json to Python egg to get correct version number](http://www.pivotaltracker.com/story/67556148) - Fixes #551
* Allow users to set the maximum length of array that the pretty-printer
will print out - Fixes #323 @mikemoraned and #374 @futuraprime
* `matchersUtil.equals()` does not expect a matcher as its first argument,
so send the "actual" value first and the "expected" value second. - Merges #538 from @cbandy
* Add single quote check to `jshint` and fix src files for that - Closes #522
* Remove an `eval` in order to support running jasmine within CSP - Closes #503
* Allow matcher custom failure messages to be a function - Closes #520
* More color blind friendly CSS from @dleppik - Closes #463 &amp; #509
* Use `load-grunt-tasks` Merges #521 from @robinboehm
* Special case printing `-0` - Closes #496
* Allow stub or spy Date object safely using a closure to get a clean copy - Closes #506
* [Use `\d7` instead of plain 'x' for more square appearance](http://www.pivotaltracker.com/story/48434179)
* Better support in pretty printer when an object has null prototype - Fixes #500
* Update link at top of README to improve access to Jasmine 2.0 docs - Merges #486 from @nextmat
* Force query selector to seek within the html-reporter element - Merges #479 from @shprink
* Netbeans files are in gitignore - Merges #478 from @shprink


------

_Release Notes generated with [Anchorman](http://github.com/infews/anchorman)_
