# First Input Delay Changes in M83

## Changes in Chrome 83

In Chrome 83, a bug was fixed in the implementation of First Input Delay (FID).
Prior to M83, First input delay values less than 1ms were not reported to the
[Chrome User Experience Report (CrUX)](https://developers.google.com/web/tools/chrome-user-experience-report).
These values have always been exposed in the
[web API](https://github.com/WICG/event-timing#first-input-timing).

[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2112983).

## How does this affect a site's metrics?

For the CrUX data, developers often view it in terms of the percent of page
loads which are "fast" (less than 100ms), "medium" (less than 300ms), or "slow"
(greater than 300ms). Since events with times less than 1ms are now included,
sites can expect to see an increase in the percent of fast sites. How much an
individual site's metrics will be affected depends on the number of very fast
devices loading pages and the baseline amount of work being done. Sites with
more fast devices and less work during load will see the largest increase in
fast page loads.

* On Android, our analysis showed that the average site will have about
  **1.5% more page loads** marked as having fast FID.
* On Windows, our analysis showed that the average site will have
  **1.2% more page loads** marked as having fast FID.

It's still important for sites to focus on the long tail of FID, working to
bring down bad user experiences in high percentiles.

**Data from the [web API](https://github.com/WICG/event-timing#first-input-timing)
is unaffected by this change.**

## When were users affected?

Chrome 83 is currently scheduled to release on May 19. This page will be updated
with an improved estimate of how sites' metrics are impacted within two weeks of
launch.
