// generated by diplomat-tool
import type { DataProvider } from "./DataProvider"
import type { DateFormatter } from "./DateFormatter"
import type { DateTimeFormatterLoadError } from "./DateTimeFormatterLoadError"
import type { DateTimeWriteError } from "./DateTimeWriteError"
import type { IsoDate } from "./IsoDate"
import type { Locale } from "./Locale"
import type { TimeZoneInfo } from "./TimeZoneInfo"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `DateTimeFormatter`](https://docs.rs/icu/latest/icu/datetime/struct.DateTimeFormatter.html) for more information.
 */


export class ZonedDateFormatter {
    get ffiValue(): pointer;


    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificLong.html) for more information.
     */
    static createSpecificLong(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificLong.html) for more information.
     */
    static createSpecificLongWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificShort.html) for more information.
     */
    static createSpecificShort(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificShort.html) for more information.
     */
    static createSpecificShortWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetLong.html) for more information.
     */
    static createLocalizedOffsetLong(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetLong.html) for more information.
     */
    static createLocalizedOffsetLongWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetShort.html) for more information.
     */
    static createLocalizedOffsetShort(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetShort.html) for more information.
     */
    static createLocalizedOffsetShortWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericLong.html) for more information.
     */
    static createGenericLong(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericLong.html) for more information.
     */
    static createGenericLongWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericShort.html) for more information.
     */
    static createGenericShort(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericShort.html) for more information.
     */
    static createGenericShortWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `Location`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.Location.html) for more information.
     */
    static createLocation(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `Location`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.Location.html) for more information.
     */
    static createLocationWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `ExemplarCity`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.ExemplarCity.html) for more information.
     */
    static createExemplarCity(locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `ExemplarCity`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.ExemplarCity.html) for more information.
     */
    static createExemplarCityWithProvider(provider: DataProvider, locale: Locale, formatter: DateFormatter): ZonedDateFormatter;

    /**
     * See the [Rust documentation for `format`](https://docs.rs/icu/latest/icu/datetime/struct.DateTimeFormatter.html#method.format) for more information.
     */
    formatIso(date: IsoDate, zone: TimeZoneInfo): string;
}