/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal;

import com.google.common.collect.ImmutableList;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.composites.ClusteringColumnIndex;
import org.apache.cassandra.index.internal.composites.CollectionEntryIndex;
import org.apache.cassandra.index.internal.composites.CollectionKeyIndex;
import org.apache.cassandra.index.internal.composites.CollectionValueIndex;
import org.apache.cassandra.index.internal.composites.PartitionKeyIndex;
import org.apache.cassandra.index.internal.composites.RegularColumnIndex;
import org.apache.cassandra.index.internal.keys.KeysIndex;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;

public interface CassandraIndexFunctions {
    public static final CassandraIndexFunctions KEYS_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new KeysIndex(baseCfs, indexMetadata);
        }

        @Override
        public TableMetadata.Builder addIndexClusteringColumns(TableMetadata.Builder builder, TableMetadata baseMetadata, ColumnMetadata columnDef) {
            return builder;
        }
    };
    public static final CassandraIndexFunctions REGULAR_COLUMN_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new RegularColumnIndex(baseCfs, indexMetadata);
        }
    };
    public static final CassandraIndexFunctions CLUSTERING_COLUMN_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new ClusteringColumnIndex(baseCfs, indexMetadata);
        }

        @Override
        public TableMetadata.Builder addIndexClusteringColumns(TableMetadata.Builder builder, TableMetadata baseMetadata, ColumnMetadata columnDef) {
            ColumnMetadata def;
            int i;
            ImmutableList<ColumnMetadata> cks = baseMetadata.clusteringColumns();
            for (i = 0; i < columnDef.position(); ++i) {
                def = (ColumnMetadata)cks.get(i);
                builder.addClusteringColumn(def.name, def.type);
            }
            for (i = columnDef.position() + 1; i < cks.size(); ++i) {
                def = (ColumnMetadata)cks.get(i);
                builder.addClusteringColumn(def.name, def.type);
            }
            return builder;
        }
    };
    public static final CassandraIndexFunctions COLLECTION_KEY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionKeyIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnMetadata indexedColumn) {
            return ((CollectionType)indexedColumn.type).nameComparator();
        }

        @Override
        public AbstractType<?> getIndexedPartitionKeyType(ColumnMetadata indexedColumn) {
            assert (indexedColumn.type.isCollection());
            switch (((CollectionType)indexedColumn.type).kind) {
                case LIST: {
                    return ((ListType)indexedColumn.type).getElementsType();
                }
                case SET: {
                    return ((SetType)indexedColumn.type).getElementsType();
                }
                case MAP: {
                    return ((MapType)indexedColumn.type).getKeysType();
                }
            }
            throw new RuntimeException("Error collection type " + indexedColumn.type);
        }
    };
    public static final CassandraIndexFunctions PARTITION_KEY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new PartitionKeyIndex(baseCfs, indexMetadata);
        }
    };
    public static final CassandraIndexFunctions COLLECTION_VALUE_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionValueIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnMetadata indexedColumn) {
            return ((CollectionType)indexedColumn.type).valueComparator();
        }

        @Override
        public TableMetadata.Builder addIndexClusteringColumns(TableMetadata.Builder builder, TableMetadata baseMetadata, ColumnMetadata columnDef) {
            for (ColumnMetadata def : baseMetadata.clusteringColumns()) {
                builder.addClusteringColumn(def.name, def.type);
            }
            builder.addClusteringColumn("cell_path", ((CollectionType)columnDef.type).nameComparator());
            return builder;
        }

        @Override
        public AbstractType<?> getIndexedPartitionKeyType(ColumnMetadata indexedColumn) {
            assert (indexedColumn.type.isCollection());
            switch (((CollectionType)indexedColumn.type).kind) {
                case LIST: {
                    return ((ListType)indexedColumn.type).getElementsType();
                }
                case SET: {
                    return ((SetType)indexedColumn.type).getElementsType();
                }
                case MAP: {
                    return ((MapType)indexedColumn.type).getValuesType();
                }
            }
            throw new RuntimeException("Error collection type " + indexedColumn.type);
        }
    };
    public static final CassandraIndexFunctions COLLECTION_ENTRY_INDEX_FUNCTIONS = new CassandraIndexFunctions(){

        @Override
        public CassandraIndex newIndexInstance(ColumnFamilyStore baseCfs, IndexMetadata indexMetadata) {
            return new CollectionEntryIndex(baseCfs, indexMetadata);
        }

        @Override
        public AbstractType<?> getIndexedValueType(ColumnMetadata indexedColumn) {
            CollectionType colType = (CollectionType)indexedColumn.type;
            return CompositeType.getInstance(colType.nameComparator(), colType.valueComparator());
        }

        @Override
        public AbstractType<?> getIndexedPartitionKeyType(ColumnMetadata indexedColumn) {
            assert (indexedColumn.type.isCollection());
            return indexedColumn.type;
        }
    };

    public CassandraIndex newIndexInstance(ColumnFamilyStore var1, IndexMetadata var2);

    default public AbstractType<?> getIndexedValueType(ColumnMetadata indexedColumn) {
        return indexedColumn.type;
    }

    default public AbstractType<?> getIndexedPartitionKeyType(ColumnMetadata indexedColumn) {
        return indexedColumn.type;
    }

    default public TableMetadata.Builder addIndexClusteringColumns(TableMetadata.Builder builder, TableMetadata baseMetadata, ColumnMetadata cfDef) {
        for (ColumnMetadata def : baseMetadata.clusteringColumns()) {
            builder.addClusteringColumn(def.name, def.type);
        }
        return builder;
    }
}

