/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.services;

import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import org.apache.fineract.client.models.GetOfficesResponse;
import org.apache.fineract.client.models.GetOfficesTemplateResponse;
import org.apache.fineract.client.models.PostOfficesRequest;
import org.apache.fineract.client.models.PostOfficesResponse;
import org.apache.fineract.client.models.PutOfficesOfficeIdRequest;
import org.apache.fineract.client.models.PutOfficesOfficeIdResponse;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface OfficesApi {
    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/offices")
    public Call<PostOfficesResponse> createOffice(@Body PostOfficesRequest var1);

    @GET(value="v1/offices/downloadtemplate")
    public Call<Void> getOfficeTemplate(@Query(value="dateFormat") String var1);

    @Multipart
    @POST(value="v1/offices/uploadtemplate")
    public Call<String> postOfficeTemplate(@Part(value="dateFormat") String var1, @Part(value="locale") String var2, @Part MultipartBody.Part var3);

    @GET(value="v1/offices/{officeId}")
    public Call<GetOfficesResponse> retrieveOffice(@Path(value="officeId") Long var1);

    @GET(value="v1/offices/external-id/{externalId}")
    public Call<GetOfficesResponse> retrieveOfficeByExternalId(@Path(value="externalId") String var1);

    @GET(value="v1/offices/template")
    public Call<GetOfficesTemplateResponse> retrieveOfficeTemplate1();

    @GET(value="v1/offices")
    public Call<List<GetOfficesResponse>> retrieveOffices(@Query(value="includeAllOffices") Boolean var1, @Query(value="orderBy") String var2, @Query(value="sortOrder") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="v1/offices/{officeId}")
    public Call<PutOfficesOfficeIdResponse> updateOffice(@Path(value="officeId") Long var1, @Body PutOfficesOfficeIdRequest var2);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="v1/offices/external-id/{externalId}")
    public Call<PutOfficesOfficeIdResponse> updateOfficeWithExternalId(@Path(value="externalId") String var1, @Body PutOfficesOfficeIdRequest var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="v1/offices")
    public Call<PostOfficesResponse> createOffice(@Body PostOfficesRequest var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/offices/downloadtemplate")
    public Call<Void> getOfficeTemplate(@Query(value="dateFormat") String var1, @HeaderMap Map<String, String> var2);

    @Multipart
    @POST(value="v1/offices/uploadtemplate")
    public Call<String> postOfficeTemplate(@Part(value="dateFormat") String var1, @Part(value="locale") String var2, @Part MultipartBody.Part var3, @HeaderMap Map<String, String> var4);

    @GET(value="v1/offices/{officeId}")
    public Call<GetOfficesResponse> retrieveOffice(@Path(value="officeId") Long var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/offices/external-id/{externalId}")
    public Call<GetOfficesResponse> retrieveOfficeByExternalId(@Path(value="externalId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="v1/offices/template")
    public Call<GetOfficesTemplateResponse> retrieveOfficeTemplate1(@HeaderMap Map<String, String> var1);

    @GET(value="v1/offices")
    public Call<List<GetOfficesResponse>> retrieveOffices(@Query(value="includeAllOffices") Boolean var1, @Query(value="orderBy") String var2, @Query(value="sortOrder") String var3, @HeaderMap Map<String, String> var4);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="v1/offices/{officeId}")
    public Call<PutOfficesOfficeIdResponse> updateOffice(@Path(value="officeId") Long var1, @Body PutOfficesOfficeIdRequest var2, @HeaderMap Map<String, String> var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="v1/offices/external-id/{externalId}")
    public Call<PutOfficesOfficeIdResponse> updateOfficeWithExternalId(@Path(value="externalId") String var1, @Body PutOfficesOfficeIdRequest var2, @HeaderMap Map<String, String> var3);
}

