/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.CommandParameterUtil;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collectionsheet.api.CollectionSheetApiResourceSwagger;
import org.apache.fineract.portfolio.collectionsheet.data.CollectionSheetRequest;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/collectionsheet")
@Component
@Tag(name="Collection Sheet", description="")
public class CollectionSheetApiResource {
    private final CollectionSheetReadPlatformService collectionSheetReadPlatformService;
    private final ToApiJsonSerializer<Object> toApiJsonSerializer;
    private final FromJsonHelper fromJsonHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Generate Individual Collection Sheet | Save Collection Sheet", description="Generate Individual Collection Sheet:\n\nThis Api retrieves repayment details of all individual loans under a office as on a specified meeting date.\n\nSave Collection Sheet:\n\nThis Api allows the loan officer to perform bulk repayments of individual loans and deposit of mandatory savings on a given meeting date.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollectionSheetRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollectionSheetApiResourceSwagger.PostCollectionSheetResponse.class))})})
    public Response generateCollectionSheet(@QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) CollectionSheetRequest collectionSheetRequest) {
        String payload = this.toApiJsonSerializer.serialize((Object)collectionSheetRequest);
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(payload);
        if (CommandParameterUtil.is((String)commandParam, (String)"generateCollectionSheet")) {
            this.context.authenticatedUser().validateHasReadPermission("collectionsheet");
            JsonElement parsedQuery = this.fromJsonHelper.parse(payload);
            JsonQuery query = JsonQuery.from((String)payload, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            return Response.ok((Object)this.collectionSheetReadPlatformService.generateIndividualCollectionSheet(query)).build();
        }
        if (CommandParameterUtil.is((String)commandParam, (String)"saveCollectionSheet")) {
            CommandWrapper commandRequest = builder.saveIndividualCollectionSheet().build();
            return Response.ok((Object)this.commandsSourceWritePlatformService.logCommandSource(commandRequest)).build();
        }
        return Response.ok().build();
    }

    @Generated
    public CollectionSheetApiResource(CollectionSheetReadPlatformService collectionSheetReadPlatformService, ToApiJsonSerializer<Object> toApiJsonSerializer, FromJsonHelper fromJsonHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context) {
        this.collectionSheetReadPlatformService = collectionSheetReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.fromJsonHelper = fromJsonHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
    }
}

