/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeCount {
    final short REPLICATION_FACTOR = (short)2;
    final long TIMEOUT = 20000L;
    long timeout = 0L;
    long failtime = 0L;
    Block lastBlock = null;
    NumberReplicas lastNum = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNodeCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.startup.delay.block.deletion.sec", 60);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            FSNamesystem namesystem = cluster.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            HeartbeatManager hm = bm.getDatanodeManager().getHeartbeatManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            DatanodeDescriptor[] datanodes = hm.getDatanodes();
            cluster.startDataNodes((Configuration)conf, 2, true, null, null);
            cluster.waitActive();
            DatanodeDescriptor datanode = datanodes[0];
            MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(datanode.getXferAddr());
            BlockManagerTestUtil.noticeDeadDatanode(cluster.getNameNode(), datanode.getXferAddr());
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).excessReplicas() == 0) {
                this.checkTimeout("excess replicas not detected");
            }
            DatanodeDescriptor nonExcessDN = null;
            for (DatanodeStorageInfo storage : bm.blocksMap.getStorages(block.getLocalBlock())) {
                BlockInfoContiguous info;
                DatanodeDescriptor dn = storage.getDatanodeDescriptor();
                if (bm.isExcess(dn, (BlockInfo)(info = new BlockInfoContiguous(block.getLocalBlock(), 0)))) continue;
                nonExcessDN = dn;
                break;
            }
            Assert.assertTrue((nonExcessDN != null ? 1 : 0) != 0);
            dnprop = cluster.stopDataNode(nonExcessDN.getXferAddr());
            BlockManagerTestUtil.noticeDeadDatanode(cluster.getNameNode(), nonExcessDN.getXferAddr());
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).liveReplicas() != 2) {
                this.checkTimeout("live replica count not correct", 1000L);
            }
            cluster.restartDataNode(dnprop);
            cluster.waitActive();
            this.initializeTimeout(20000L);
            while (this.countNodes(block.getLocalBlock(), namesystem).excessReplicas() != 2) {
                this.checkTimeout("excess replica count not equal to 2");
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    void initializeTimeout(long timeout) {
        this.timeout = timeout;
        this.failtime = Time.monotonicNow() + (timeout <= 0L ? Long.MAX_VALUE : timeout);
    }

    void checkTimeout(String testLabel) throws TimeoutException {
        this.checkTimeout(testLabel, 10L);
    }

    void checkTimeout(String testLabel, long cycleTime) throws TimeoutException {
        if (Time.monotonicNow() > this.failtime) {
            throw new TimeoutException("Timeout: " + testLabel + " for block " + this.lastBlock + " after " + this.timeout + " msec.  Last counts: live = " + this.lastNum.liveReplicas() + ", excess = " + this.lastNum.excessReplicas() + ", corrupt = " + this.lastNum.corruptReplicas());
        }
        if (cycleTime > 0L) {
            try {
                Thread.sleep(cycleTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NumberReplicas countNodes(Block block, FSNamesystem namesystem) {
        BlockManager blockManager = namesystem.getBlockManager();
        namesystem.readLock();
        try {
            this.lastBlock = block;
            NumberReplicas numberReplicas = this.lastNum = blockManager.countNodes(blockManager.getStoredBlock(block));
            return numberReplicas;
        }
        finally {
            namesystem.readUnlock();
        }
    }
}

