/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.state;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.tools.rumen.state.State;
import org.apache.hadoop.tools.rumen.state.StatePool;

public class StateDeserializer
extends StdDeserializer<StatePool.StatePair> {
    public StateDeserializer() {
        super(StatePool.StatePair.class);
    }

    public StatePool.StatePair deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        ObjectNode statePairObject = (ObjectNode)mapper.readTree(parser);
        Class<?> stateClass = null;
        try {
            stateClass = Class.forName(statePairObject.get("className").textValue().trim());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Invalid classname!", cnfe);
        }
        String stateJsonString = statePairObject.get("state").toString();
        State state = (State)mapper.readValue(stateJsonString, stateClass);
        return new StatePool.StatePair(state);
    }
}

