/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.config.units;

import org.apache.hadoop.shaded.org.ehcache.config.ResourceUnit;

public enum MemoryUnit implements ResourceUnit
{
    B("B", 0),
    KB("kB", 10),
    MB("MB", 20),
    GB("GB", 30),
    TB("TB", 40),
    PB("PB", 50);

    private final int index;
    private final String stringForm;

    private MemoryUnit(String stringForm, int index) {
        this.stringForm = stringForm;
        this.index = index;
    }

    private static long doConvert(int delta, long amount) throws ArithmeticException {
        if (delta == 0 || amount == 0L) {
            return amount;
        }
        if (delta < 0) {
            long t = amount >> -delta - 1;
            t >>>= 64 + delta;
            return (t += amount) >> -delta;
        }
        if (delta >= Long.numberOfLeadingZeros(amount < 0L ? amount ^ 0xFFFFFFFFFFFFFFFFL : amount)) {
            throw new ArithmeticException("Conversion overflows");
        }
        return amount << delta;
    }

    public long toBytes(long quantity) {
        return MemoryUnit.doConvert(this.index - MemoryUnit.B.index, quantity);
    }

    public long convert(long quantity, MemoryUnit unit) {
        return MemoryUnit.doConvert(unit.index - this.index, quantity);
    }

    public String toString() {
        return this.stringForm;
    }

    @Override
    public int compareTo(long thisSize, long thatSize, ResourceUnit thatUnit) throws IllegalArgumentException {
        if (thatUnit instanceof MemoryUnit) {
            MemoryUnit mThatUnit = (MemoryUnit)thatUnit;
            if (this.index < mThatUnit.index) {
                try {
                    return Long.signum(thisSize - this.convert(thatSize, mThatUnit));
                }
                catch (ArithmeticException e) {
                    return Long.signum(mThatUnit.convert(thisSize, this) - thatSize);
                }
            }
            try {
                return Long.signum(mThatUnit.convert(thisSize, this) - thatSize);
            }
            catch (ArithmeticException e) {
                return Long.signum(thisSize - this.convert(thatSize, mThatUnit));
            }
        }
        throw new IllegalArgumentException();
    }
}

