/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.xml;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.builders.CacheConfigurationBuilder;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.CacheServiceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.CoreServiceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheTemplate;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheType;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultCacheEventDispatcherConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultCacheEventListenerConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultCacheLoaderWriterConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultCopierConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultResilienceStrategyConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultSerializerConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultSizeOfEngineConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.DefaultWriteBehindConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.service.OffHeapDiskStoreConfigurationParser;
import org.w3c.dom.Element;

public class ServiceConfigurationParser {
    static final Collection<CoreServiceConfigurationParser> CORE_SERVICE_CONFIGURATION_PARSERS = Arrays.asList(new DefaultSerializerConfigurationParser(), new DefaultCopierConfigurationParser(), new DefaultCacheLoaderWriterConfigurationParser(), new DefaultResilienceStrategyConfigurationParser(), new DefaultSizeOfEngineConfigurationParser(), new DefaultWriteBehindConfigurationParser(), new OffHeapDiskStoreConfigurationParser(), new DefaultCacheEventDispatcherConfigurationParser(), new DefaultCacheEventListenerConfigurationParser());
    private final Map<Class<?>, CacheServiceConfigurationParser<?>> extensionParsers;

    public ServiceConfigurationParser(Map<Class<?>, CacheServiceConfigurationParser<?>> extensionParsers) {
        this.extensionParsers = extensionParsers;
    }

    public <K, V> CacheConfigurationBuilder<K, V> parseConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        for (CoreServiceConfigurationParser coreServiceConfigParser : CORE_SERVICE_CONFIGURATION_PARSERS) {
            cacheBuilder = coreServiceConfigParser.parseServiceConfiguration(cacheDefinition, cacheClassLoader, cacheBuilder);
        }
        Map parsers = this.extensionParsers.values().stream().collect(Collectors.toMap(CacheServiceConfigurationParser::getNamespace, Function.identity()));
        for (Element element : cacheDefinition.serviceConfigExtensions()) {
            URI namespace = URI.create(element.getNamespaceURI());
            CacheServiceConfigurationParser xmlConfigurationParser = (CacheServiceConfigurationParser)parsers.get(namespace);
            if (xmlConfigurationParser == null) {
                throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
            }
            cacheBuilder = cacheBuilder.withService(xmlConfigurationParser.parseServiceConfiguration(element, cacheClassLoader));
        }
        return cacheBuilder;
    }

    CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        for (CoreServiceConfigurationParser parser : CORE_SERVICE_CONFIGURATION_PARSERS) {
            parser.unparseServiceConfiguration(cacheConfiguration, cacheType);
        }
        List<Element> serviceConfigs = cacheType.getServiceConfiguration();
        cacheConfiguration.getServiceConfigurations().forEach(config -> {
            CacheServiceConfigurationParser<?> parser = this.extensionParsers.get(config.getServiceType());
            if (parser != null) {
                Element element = parser.unparseServiceConfiguration((ServiceConfiguration<?, ?>)config);
                serviceConfigs.add(element);
            }
        });
        return cacheType;
    }
}

