/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.SafeFutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.DataStructures;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.conditions.Condition;

public final class StateHolder<E> {
    private static final Logger _logger = Grizzly.logger(StateHolder.class);
    private volatile E state;
    private final ReentrantReadWriteLock readWriteLock;
    private final Collection<ConditionElement<E>> conditionListeners;

    public StateHolder() {
        this(null);
    }

    public StateHolder(E initialState) {
        this.state = initialState;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.conditionListeners = DataStructures.getLTQInstance();
    }

    public E getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(E state) {
        this.readWriteLock.writeLock().lock();
        try {
            this.state = state;
            this.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().unlock();
            this.notifyConditionListeners();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public ReentrantReadWriteLock getStateLocker() {
        return this.readWriteLock;
    }

    public Future<E> notifyWhenStateIsEqual(final E state, CompletionHandler<E> completionHandler) {
        return this.notifyWhenConditionMatchState(new Condition(){

            @Override
            public boolean check() {
                return state == StateHolder.this.state;
            }
        }, completionHandler);
    }

    public Future<E> notifyWhenStateIsNotEqual(final E state, CompletionHandler<E> completionHandler) {
        return this.notifyWhenConditionMatchState(new Condition(){

            @Override
            public boolean check() {
                return state != StateHolder.this.state;
            }
        }, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<E> notifyWhenConditionMatchState(Condition condition, CompletionHandler<E> completionHandler) {
        FutureImpl<Object> resultFuture;
        this.readWriteLock.readLock().lock();
        try {
            if (condition.check()) {
                if (completionHandler != null) {
                    completionHandler.completed(this.state);
                }
                resultFuture = ReadyFutureImpl.create(this.state);
            } else {
                SafeFutureImpl future = SafeFutureImpl.create();
                ConditionElement elem = new ConditionElement(condition, future, completionHandler);
                this.conditionListeners.add(elem);
                resultFuture = future;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return resultFuture;
    }

    protected void notifyConditionListeners() {
        Iterator<ConditionElement<E>> it = this.conditionListeners.iterator();
        while (it.hasNext()) {
            ConditionElement<E> element = it.next();
            try {
                if (!((ConditionElement)element).condition.check()) continue;
                it.remove();
                if (((ConditionElement)element).completionHandler != null) {
                    ((ConditionElement)element).completionHandler.completed(this.state);
                }
                ((ConditionElement)element).future.result(this.state);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_STATE_HOLDER_CALLING_CONDITIONLISTENER_EXCEPTION(), e);
            }
        }
    }

    protected static final class ConditionElement<E> {
        private final Condition condition;
        private final FutureImpl<E> future;
        private final CompletionHandler<E> completionHandler;

        public ConditionElement(Condition condition, FutureImpl<E> future, CompletionHandler<E> completionHandler) {
            this.condition = condition;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        public CompletionHandler<E> getCompletionHandler() {
            return this.completionHandler;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public FutureImpl<E> getFuture() {
            return this.future;
        }
    }
}

