/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;

public class AppPriorityACLGroup
implements Comparable<AppPriorityACLGroup> {
    private Priority maxPriority = null;
    private Priority defaultPriority = null;
    private AccessControlList aclList = null;

    public AppPriorityACLGroup(Priority maxPriority, Priority defaultPriority, AccessControlList aclList) {
        this.setMaxPriority(Priority.newInstance((int)maxPriority.getPriority()));
        this.setDefaultPriority(Priority.newInstance((int)defaultPriority.getPriority()));
        this.setACLList(aclList);
    }

    public AppPriorityACLGroup() {
    }

    @Override
    public int compareTo(AppPriorityACLGroup o) {
        return this.getMaxPriority().compareTo(o.getMaxPriority());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppPriorityACLGroup other = (AppPriorityACLGroup)obj;
        if (this.getMaxPriority() != other.getMaxPriority()) {
            return false;
        }
        return this.getDefaultPriority() == other.getDefaultPriority();
    }

    public int hashCode() {
        int prime = 517861;
        int result = 9511;
        result = 517861 * result + this.getMaxPriority().getPriority();
        result = 517861 * result + this.getDefaultPriority().getPriority();
        return result;
    }

    public Priority getMaxPriority() {
        return this.maxPriority;
    }

    public Priority getDefaultPriority() {
        return this.defaultPriority;
    }

    public AccessControlList getACLList() {
        return this.aclList;
    }

    public void setMaxPriority(Priority maxPriority) {
        this.maxPriority = maxPriority;
    }

    public void setDefaultPriority(Priority defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public void setACLList(AccessControlList accessControlList) {
        this.aclList = accessControlList;
    }
}

