/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.naming.NamingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.RuleBasedLdapGroupsMapping;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestRuleBasedLdapGroupsMapping {
    @Test
    public void testGetGroupsToUpper() throws NamingException {
        RuleBasedLdapGroupsMapping groupsMapping = (RuleBasedLdapGroupsMapping)Mockito.spy((Object)new RuleBasedLdapGroupsMapping());
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.add("group1");
        groups.add("group2");
        ((LdapGroupsMapping)Mockito.doReturn(groups).when((Object)groupsMapping)).doGetGroups((String)ArgumentMatchers.eq((Object)"admin"), ArgumentMatchers.anyInt());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        conf.set("hadoop.security.group.mapping.ldap.conversion.rule", "to_upper");
        groupsMapping.setConf(conf);
        ArrayList<String> groupsUpper = new ArrayList<String>();
        groupsUpper.add("GROUP1");
        groupsUpper.add("GROUP2");
        Assert.assertEquals(groupsUpper, (Object)groupsMapping.getGroups("admin"));
    }

    @Test
    public void testGetGroupsToLower() throws NamingException {
        RuleBasedLdapGroupsMapping groupsMapping = (RuleBasedLdapGroupsMapping)Mockito.spy((Object)new RuleBasedLdapGroupsMapping());
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.add("GROUP1");
        groups.add("GROUP2");
        ((LdapGroupsMapping)Mockito.doReturn(groups).when((Object)groupsMapping)).doGetGroups((String)ArgumentMatchers.eq((Object)"admin"), ArgumentMatchers.anyInt());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        conf.set("hadoop.security.group.mapping.ldap.conversion.rule", "to_lower");
        groupsMapping.setConf(conf);
        ArrayList<String> groupsLower = new ArrayList<String>();
        groupsLower.add("group1");
        groupsLower.add("group2");
        Assert.assertEquals(groupsLower, (Object)groupsMapping.getGroups("admin"));
    }

    @Test
    public void testGetGroupsInvalidRule() throws NamingException {
        RuleBasedLdapGroupsMapping groupsMapping = (RuleBasedLdapGroupsMapping)Mockito.spy((Object)new RuleBasedLdapGroupsMapping());
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.add("group1");
        groups.add("GROUP2");
        ((LdapGroupsMapping)Mockito.doReturn(groups).when((Object)groupsMapping)).doGetGroups((String)ArgumentMatchers.eq((Object)"admin"), ArgumentMatchers.anyInt());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        conf.set("hadoop.security.group.mapping.ldap.conversion.rule", "none");
        groupsMapping.setConf(conf);
        Assert.assertEquals(groups, (Object)groupsMapping.getGroupsSet("admin"));
    }
}

