/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.prefetcher;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;

public class SequentialReadProgression {
    private final PhysicalIOConfiguration configuration;

    public long getSizeForGeneration(long generation) {
        Preconditions.checkArgument(0L <= generation, "`generation` must be non-negative");
        return 0x200000L * (long)Math.pow(this.configuration.getSequentialPrefetchBase(), Math.floor(this.configuration.getSequentialPrefetchSpeed() * (double)generation));
    }

    @Generated
    public SequentialReadProgression(PhysicalIOConfiguration configuration) {
        this.configuration = configuration;
    }
}

