/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.nativetask.INativeComparable;
import org.apache.hadoop.mapred.nativetask.Platform;
import org.apache.hadoop.mapred.nativetask.serde.BoolWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.ByteWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.BytesWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.DefaultSerializer;
import org.apache.hadoop.mapred.nativetask.serde.DoubleWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.FloatWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;
import org.apache.hadoop.mapred.nativetask.serde.IntWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.LongWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.NullWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.TextSerializer;
import org.apache.hadoop.mapred.nativetask.serde.VIntWritableSerializer;
import org.apache.hadoop.mapred.nativetask.serde.VLongWritableSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HadoopPlatform
extends Platform {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopPlatform.class);

    @Override
    public void init() throws IOException {
        this.registerKey(NullWritable.class.getName(), NullWritableSerializer.class);
        this.registerKey(Text.class.getName(), TextSerializer.class);
        this.registerKey(LongWritable.class.getName(), LongWritableSerializer.class);
        this.registerKey(IntWritable.class.getName(), IntWritableSerializer.class);
        this.registerKey(Writable.class.getName(), DefaultSerializer.class);
        this.registerKey(BytesWritable.class.getName(), BytesWritableSerializer.class);
        this.registerKey(BooleanWritable.class.getName(), BoolWritableSerializer.class);
        this.registerKey(ByteWritable.class.getName(), ByteWritableSerializer.class);
        this.registerKey(FloatWritable.class.getName(), FloatWritableSerializer.class);
        this.registerKey(DoubleWritable.class.getName(), DoubleWritableSerializer.class);
        this.registerKey(VIntWritable.class.getName(), VIntWritableSerializer.class);
        this.registerKey(VLongWritable.class.getName(), VLongWritableSerializer.class);
        LOG.info("Hadoop platform inited");
    }

    @Override
    public boolean support(String keyClassName, INativeSerializer<?> serializer, JobConf job) {
        return this.keyClassNames.contains(keyClassName) && serializer instanceof INativeComparable;
    }

    @Override
    public boolean define(Class<?> comparatorClass) {
        return false;
    }

    @Override
    public String name() {
        return "Hadoop";
    }
}

