/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractContinuous;

public class Exponential
extends AbstractContinuous {
    private static final long serialVersionUID = -720007692511649669L;
    private final double myRate;

    public Exponential() {
        this(PrimitiveMath.ONE);
    }

    public Exponential(double aRate) {
        this.myRate = aRate;
    }

    @Override
    public double getDistribution(double value) {
        if (value < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return PrimitiveMath.ONE - PrimitiveFunction.EXP.invoke(-this.myRate * value);
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    public double getProbability(double value) {
        if (value < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return this.myRate * PrimitiveFunction.EXP.invoke(-this.myRate * value);
    }

    @Override
    public double getQuantile(double probality) {
        this.checkProbabilty(probality);
        return PrimitiveFunction.LOG.invoke(PrimitiveMath.ONE - probality) / -this.myRate;
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    protected double generate() {
        return -PrimitiveFunction.LOG.invoke(this.random().nextDouble()) / this.myRate;
    }
}

