/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdUUID;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.UUID;

final class RntbdRequestFrame {
    static final int LENGTH = 24;
    private final UUID activityId;
    private final RntbdConstants.RntbdOperationType operationType;
    private final RntbdConstants.RntbdResourceType resourceType;

    RntbdRequestFrame(String activityId, OperationType operationType, ResourceType resourceType) {
        this(UUID.fromString(activityId), RntbdRequestFrame.map(operationType), RntbdRequestFrame.map(resourceType));
    }

    RntbdRequestFrame(UUID activityId, RntbdConstants.RntbdOperationType operationType, RntbdConstants.RntbdResourceType resourceType) {
        this.activityId = activityId;
        this.operationType = operationType;
        this.resourceType = resourceType;
    }

    static RntbdRequestFrame decode(ByteBuf in) {
        RntbdConstants.RntbdResourceType resourceType = RntbdConstants.RntbdResourceType.fromId(in.readShortLE());
        RntbdConstants.RntbdOperationType operationType = RntbdConstants.RntbdOperationType.fromId(in.readShortLE());
        UUID activityId = RntbdUUID.decode(in);
        return new RntbdRequestFrame(activityId, operationType, resourceType);
    }

    private static RntbdConstants.RntbdResourceType map(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return RntbdConstants.RntbdResourceType.Attachment;
            }
            case DocumentCollection: {
                return RntbdConstants.RntbdResourceType.Collection;
            }
            case Conflict: {
                return RntbdConstants.RntbdResourceType.Conflict;
            }
            case Database: {
                return RntbdConstants.RntbdResourceType.Database;
            }
            case Document: {
                return RntbdConstants.RntbdResourceType.Document;
            }
            case Module: {
                return RntbdConstants.RntbdResourceType.Module;
            }
            case ModuleCommand: {
                return RntbdConstants.RntbdResourceType.ModuleCommand;
            }
            case Record: {
                return RntbdConstants.RntbdResourceType.Record;
            }
            case Permission: {
                return RntbdConstants.RntbdResourceType.Permission;
            }
            case Replica: {
                return RntbdConstants.RntbdResourceType.Replica;
            }
            case StoredProcedure: {
                return RntbdConstants.RntbdResourceType.StoredProcedure;
            }
            case Trigger: {
                return RntbdConstants.RntbdResourceType.Trigger;
            }
            case User: {
                return RntbdConstants.RntbdResourceType.User;
            }
            case UserDefinedType: {
                return RntbdConstants.RntbdResourceType.UserDefinedType;
            }
            case UserDefinedFunction: {
                return RntbdConstants.RntbdResourceType.UserDefinedFunction;
            }
            case Offer: {
                return RntbdConstants.RntbdResourceType.Offer;
            }
            case PartitionSetInformation: {
                return RntbdConstants.RntbdResourceType.PartitionSetInformation;
            }
            case XPReplicatorAddress: {
                return RntbdConstants.RntbdResourceType.XPReplicatorAddress;
            }
            case MasterPartition: {
                return RntbdConstants.RntbdResourceType.MasterPartition;
            }
            case ServerPartition: {
                return RntbdConstants.RntbdResourceType.ServerPartition;
            }
            case DatabaseAccount: {
                return RntbdConstants.RntbdResourceType.DatabaseAccount;
            }
            case Topology: {
                return RntbdConstants.RntbdResourceType.Topology;
            }
            case PartitionKeyRange: {
                return RntbdConstants.RntbdResourceType.PartitionKeyRange;
            }
            case Schema: {
                return RntbdConstants.RntbdResourceType.Schema;
            }
            case BatchApply: {
                return RntbdConstants.RntbdResourceType.BatchApply;
            }
            case RestoreMetadata: {
                return RntbdConstants.RntbdResourceType.RestoreMetadata;
            }
            case ComputeGatewayCharges: {
                return RntbdConstants.RntbdResourceType.ComputeGatewayCharges;
            }
            case RidRange: {
                return RntbdConstants.RntbdResourceType.RidRange;
            }
        }
        String reason = String.format(Locale.ROOT, "Unrecognized resource type: %s", resourceType);
        throw new UnsupportedOperationException(reason);
    }

    private static RntbdConstants.RntbdOperationType map(OperationType operationType) {
        switch (operationType) {
            case Crash: {
                return RntbdConstants.RntbdOperationType.Crash;
            }
            case Create: {
                return RntbdConstants.RntbdOperationType.Create;
            }
            case Delete: {
                return RntbdConstants.RntbdOperationType.Delete;
            }
            case ExecuteJavaScript: {
                return RntbdConstants.RntbdOperationType.ExecuteJavaScript;
            }
            case Query: {
                return RntbdConstants.RntbdOperationType.Query;
            }
            case Pause: {
                return RntbdConstants.RntbdOperationType.Pause;
            }
            case Read: {
                return RntbdConstants.RntbdOperationType.Read;
            }
            case ReadFeed: {
                return RntbdConstants.RntbdOperationType.ReadFeed;
            }
            case Recreate: {
                return RntbdConstants.RntbdOperationType.Recreate;
            }
            case Recycle: {
                return RntbdConstants.RntbdOperationType.Recycle;
            }
            case Replace: {
                return RntbdConstants.RntbdOperationType.Replace;
            }
            case Resume: {
                return RntbdConstants.RntbdOperationType.Resume;
            }
            case Stop: {
                return RntbdConstants.RntbdOperationType.Stop;
            }
            case SqlQuery: {
                return RntbdConstants.RntbdOperationType.SQLQuery;
            }
            case Update: {
                return RntbdConstants.RntbdOperationType.Update;
            }
            case ForceConfigRefresh: {
                return RntbdConstants.RntbdOperationType.ForceConfigRefresh;
            }
            case Head: {
                return RntbdConstants.RntbdOperationType.Head;
            }
            case HeadFeed: {
                return RntbdConstants.RntbdOperationType.HeadFeed;
            }
            case Upsert: {
                return RntbdConstants.RntbdOperationType.Upsert;
            }
            case Throttle: {
                return RntbdConstants.RntbdOperationType.Throttle;
            }
            case PreCreateValidation: {
                return RntbdConstants.RntbdOperationType.PreCreateValidation;
            }
            case GetSplitPoint: {
                return RntbdConstants.RntbdOperationType.GetSplitPoint;
            }
            case AbortSplit: {
                return RntbdConstants.RntbdOperationType.AbortSplit;
            }
            case CompleteSplit: {
                return RntbdConstants.RntbdOperationType.CompleteSplit;
            }
            case BatchApply: {
                return RntbdConstants.RntbdOperationType.BatchApply;
            }
            case OfferUpdateOperation: {
                return RntbdConstants.RntbdOperationType.OfferUpdateOperation;
            }
            case OfferPreGrowValidation: {
                return RntbdConstants.RntbdOperationType.OfferPreGrowValidation;
            }
            case BatchReportThroughputUtilization: {
                return RntbdConstants.RntbdOperationType.BatchReportThroughputUtilization;
            }
            case AbortPartitionMigration: {
                return RntbdConstants.RntbdOperationType.AbortPartitionMigration;
            }
            case CompletePartitionMigration: {
                return RntbdConstants.RntbdOperationType.CompletePartitionMigration;
            }
            case PreReplaceValidation: {
                return RntbdConstants.RntbdOperationType.PreReplaceValidation;
            }
            case MigratePartition: {
                return RntbdConstants.RntbdOperationType.MigratePartition;
            }
            case AddComputeGatewayRequestCharges: {
                return RntbdConstants.RntbdOperationType.AddComputeGatewayRequestCharges;
            }
        }
        String reason = String.format(Locale.ROOT, "Unrecognized operation type: %s", operationType);
        throw new UnsupportedOperationException(reason);
    }

    UUID getActivityId() {
        return this.activityId;
    }

    RntbdConstants.RntbdOperationType getOperationType() {
        return this.operationType;
    }

    RntbdConstants.RntbdResourceType getResourceType() {
        return this.resourceType;
    }

    void encode(ByteBuf out) {
        out.writeShortLE((int)this.resourceType.id());
        out.writeShortLE((int)this.operationType.id());
        RntbdUUID.encode(this.activityId, out);
    }
}

