/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.apache.zookeeper.Quotas;
import org.apache.hadoop.shaded.org.apache.zookeeper.StatsTrack;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.PathUtils;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTree;

public final class QuotaMetricsUtils {
    public static final String QUOTA_COUNT_LIMIT_PER_NAMESPACE = "quota_count_limit_per_namespace";
    public static final String QUOTA_BYTES_LIMIT_PER_NAMESPACE = "quota_bytes_limit_per_namespace";
    public static final String QUOTA_COUNT_USAGE_PER_NAMESPACE = "quota_count_usage_per_namespace";
    public static final String QUOTA_BYTES_USAGE_PER_NAMESPACE = "quota_bytes_usage_per_namespace";
    public static final String QUOTA_EXCEEDED_ERROR_PER_NAMESPACE = "quota_exceeded_error_per_namespace";
    static final String LIMIT_END_STRING = "/zookeeper_limits";
    static final String STATS_END_STRING = "/zookeeper_stats";

    private QuotaMetricsUtils() {
    }

    public static Map<String, Number> getQuotaCountLimit(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT);
    }

    public static Map<String, Number> getQuotaBytesLimit(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT);
    }

    public static Map<String, Number> getQuotaCountUsage(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE);
    }

    public static Map<String, Number> getQuotaBytesUsage(DataTree dataTree) {
        return QuotaMetricsUtils.getQuotaLimitOrUsage(dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE);
    }

    private static Map<String, Number> getQuotaLimitOrUsage(DataTree dataTree, QUOTA_LIMIT_USAGE_METRIC_TYPE type) {
        ConcurrentHashMap<String, Number> metricsMap = new ConcurrentHashMap<String, Number>();
        if (dataTree != null) {
            QuotaMetricsUtils.getQuotaLimitOrUsage("/zookeeper/quota", metricsMap, type, dataTree);
        }
        return metricsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getQuotaLimitOrUsage(String path, Map<String, Number> metricsMap, QUOTA_LIMIT_USAGE_METRIC_TYPE type, DataTree dataTree) {
        String[] node = dataTree.getNode(path);
        if (node == null) {
            return;
        }
        String[] stringArray = node;
        synchronized (node) {
            String[] children = node.getChildren().toArray(new String[0]);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (children.length == 0) {
                if (QuotaMetricsUtils.shouldCollect(path, type)) {
                    QuotaMetricsUtils.collectQuotaLimitOrUsage(path, (DataNode)node, metricsMap, type);
                }
                return;
            }
            for (String child : children) {
                QuotaMetricsUtils.getQuotaLimitOrUsage(path + "/" + child, metricsMap, type, dataTree);
            }
            return;
        }
    }

    static boolean shouldCollect(String path, QUOTA_LIMIT_USAGE_METRIC_TYPE type) {
        return path.endsWith(LIMIT_END_STRING) && (QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_LIMIT == type || QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_LIMIT == type) || path.endsWith(STATS_END_STRING) && (QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_COUNT_USAGE == type || QUOTA_LIMIT_USAGE_METRIC_TYPE.QUOTA_BYTES_USAGE == type);
    }

    static void collectQuotaLimitOrUsage(String path, DataNode node, Map<String, Number> metricsMap, QUOTA_LIMIT_USAGE_METRIC_TYPE type) {
        String namespace = PathUtils.getTopNamespace(Quotas.trimQuotaPath(path));
        if (namespace == null) {
            return;
        }
        byte[] data = node.getData();
        if (data == null) {
            return;
        }
        StatsTrack statsTrack = new StatsTrack(data);
        switch (type) {
            case QUOTA_COUNT_LIMIT: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(namespace, metricsMap, QuotaMetricsUtils.getQuotaLimit(statsTrack.getCountHardLimit(), statsTrack.getCount()));
                break;
            }
            case QUOTA_BYTES_LIMIT: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(namespace, metricsMap, QuotaMetricsUtils.getQuotaLimit(statsTrack.getByteHardLimit(), statsTrack.getBytes()));
                break;
            }
            case QUOTA_COUNT_USAGE: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(namespace, metricsMap, statsTrack.getCount());
                break;
            }
            case QUOTA_BYTES_USAGE: {
                QuotaMetricsUtils.aggregateQuotaLimitOrUsage(namespace, metricsMap, statsTrack.getBytes());
                break;
            }
        }
    }

    static long getQuotaLimit(long hardLimit, long limit) {
        return hardLimit > -1L ? hardLimit : limit;
    }

    private static void aggregateQuotaLimitOrUsage(String namespace, Map<String, Number> metricsMap, long limitOrUsage) {
        metricsMap.put(namespace, metricsMap.getOrDefault(namespace, 0).longValue() + limitOrUsage);
    }

    static enum QUOTA_LIMIT_USAGE_METRIC_TYPE {
        QUOTA_COUNT_LIMIT,
        QUOTA_BYTES_LIMIT,
        QUOTA_COUNT_USAGE,
        QUOTA_BYTES_USAGE;

    }
}

