/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http;

import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Cacheable;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpContent;

public final class ParsingResult
implements Cacheable {
    private static final ThreadCache.CachedTypeIndex<ParsingResult> CACHE_IDX = ThreadCache.obtainIndex(ParsingResult.class, 1);
    private HttpContent httpContent;
    private Buffer remainderBuffer;

    public static ParsingResult create(HttpContent httpContent, Buffer remainderBuffer) {
        ParsingResult resultObject = ThreadCache.takeFromCache(CACHE_IDX);
        if (resultObject == null) {
            resultObject = new ParsingResult();
        }
        resultObject.httpContent = httpContent;
        resultObject.remainderBuffer = remainderBuffer;
        return resultObject;
    }

    private ParsingResult() {
    }

    public Buffer getRemainderBuffer() {
        return this.remainderBuffer;
    }

    public HttpContent getHttpContent() {
        return this.httpContent;
    }

    @Override
    public void recycle() {
        this.remainderBuffer = null;
        this.httpContent = null;
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

