/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.scalar.Scalar;

final class ConjugatedStore<N extends Number>
extends TransjugatedStore<N> {
    ConjugatedStore(MatrixStore<N> base) {
        super(base);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this.getBase();
    }

    @Override
    public N get(long aRow, long aCol) {
        return ((Scalar)this.getBase().toScalar((int)aCol, (int)aRow).conjugate()).getNumber();
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        MatrixStore<MatrixStore<N>> retVal;
        if (right instanceof ConjugatedStore) {
            retVal = ((ConjugatedStore)right).getOriginal().multiply(this.getBase());
            retVal = new ConjugatedStore<MatrixStore<MatrixStore<N>>>(retVal);
        } else {
            retVal = super.multiply(right);
        }
        return retVal;
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return (Scalar)this.getBase().toScalar(column, row).conjugate();
    }
}

