/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.CharacterRing;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.TypeUtils;

public final class NewIntegerSolver
extends IntegerSolver {
    private final PriorityBlockingQueue<NodeKey> myNodesToTry = new PriorityBlockingQueue();
    private final int[] myIntegerIndeces;
    private final double[] myIntegerSignificances;
    boolean normal = true;

    NewIntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(model, solverOptions);
        List<Variable> tmpIntegerVariables = model.getIntegerVariables();
        this.myIntegerIndeces = new int[tmpIntegerVariables.size()];
        this.myIntegerSignificances = new double[tmpIntegerVariables.size()];
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            Variable tmpVariable = tmpIntegerVariables.get(i);
            this.myIntegerIndeces[i] = model.indexOf(tmpVariable);
        }
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (kickStarter != null && kickStarter.getState().isFeasible() && this.getModel().validate(kickStarter)) {
            this.markInteger(null, kickStarter);
        }
        this.resetIterationsCount();
        this.setup();
        Optimisation.Result retVal = this.getBestResultSoFar();
        retVal = retVal.getState().isFeasible() ? (this.normal ? new Optimisation.Result(Optimisation.State.OPTIMAL, retVal) : new Optimisation.Result(Optimisation.State.FEASIBLE, retVal)) : (this.normal ? new Optimisation.Result(Optimisation.State.INFEASIBLE, retVal) : new Optimisation.Result(Optimisation.State.FAILED, retVal));
        return retVal;
    }

    public String toString() {
        return TypeUtils.format("Solutions={} Nodes/Iterations={} {}", this.countIntegerSolutions(), this.countExploredNodes(), this.getBestResultSoFar());
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return (MatrixStore)PrimitiveDenseStore.FACTORY.columns(this.getBestResultSoFar());
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return !this.getState().isOptimal();
    }

    @Override
    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        try {
            retVal = this.getModel().validate();
            if (!retVal) {
                retVal = false;
                this.setState(Optimisation.State.INVALID);
            }
        }
        catch (Exception ex) {
            retVal = false;
            this.setState(Optimisation.State.FAILED);
        }
        return retVal;
    }

    boolean add(NodeKey e) {
        return this.myNodesToTry.add(e);
    }

    void compute(NodeKey nodeKey) {
        if (this.isDebug()) {
            this.debug("\nBranch&Bound Node", new Object[0]);
            this.debug(nodeKey.toString(), new Object[0]);
            this.debug(this.toString(), new Object[0]);
        }
        if (!this.isIterationAllowed() || !this.isIterationNecessary()) {
            if (this.isDebug()) {
                this.debug("Reached iterations or time limit - stop!", new Object[0]);
            }
            this.normal &= false;
        }
        if (!this.isGoodEnoughToContinueBranching(nodeKey.objective)) {
            if (this.isDebug()) {
                this.debug("No longer a relevant node!", new Object[0]);
            }
            this.normal &= true;
        }
        ExpressionsBasedModel tmpModel = this.makeNodeModel(nodeKey);
        Optimisation.Result tmpResult = tmpModel.solve(this.getBestResultSoFar());
        this.incrementIterationsCount();
        if (tmpModel.options.debug_appender != null && tmpModel.options.debug_appender instanceof CharacterRing.PrinterBuffer && this.getModel().options.debug_appender != null) {
            ((CharacterRing.PrinterBuffer)tmpModel.options.debug_appender).flush(this.getModel().options.debug_appender);
        }
        if (tmpResult.getState().isOptimal()) {
            if (this.isDebug()) {
                this.debug("Node solved to optimality!", new Object[0]);
            }
            if (this.options.validate && !tmpModel.validate(tmpResult)) {
                this.debug("Node solution marked as OPTIMAL, but is actually INVALID/INFEASIBLE/FAILED. Stop this branch!", new Object[0]);
                this.normal &= false;
            }
            int tmpBranchIndex = this.identifyNonIntegerVariable(tmpResult, nodeKey);
            double tmpSolutionValue = this.evaluateFunction(tmpResult);
            if (tmpBranchIndex == -1) {
                if (this.isDebug()) {
                    this.debug("Integer solution! Store it among the others, and stop this branch!", new Object[0]);
                }
                Optimisation.Result tmpIntegerSolutionResult = new Optimisation.Result(Optimisation.State.FEASIBLE, tmpSolutionValue, tmpResult);
                this.markInteger(nodeKey, tmpIntegerSolutionResult);
                if (this.isDebug()) {
                    this.debug(this.getBestResultSoFar().toString(), new Object[0]);
                }
                BasicLogger.debug();
                BasicLogger.debug(this.toString());
            } else {
                if (this.isDebug()) {
                    this.debug("Not an Integer Solution: " + tmpSolutionValue, new Object[0]);
                }
                double tmpVariableValue = tmpResult.doubleValue(this.getGlobalIndex(tmpBranchIndex));
                if (this.isGoodEnoughToContinueBranching(tmpSolutionValue)) {
                    if (this.isDebug()) {
                        this.debug("Still hope, branching on {} @ {} >>> {}", tmpBranchIndex, tmpVariableValue, tmpModel.getVariable(this.getGlobalIndex(tmpBranchIndex)));
                    }
                    tmpModel.dispose();
                    tmpModel = null;
                    NodeKey tmpLowerBranchTask = nodeKey.createLowerBranch(tmpBranchIndex, tmpVariableValue, tmpResult.getValue());
                    NodeKey tmpUpperBranchTask = nodeKey.createUpperBranch(tmpBranchIndex, tmpVariableValue, tmpResult.getValue());
                    this.add(tmpLowerBranchTask);
                    this.add(tmpUpperBranchTask);
                    if (DaemonPoolExecutor.isDaemonAvailable()) {
                        DaemonPoolExecutor.invoke(new NodeWorker());
                    }
                    this.normal &= true;
                } else if (this.isDebug()) {
                    this.debug("Can't find better integer solutions - stop this branch!", new Object[0]);
                }
            }
        } else if (this.isDebug()) {
            this.debug("Failed to solve problem - stop this branch!", new Object[0]);
        }
        this.normal &= true;
    }

    int countExploredNodes() {
        return this.countIterations();
    }

    int getGlobalIndex(int integerIndex) {
        return this.myIntegerIndeces[integerIndex];
    }

    int[] getIntegerIndeces() {
        return this.myIntegerIndeces;
    }

    double getIntegerSignificance(int index) {
        return this.myIntegerSignificances[index];
    }

    NodeKey getNextNode() {
        return this.myNodesToTry.poll();
    }

    int identifyNonIntegerVariable(Optimisation.Result nodeResult, NodeKey nodeKey) {
        int retVal = -1;
        double tmpMaxImpact = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            double tmpFraction = nodeKey.getFraction(i, nodeResult.doubleValue(this.myIntegerIndeces[i]));
            double tmpImpact = tmpFraction * this.getIntegerSignificance(i);
            if (!(tmpImpact > tmpMaxImpact) || this.options.integer.isZero(tmpFraction)) continue;
            retVal = i;
            tmpMaxImpact = tmpImpact;
        }
        return retVal;
    }

    boolean isStillNodesToTry() {
        return !this.myNodesToTry.isEmpty();
    }

    ExpressionsBasedModel makeNodeModel(NodeKey nodeKey) {
        ExpressionsBasedModel retVal = this.getModel().relax(false);
        int[] tmpIntegerIndeces = this.getIntegerIndeces();
        for (int i = 0; i < tmpIntegerIndeces.length; ++i) {
            BigDecimal tmpLowerBound = nodeKey.getLowerBound(i);
            BigDecimal tmpUpperBound = nodeKey.getUpperBound(i);
            Variable tmpVariable = retVal.getVariable(tmpIntegerIndeces[i]);
            tmpVariable.lower(tmpLowerBound);
            tmpVariable.upper(tmpUpperBound);
            BigDecimal tmpValue = tmpVariable.getValue();
            if (tmpValue == null) continue;
            if (tmpLowerBound != null) {
                tmpValue = tmpValue.max(tmpLowerBound);
            }
            if (tmpUpperBound != null) {
                tmpValue = tmpValue.min(tmpUpperBound);
            }
            tmpVariable.setValue(tmpValue);
        }
        if (this.isIntegerSolutionFound()) {
            double tmpBestValue = this.getBestResultSoFar().getValue();
            double tmpGap = PrimitiveFunction.ABS.invoke(tmpBestValue * this.options.mip_gap);
            if (retVal.isMinimisation()) {
                retVal.limitObjective(null, TypeUtils.toBigDecimal(tmpBestValue - tmpGap, this.options.problem));
            } else {
                retVal.limitObjective(TypeUtils.toBigDecimal(tmpBestValue + tmpGap, this.options.problem), null);
            }
        }
        return retVal;
    }

    void pruneNodes(NodeKey integerNode) {
    }

    void setIntegerSignificance(int index, double significance) {
        this.myIntegerSignificances[index] = significance;
    }

    void setup() {
        this.normal = true;
        NodeKey[] retVal = new NodeKey[2];
        ExpressionsBasedModel tmpIntegerModel = this.getModel();
        List<Variable> tmpIntegerVariables = tmpIntegerModel.getIntegerVariables();
        NodeKey myKey = new NodeKey(tmpIntegerModel);
        ExpressionsBasedModel tmpRootModel = this.makeNodeModel(myKey);
        Optimisation.Result tmpRootResult = tmpRootModel.solve(tmpIntegerModel.getVariableValues());
        double tmpRootValue = tmpRootResult.getValue();
        double tmpMinValue = Double.MAX_VALUE;
        double tmpMaxValue = -1.7976931348623157E308;
        double tmpBestValue = tmpRootModel.isMinimisation() ? Double.MAX_VALUE : -1.7976931348623157E308;
        double[] tmpSignificance = new double[tmpIntegerVariables.size()];
        for (int i = 0; i < tmpIntegerVariables.size(); ++i) {
            NodeKey tmpUpperNodeKey;
            ExpressionsBasedModel tmpUpperModel;
            Optimisation.Result tmpUpperResult;
            double tmpUpperValue;
            int tmpGlobalIndex = this.getGlobalIndex(i);
            double tmpVariableValue = tmpRootResult.doubleValue(tmpGlobalIndex);
            NodeKey tmpLowerNodeKey = myKey.createLowerBranch(i, tmpVariableValue, tmpRootValue);
            ExpressionsBasedModel tmpLowerModel = this.makeNodeModel(tmpLowerNodeKey);
            Optimisation.Result tmpLowerResult = tmpLowerModel.solve(tmpRootResult);
            double tmpLowerValue = tmpLowerResult.getValue();
            if (tmpLowerValue < tmpMinValue) {
                tmpMinValue = tmpLowerValue;
            }
            if (tmpLowerValue > tmpMaxValue) {
                tmpMaxValue = tmpLowerValue;
            }
            if ((tmpUpperValue = (tmpUpperResult = (tmpUpperModel = this.makeNodeModel(tmpUpperNodeKey = myKey.createUpperBranch(i, tmpVariableValue, tmpRootValue))).solve(tmpRootResult)).getValue()) < tmpMinValue) {
                tmpMinValue = tmpUpperValue;
            }
            if (tmpUpperValue > tmpMaxValue) {
                tmpMaxValue = tmpUpperValue;
            }
            if (tmpLowerResult.getState().isFeasible() && tmpUpperResult.getState().isFeasible()) {
                if (tmpRootModel.isMinimisation() && (tmpLowerValue < tmpBestValue || tmpUpperValue < tmpBestValue)) {
                    retVal[0] = tmpLowerNodeKey;
                    retVal[1] = tmpUpperNodeKey;
                } else if (tmpRootModel.isMaximisation() && (tmpLowerValue > tmpBestValue || tmpUpperValue > tmpBestValue)) {
                    retVal[0] = tmpLowerNodeKey;
                    retVal[1] = tmpUpperNodeKey;
                }
            }
            if (Double.isNaN(tmpUpperValue) || Double.isNaN(tmpLowerValue)) continue;
            tmpSignificance[i] = PrimitiveFunction.ABS.invoke(tmpUpperValue - tmpLowerValue);
        }
        double tmpScale = tmpMaxValue - tmpMinValue;
        double value = tmpScale;
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, value)) {
            tmpScale = PrimitiveMath.ONE;
        }
        for (int i = 0; i < tmpSignificance.length; ++i) {
            this.setIntegerSignificance(i, 0.5 + tmpSignificance[i] / tmpScale);
        }
        if (retVal[0] != null && retVal[1] != null) {
            this.add(retVal[0]);
            this.add(retVal[1]);
        } else {
            this.add(new NodeKey(tmpIntegerModel));
        }
        Future<Boolean> tmpFuture = DaemonPoolExecutor.invoke(new NodeWorker());
        try {
            this.normal = this.normal && tmpFuture.get() != false;
        }
        catch (InterruptedException | ExecutionException anException) {
            this.normal &= false;
        }
    }

    class NodeWorker
    implements Callable<Boolean> {
        NodeWorker() {
        }

        @Override
        public Boolean call() throws Exception {
            NodeKey tmpNodeKey = null;
            while (NewIntegerSolver.this.normal && NewIntegerSolver.this.isStillNodesToTry() && (tmpNodeKey = NewIntegerSolver.this.getNextNode()) != null) {
                NewIntegerSolver.this.compute(tmpNodeKey);
            }
            return NewIntegerSolver.this.normal;
        }
    }
}

