/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;

public class TestDFSStripedOutputStreamUpdatePipeline {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSStripedOutputStreamUpdatePipeline() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x100000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/test");
            dfs.mkdirs(dir);
            dfs.enableErasureCodingPolicy("RS-3-2-1024k");
            dfs.setErasureCodingPolicy(dir, "RS-3-2-1024k");
            Path filePath = new Path("/test/file");
            FSDataOutputStream out = dfs.create(filePath);
            try {
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    out.write(i);
                    if (i != 0x500000) continue;
                    cluster.stopDataNode(0);
                    cluster.stopDataNode(1);
                    cluster.stopDataNode(2);
                }
            }
            catch (Exception e) {
                dfs.delete(filePath, true);
            }
            finally {
                IOUtils.closeStream((Closeable)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testECWriteHangWhenAddBlockWithException() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x100000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            int i;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/test");
            dfs.mkdirs(dir);
            dfs.enableErasureCodingPolicy("XOR-2-1-1024k");
            dfs.setErasureCodingPolicy(dir, "XOR-2-1-1024k");
            Path filePath = new Path("/test/file");
            FSDataOutputStream out = dfs.create(filePath);
            for (i = 0; i < 0x200000; ++i) {
                out.write(i);
            }
            dfs.setQuota(dir, 5L, 0L);
            try {
                for (i = 0; i < 0x200000; ++i) {
                    out.write(i);
                }
            }
            catch (Exception e) {
                dfs.delete(filePath, true);
            }
            finally {
                IOUtils.closeStream((Closeable)out);
            }
        }
    }
}

