/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.applicationcleaner;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.globalpolicygenerator.applicationcleaner.ApplicationCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationCleaner
extends ApplicationCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationCleaner.class);

    @Override
    public void run() {
        Date now = new Date();
        LOG.info("Application cleaner run at time {}", (Object)now);
        FederationStateStoreFacade facade = this.getGPGContext().getStateStoreFacade();
        try {
            HashSet<ApplicationId> allStateStoreApps = new HashSet<ApplicationId>();
            List response = facade.getApplicationsHomeSubCluster();
            for (ApplicationHomeSubCluster app : response) {
                allStateStoreApps.add(app.getApplicationId());
            }
            LOG.info("{} app entries in FederationStateStore", (Object)allStateStoreApps.size());
            List allRegistryApps = this.getRegistryClient().getAllApplications();
            LOG.info("{} app entries in FederationRegistry", (Object)allStateStoreApps.size());
            Set<ApplicationId> routerApps = this.getRouterKnownApplications();
            LOG.info("{} known applications from Router", (Object)routerApps.size());
            Set toDelete = Sets.difference(allStateStoreApps, routerApps);
            LOG.info("Deleting {} applications from statestore", (Object)toDelete.size());
            LOG.debug("Apps to delete: {}.", (Object)toDelete.stream().map(Object::toString).collect(Collectors.joining(",")));
            for (ApplicationId appId : toDelete) {
                try {
                    LOG.debug("Deleting {} from statestore ", (Object)appId);
                    facade.deleteApplicationHomeSubCluster(appId);
                }
                catch (Exception e) {
                    LOG.error("deleteApplicationHomeSubCluster failed at application {}.", (Object)appId, (Object)e);
                }
            }
            for (String app : allRegistryApps) {
                ApplicationId appId = ApplicationId.fromString((String)app);
                if (routerApps.contains(appId)) continue;
                LOG.debug("removing finished application entry for {}", (Object)app);
                this.getRegistryClient().removeAppFromRegistry(appId, true);
            }
        }
        catch (Throwable e) {
            LOG.error("Application cleaner started at time {} fails. ", (Object)now, (Object)e);
        }
    }
}

