/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.sls.AMDefinition;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.TaskContainerDefinition;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class AMDefinitionSLS
extends AMDefinition {
    public AMDefinitionSLS(AMDefinition.AmDefinitionBuilder builder) {
        super(builder);
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public static List<ContainerSimulator> getTaskContainers(Map<String, ?> jsonJob, SLSRunner slsRunner) throws YarnException {
        List tasks = (List)jsonJob.get("job.tasks");
        if (tasks == null || tasks.size() == 0) {
            throw new YarnException("No task for the job!");
        }
        ArrayList<ContainerSimulator> containers = new ArrayList<ContainerSimulator>();
        for (Map jsonTask : tasks) {
            TaskContainerDefinition containerDef = TaskContainerDefinition.Builder.create().withCount(jsonTask, "count").withHostname((String)jsonTask.get("container.host")).withDuration(jsonTask, "container.duration.ms").withDurationLegacy(jsonTask, "duration.ms").withTaskStart(jsonTask, "container.start.ms").withTaskFinish(jsonTask, "container.end.ms").withResource(AMDefinitionSLS.getResourceForContainer(jsonTask, slsRunner)).withPriority(jsonTask, "container.priority").withType(jsonTask, "container.type").withExecutionType(jsonTask, "container.execution.type").withAllocationId(jsonTask, "container.allocation.id").withRequestDelay(jsonTask, "container.request.delay").build();
            for (int i = 0; i < containerDef.getCount(); ++i) {
                containers.add(ContainerSimulator.createFromTaskContainerDefinition(containerDef));
            }
        }
        return containers;
    }

    private static Resource getResourceForContainer(Map<String, String> jsonTask, SLSRunner slsRunner) {
        ResourceInformation[] infors;
        Resource res = slsRunner.getDefaultContainerResource();
        for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
            if (!jsonTask.containsKey("container." + info.getName())) continue;
            long value = Long.parseLong(jsonTask.get("container." + info.getName()));
            res.setResourceValue(info.getName(), value);
        }
        return res;
    }

    public static final class Builder
    extends AMDefinition.AmDefinitionBuilder {
        private final Map<String, String> jsonJob;

        private Builder(Map<String, String> jsonJob) {
            this.jsonJob = jsonJob;
        }

        public static Builder create(Map<String, String> jsonJob) {
            return new Builder(jsonJob);
        }

        public Builder withAmType(String key) {
            String amType;
            if (this.jsonJob.containsKey(key) && (amType = this.jsonJob.get(key)) != null) {
                this.amType = amType;
            }
            return this;
        }

        public Builder withUser(String key) {
            String user;
            if (this.jsonJob.containsKey(key) && (user = this.jsonJob.get(key)) != null) {
                this.user = user;
            }
            return this;
        }

        public Builder withQueue(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.queue = this.jsonJob.get(key);
            }
            return this;
        }

        public Builder withJobId(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.jobId = this.jsonJob.get(key);
            }
            return this;
        }

        public Builder withJobCount(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.jobCount = Integer.parseInt(this.jsonJob.get(key));
                this.jobCount = Math.max(this.jobCount, 1);
            }
            return this;
        }

        public Builder withJobStartTime(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.jobStartTime = Long.parseLong(this.jsonJob.get(key));
            }
            return this;
        }

        public Builder withJobFinishTime(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.jobFinishTime = Long.parseLong(this.jsonJob.get(key));
            }
            return this;
        }

        public Builder withLabelExpression(String key) {
            if (this.jsonJob.containsKey(key)) {
                this.labelExpression = this.jsonJob.get(key);
            }
            return this;
        }

        public Builder withTaskContainers(List<ContainerSimulator> taskContainers) {
            this.taskContainers = taskContainers;
            return this;
        }

        public Builder withAmResource(Resource amResource) {
            this.amResource = amResource;
            return this;
        }

        public AMDefinitionSLS build() {
            AMDefinitionSLS amDef = new AMDefinitionSLS(this);
            amDef.oldAppId = this.jobCount > 1 ? null : this.jobId;
            amDef.jobCount = this.jobCount;
            return amDef;
        }
    }
}

