/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverterToString;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class SubApplicationRowKey {
    private final String subAppUserId;
    private final String clusterId;
    private final String entityType;
    private final Long entityIdPrefix;
    private final String entityId;
    private final String userId;
    private final SubApplicationRowKeyConverter subAppRowKeyConverter = new SubApplicationRowKeyConverter();

    public SubApplicationRowKey(String subAppUserId, String clusterId, String entityType, Long entityIdPrefix, String entityId, String userId) {
        this.subAppUserId = subAppUserId;
        this.clusterId = clusterId;
        this.entityType = entityType;
        this.entityIdPrefix = entityIdPrefix;
        this.entityId = entityId;
        this.userId = userId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getSubAppUserId() {
        return this.subAppUserId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Long getEntityIdPrefix() {
        return this.entityIdPrefix;
    }

    public String getUserId() {
        return this.userId;
    }

    public byte[] getRowKey() {
        return this.subAppRowKeyConverter.encode(this);
    }

    public static SubApplicationRowKey parseRowKey(byte[] rowKey) {
        return new SubApplicationRowKeyConverter().decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.subAppRowKeyConverter.encodeAsString(this);
    }

    public static SubApplicationRowKey parseRowKeyFromString(String encodedRowKey) {
        return new SubApplicationRowKeyConverter().decodeFromString(encodedRowKey);
    }

    private static final class SubApplicationRowKeyConverter
    implements KeyConverter<SubApplicationRowKey>,
    KeyConverterToString<SubApplicationRowKey> {
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8, 0, 0};

        private SubApplicationRowKeyConverter() {
        }

        @Override
        public byte[] encode(SubApplicationRowKey rowKey) {
            byte[] subAppUser = Separator.encode(rowKey.getSubAppUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] first = Separator.QUALIFIERS.join(subAppUser, cluster);
            if (rowKey.getEntityType() == null) {
                return first;
            }
            byte[] entityType = Separator.encode(rowKey.getEntityType(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            if (rowKey.getEntityIdPrefix() == null) {
                return Separator.QUALIFIERS.join(first, entityType, Separator.EMPTY_BYTES);
            }
            byte[] entityIdPrefix = Bytes.toBytes((long)rowKey.getEntityIdPrefix());
            if (rowKey.getEntityId() == null) {
                return Separator.QUALIFIERS.join(first, entityType, entityIdPrefix, Separator.EMPTY_BYTES);
            }
            byte[] entityId = Separator.encode(rowKey.getEntityId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] userId = Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] second = Separator.QUALIFIERS.join(entityType, entityIdPrefix, entityId, userId);
            return Separator.QUALIFIERS.join(first, second);
        }

        @Override
        public SubApplicationRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 6) {
                throw new IllegalArgumentException("the row key is not valid for a sub app");
            }
            String subAppUserId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String entityType = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long entityPrefixId = Bytes.toLong((byte[])rowKeyComponents[3]);
            String entityId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[4]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[5]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            return new SubApplicationRowKey(subAppUserId, clusterId, entityType, entityPrefixId, entityId, userId);
        }

        @Override
        public String encodeAsString(SubApplicationRowKey key) {
            if (key.subAppUserId == null || key.clusterId == null || key.entityType == null || key.entityIdPrefix == null || key.entityId == null || key.userId == null) {
                throw new IllegalArgumentException();
            }
            return TimelineReaderUtils.joinAndEscapeStrings((String[])new String[]{key.subAppUserId, key.clusterId, key.entityType, key.entityIdPrefix.toString(), key.entityId, key.userId});
        }

        @Override
        public SubApplicationRowKey decodeFromString(String encodedRowKey) {
            List split = TimelineReaderUtils.split((String)encodedRowKey);
            if (split == null || split.size() != 6) {
                throw new IllegalArgumentException("Invalid row key for sub app table.");
            }
            Long entityIdPrefix = Long.valueOf((String)split.get(3));
            return new SubApplicationRowKey((String)split.get(0), (String)split.get(1), (String)split.get(2), entityIdPrefix, (String)split.get(4), (String)split.get(5));
        }
    }
}

