/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.ProfileServlet;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProfileServlet
extends HttpServerFunctionalTest {
    private static HttpServer2 server;
    private static URL baseUrl;
    private static final Logger LOG;

    @BeforeClass
    public static void setup() throws Exception {
        ProfileServlet.setIsTestRun((boolean)true);
        System.setProperty("async.profiler.home", UUID.randomUUID().toString());
        server = TestProfileServlet.createTestServer();
        server.start();
        baseUrl = TestProfileServlet.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        ProfileServlet.setIsTestRun((boolean)false);
        System.clearProperty("async.profiler.home");
        server.stop();
    }

    @Test
    public void testQuery() throws Exception {
        String output = TestProfileServlet.readOutput(new URL(baseUrl, "/prof"));
        LOG.info("/prof output: {}", (Object)output);
        TestProfileServlet.assertTrue((boolean)output.startsWith("Started [cpu] profiling. This page will automatically redirect to /prof-output-hadoop/"));
        TestProfileServlet.assertTrue((boolean)output.contains("If empty diagram and Linux 4.6+, see 'Basic Usage' section on the Async Profiler Home Page, https://github.com/jvm-profiling-tools/async-profiler."));
        HttpURLConnection conn = (HttpURLConnection)new URL(baseUrl, "/prof").openConnection();
        TestProfileServlet.assertEquals((Object)"GET", (Object)conn.getHeaderField("Access-Control-Allow-Methods"));
        TestProfileServlet.assertEquals((long)202L, (long)conn.getResponseCode());
        TestProfileServlet.assertNotNull((Object)conn.getHeaderField("Access-Control-Allow-Origin"));
        TestProfileServlet.assertTrue((boolean)conn.getHeaderField("Refresh").startsWith("10;/prof-output-hadoop/async-prof-pid"));
        String redirectOutput = TestProfileServlet.readOutput(new URL(baseUrl, "/prof-output-hadoop"));
        LOG.info("/prof-output-hadoop output: {}", (Object)redirectOutput);
        HttpURLConnection redirectedConn = (HttpURLConnection)new URL(baseUrl, "/prof-output-hadoop").openConnection();
        TestProfileServlet.assertEquals((long)200L, (long)redirectedConn.getResponseCode());
        redirectedConn.disconnect();
        conn.disconnect();
    }

    static {
        LOG = LoggerFactory.getLogger(TestProfileServlet.class);
    }
}

