/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDelegationTokenManager {
    private static final long DAY_IN_SECS = 86400L;
    private boolean enableZKKey;

    @Parameterized.Parameters
    public static Collection<Object[]> headers() {
        return Arrays.asList({false}, {true});
    }

    public TestDelegationTokenManager(boolean enableZKKey) {
        this.enableZKKey = enableZKKey;
    }

    @Test
    public void testDTManager() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setLong("delegation-token.update-interval.sec", 86400L);
        conf.setLong("delegation-token.max-lifetime.sec", 86400L);
        conf.setLong("delegation-token.renew-interval.sec", 86400L);
        conf.setLong("delegation-token.removal-scan-interval.sec", 86400L);
        conf.getBoolean("zk-dt-secret-manager.enable", this.enableZKKey);
        DelegationTokenManager tm = new DelegationTokenManager(conf, new Text("foo"));
        tm.init();
        Token token = tm.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        tm.verifyToken(token);
        Assert.assertTrue((tm.renewToken(token, "foo") > System.currentTimeMillis() ? 1 : 0) != 0);
        tm.cancelToken(token, "foo");
        try {
            tm.verifyToken(token);
            Assert.fail();
        }
        catch (IOException iOException) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        tm.destroy();
    }
}

