/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite.internal.distributionzones.rebalance.PartitionMover;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsChain;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.partitiondistribution.PendingAssignmentsCalculator;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftError;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.Status;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.TestOnly;

public class RebalanceRaftGroupEventsListener
implements RaftGroupEventsListener {
    private static final IgniteLogger LOG = Loggers.forClass(RebalanceRaftGroupEventsListener.class);
    private static final int REBALANCE_RETRY_THRESHOLD = 10;
    private static final int SWITCH_APPEND_SUCCESS = 1;
    private static final int SWITCH_REDUCE_SUCCESS = 2;
    private static final int SCHEDULE_PENDING_REBALANCE_SUCCESS = 3;
    private static final int FINISH_REBALANCE_SUCCESS = 4;
    private static final int SWITCH_APPEND_FAIL = -1;
    private static final int SWITCH_REDUCE_FAIL = -2;
    private static final int SCHEDULE_PENDING_REBALANCE_FAIL = -3;
    private static final int FINISH_REBALANCE_FAIL = -4;
    private final MetaStorageManager metaStorageMgr;
    private final FailureProcessor failureProcessor;
    private final TablePartitionId tablePartitionId;
    private final IgniteSpinBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;
    private final PartitionMover partitionMover;
    private final AtomicInteger rebalanceAttempts = new AtomicInteger(0);
    private final SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration;
    private final BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn;

    public RebalanceRaftGroupEventsListener(MetaStorageManager metaStorageMgr, FailureProcessor failureProcessor, TablePartitionId tablePartitionId, IgniteSpinBusyLock busyLock, PartitionMover partitionMover, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn, ScheduledExecutorService rebalanceScheduler, SystemDistributedConfigurationPropertyHolder<Integer> retryDelayConfiguration) {
        this.metaStorageMgr = metaStorageMgr;
        this.failureProcessor = failureProcessor;
        this.tablePartitionId = tablePartitionId;
        this.busyLock = busyLock;
        this.partitionMover = partitionMover;
        this.calculateAssignmentsFn = calculateAssignmentsFn;
        this.rebalanceScheduler = rebalanceScheduler;
        this.retryDelayConfiguration = retryDelayConfiguration;
    }

    public void onLeaderElected(long term, long configurationTerm, long configurationIndex, PeersAndLearners configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewPeersConfigurationApplied(PeersAndLearners configuration, long term, long index) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            Set<Assignment> stable = RebalanceRaftGroupEventsListener.createAssignments(configuration);
            this.rebalanceScheduler.execute(() -> {
                if (!this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    this.doStableKeySwitchWithExceptionHandling(stable, this.tablePartitionId, term, index, this.calculateAssignmentsFn);
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            });
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReconfigurationError(Status status, PeersAndLearners configuration, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            assert (status != null);
            if (status.equals((Object)Status.LEADER_STEPPED_DOWN)) {
                LOG.info("Leader stepped down during rebalance [partId={}]", new Object[]{this.tablePartitionId});
                return;
            }
            RaftError raftError = status.error();
            assert (raftError == RaftError.ECATCHUP) : "According to the JRaft protocol, " + String.valueOf(RaftError.ECATCHUP) + " is expected, got " + String.valueOf(raftError);
            LOG.debug("Error occurred during rebalance [partId={}]", new Object[]{this.tablePartitionId});
            if (this.rebalanceAttempts.incrementAndGet() < 10) {
                this.scheduleChangePeersAndLearners(configuration, term);
            } else {
                LOG.info("Number of retries for rebalance exceeded the threshold [partId={}, threshold={}]", new Object[]{this.tablePartitionId, 10});
                this.scheduleChangePeersAndLearners(configuration, term);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    public int currentRetryDelay() {
        return (Integer)this.retryDelayConfiguration.currentValue();
    }

    private void scheduleChangePeersAndLearners(PeersAndLearners peersAndLearners, long term) {
        this.rebalanceScheduler.schedule(() -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            LOG.info("Going to retry rebalance [attemptNo={}, partId={}]", new Object[]{this.rebalanceAttempts.get(), this.tablePartitionId});
            try {
                this.partitionMover.movePartition(peersAndLearners, term).whenComplete((unused, ex) -> {
                    if (ex != null && !ExceptionUtils.hasCause((Throwable)ex, (Class[])new Class[]{NodeStoppingException.class})) {
                        String errorMessage = String.format("Failure while moving partition [partId=%s]", this.tablePartitionId);
                        this.failureProcessor.process(new FailureContext(ex, errorMessage));
                    }
                });
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, (long)((Integer)this.retryDelayConfiguration.currentValue()).intValue(), TimeUnit.MILLISECONDS);
    }

    private void doStableKeySwitchWithExceptionHandling(Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, long configurationTerm, long configurationIndex, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn) {
        this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn).whenComplete((res, ex) -> {
            if (ex != null && !ExceptionUtils.hasCause((Throwable)ex, (Class[])new Class[]{NodeStoppingException.class})) {
                if (ExceptionUtils.hasCause((Throwable)ex, (Class[])new Class[]{TimeoutException.class})) {
                    LOG.error("Unable to commit partition configuration to metastore: {}", ex, new Object[]{tablePartitionId});
                } else {
                    String errorMessage = String.format("Unable to commit partition configuration to metastore: %s", tablePartitionId);
                    this.failureProcessor.process(new FailureContext(ex, errorMessage));
                }
            }
        });
    }

    private CompletableFuture<Void> doStableKeySwitch(Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, long configurationTerm, long configurationIndex, BiFunction<TablePartitionId, Long, CompletableFuture<Set<Assignment>>> calculateAssignmentsFn) {
        ByteArray pendingPartAssignmentsKey = RebalanceUtil.pendingPartAssignmentsQueueKey(tablePartitionId);
        ByteArray stablePartAssignmentsKey = RebalanceUtil.stablePartAssignmentsKey(tablePartitionId);
        ByteArray plannedPartAssignmentsKey = RebalanceUtil.plannedPartAssignmentsKey(tablePartitionId);
        ByteArray switchReduceKey = RebalanceUtil.switchReduceKey(tablePartitionId);
        ByteArray switchAppendKey = RebalanceUtil.switchAppendKey(tablePartitionId);
        ByteArray assignmentsChainKey = RebalanceUtil.assignmentsChainKey(tablePartitionId);
        Set<ByteArray> keysToGet = Set.of(plannedPartAssignmentsKey, pendingPartAssignmentsKey, stablePartAssignmentsKey, switchReduceKey, switchAppendKey, assignmentsChainKey);
        return this.metaStorageMgr.getAll(keysToGet).thenCompose(values -> {
            Entry stableEntry = (Entry)values.get(stablePartAssignmentsKey);
            Entry pendingEntry = (Entry)values.get(pendingPartAssignmentsKey);
            Entry plannedEntry = (Entry)values.get(plannedPartAssignmentsKey);
            Entry switchReduceEntry = (Entry)values.get(switchReduceKey);
            Entry switchAppendEntry = (Entry)values.get(switchAppendKey);
            Entry assignmentsChainEntry = (Entry)values.get(assignmentsChainKey);
            AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes((byte[])pendingEntry.value());
            if (pendingAssignmentsQueue != null && pendingAssignmentsQueue.size() > 1) {
                if (pendingAssignmentsQueue.peekFirst().nodes().equals(stableFromRaft)) {
                    pendingAssignmentsQueue.poll();
                }
                Assignments stable = Assignments.of((Set)stableFromRaft, (long)pendingAssignmentsQueue.peekFirst().timestamp());
                AssignmentsQueue pendingAssignmentsQueueFinal = pendingAssignmentsQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(stable).target(pendingAssignmentsQueue.peekLast()).toQueue();
                return this.metaStorageMgr.invoke(Statements.iif((Condition)Conditions.revision((ByteArray)pendingPartAssignmentsKey).eq(pendingEntry.revision()), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])pendingAssignmentsQueue.toBytes())}).yield(true), (Update)Operations.ops((Operation[])new Operation[0]).yield(false))).thenCompose(statementResult -> {
                    boolean updated = statementResult.getAsBoolean();
                    if (updated) {
                        LOG.info("Pending assignments queue polled and updated [tablePartitionId={}, pendingQueue={}]", new Object[]{tablePartitionId, pendingAssignmentsQueueFinal});
                        return CompletableFutures.nullCompletedFuture();
                    }
                    LOG.info("Pending assignments queue update retry [tablePartitionId={}, pendingQueue={}]", new Object[]{tablePartitionId, pendingAssignmentsQueueFinal});
                    return this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn);
                });
            }
            Set retrievedStable = RebalanceRaftGroupEventsListener.readAssignments(stableEntry).nodes();
            Set retrievedSwitchReduce = RebalanceRaftGroupEventsListener.readAssignments(switchReduceEntry).nodes();
            Set retrievedSwitchAppend = RebalanceRaftGroupEventsListener.readAssignments(switchAppendEntry).nodes();
            Assignments pendingAssignments = pendingAssignmentsQueue == null ? Assignments.EMPTY : pendingAssignmentsQueue.poll();
            Set retrievedPending = pendingAssignments.nodes();
            if (!retrievedPending.equals(stableFromRaft)) {
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)calculateAssignmentsFn.apply(tablePartitionId, pendingAssignments.timestamp())).thenCompose(calculatedAssignments -> {
                Update failCase;
                Update successCase;
                Set reducedNodes = CollectionUtils.difference((Set)retrievedSwitchReduce, (Set)stableFromRaft);
                Set addedNodes = CollectionUtils.difference((Set)stableFromRaft, (Set)retrievedStable);
                Set calculatedSwitchReduce = CollectionUtils.difference((Set)retrievedSwitchReduce, (Set)reducedNodes);
                Set calculatedSwitchAppend = RebalanceUtil.union(retrievedSwitchAppend, reducedNodes);
                calculatedSwitchAppend = CollectionUtils.difference(calculatedSwitchAppend, (Set)addedNodes);
                calculatedSwitchAppend = CollectionUtils.intersect((Set)calculatedAssignments, (Set)calculatedSwitchAppend);
                Set calculatedPendingReduction = CollectionUtils.difference((Set)stableFromRaft, (Set)retrievedSwitchReduce);
                Set calculatedPendingAddition = RebalanceUtil.union(stableFromRaft, reducedNodes);
                calculatedPendingAddition = CollectionUtils.intersect((Set)calculatedAssignments, calculatedPendingAddition);
                SimpleCondition con1 = stableEntry.empty() ? Conditions.notExists((ByteArray)stablePartAssignmentsKey) : Conditions.revision((ByteArray)stablePartAssignmentsKey).eq(stableEntry.revision());
                SimpleCondition con2 = Conditions.revision((ByteArray)pendingPartAssignmentsKey).eq(pendingEntry.revision());
                SimpleCondition con3 = switchReduceEntry.empty() ? Conditions.notExists((ByteArray)switchReduceKey) : Conditions.revision((ByteArray)switchReduceKey).eq(switchReduceEntry.revision());
                SimpleCondition con4 = switchAppendEntry.empty() ? Conditions.notExists((ByteArray)switchAppendKey) : Conditions.revision((ByteArray)switchAppendKey).eq(switchAppendEntry.revision());
                CompoundCondition retryPreconditions = Conditions.and((Condition)con1, (Condition)Conditions.and((Condition)con2, (Condition)Conditions.and((Condition)con3, (Condition)con4)));
                long catalogTimestamp = pendingAssignments.timestamp();
                Assignments newStableAssignments = Assignments.of((Set)stableFromRaft, (long)catalogTimestamp);
                Operation assignmentChainChangeOp = RebalanceRaftGroupEventsListener.handleAssignmentsChainChange(assignmentsChainKey, assignmentsChainEntry, pendingAssignments, newStableAssignments, configurationTerm, configurationIndex);
                byte[] stableFromRaftByteArray = newStableAssignments.toBytes();
                byte[] additionByteArray = AssignmentsQueue.toBytes((Assignments[])new Assignments[]{Assignments.of((Set)calculatedPendingAddition, (long)catalogTimestamp)});
                byte[] reductionByteArray = AssignmentsQueue.toBytes((Assignments[])new Assignments[]{Assignments.of((Set)calculatedPendingReduction, (long)catalogTimestamp)});
                byte[] switchReduceByteArray = Assignments.toBytes((Set)calculatedSwitchReduce, (long)catalogTimestamp);
                byte[] switchAppendByteArray = Assignments.toBytes((Set)calculatedSwitchAppend, (long)catalogTimestamp);
                if (!calculatedSwitchAppend.isEmpty()) {
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])additionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray), assignmentChainChangeOp}).yield(1);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-1);
                } else if (!calculatedSwitchReduce.isEmpty()) {
                    successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])reductionByteArray), Operations.put((ByteArray)switchReduceKey, (byte[])switchReduceByteArray), Operations.put((ByteArray)switchAppendKey, (byte[])switchAppendByteArray), assignmentChainChangeOp}).yield(2);
                    failCase = Operations.ops((Operation[])new Operation[0]).yield(-2);
                } else {
                    SimpleCondition con5;
                    if (plannedEntry.value() != null) {
                        con5 = Conditions.revision((ByteArray)plannedPartAssignmentsKey).eq(plannedEntry.revision());
                        AssignmentsQueue partAssignmentsPendingQueue = PendingAssignmentsCalculator.pendingAssignmentsCalculator().stable(newStableAssignments).target(Assignments.fromBytes((byte[])plannedEntry.value())).toQueue();
                        successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.put((ByteArray)pendingPartAssignmentsKey, (byte[])partAssignmentsPendingQueue.toBytes()), Operations.remove((ByteArray)plannedPartAssignmentsKey), assignmentChainChangeOp}).yield(3);
                        failCase = Operations.ops((Operation[])new Operation[0]).yield(-3);
                    } else {
                        con5 = Conditions.notExists((ByteArray)plannedPartAssignmentsKey);
                        successCase = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)stablePartAssignmentsKey, (byte[])stableFromRaftByteArray), Operations.remove((ByteArray)pendingPartAssignmentsKey), assignmentChainChangeOp}).yield(4);
                        failCase = Operations.ops((Operation[])new Operation[0]).yield(-4);
                    }
                    retryPreconditions = Conditions.and((Condition)retryPreconditions, (Condition)con5);
                }
                Set finalCalculatedPendingAddition = calculatedPendingAddition;
                return this.metaStorageMgr.invoke(Statements.iif((Condition)retryPreconditions, (Update)successCase, (Update)failCase)).thenCompose(statementResult -> {
                    int res = statementResult.getAsInt();
                    if (res < 0) {
                        RebalanceRaftGroupEventsListener.logSwitchFailure(res, stableFromRaft, tablePartitionId);
                        return this.doStableKeySwitch(stableFromRaft, tablePartitionId, configurationTerm, configurationIndex, calculateAssignmentsFn);
                    }
                    RebalanceRaftGroupEventsListener.logSwitchSuccess(res, stableFromRaft, tablePartitionId, finalCalculatedPendingAddition, calculatedPendingReduction, plannedEntry);
                    return CompletableFutures.nullCompletedFuture();
                });
            });
        });
    }

    private static void logSwitchFailure(int res, Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId) {
        switch (res) {
            case -1: {
                LOG.info("Rebalance keys changed while trying to update rebalance pending addition information. Going to retry [tablePartitionID={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                break;
            }
            case -2: {
                LOG.info("Rebalance keys changed while trying to update rebalance pending reduce information. Going to retry [tablePartitionID={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                break;
            }
            case -4: 
            case -3: {
                LOG.info("Rebalance keys changed while trying to update rebalance information. Going to retry [tablePartitionId={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                break;
            }
            default: {
                assert (false) : res;
                break;
            }
        }
    }

    private static void logSwitchSuccess(int res, Set<Assignment> stableFromRaft, TablePartitionId tablePartitionId, Set<Assignment> calculatedPendingAddition, Set<Assignment> calculatedPendingReduction, Entry plannedEntry) {
        switch (res) {
            case 1: {
                LOG.info("Rebalance finished. Going to schedule next rebalance with addition [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, calculatedPendingAddition});
                break;
            }
            case 2: {
                LOG.info("Rebalance finished. Going to schedule next rebalance with reduction [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, calculatedPendingReduction});
                break;
            }
            case 3: {
                LOG.info("Rebalance finished. Going to schedule next rebalance [tablePartitionId={}, appliedPeers={}, plannedPeers={}]", new Object[]{tablePartitionId, stableFromRaft, Assignments.fromBytes((byte[])plannedEntry.value()).nodes()});
                break;
            }
            case 4: {
                LOG.info("Rebalance finished [tablePartitionId={}, appliedPeers={}]", new Object[]{tablePartitionId, stableFromRaft});
                break;
            }
            default: {
                assert (false) : res;
                break;
            }
        }
    }

    private static Operation handleAssignmentsChainChange(ByteArray assignmentsChainKey, Entry assignmentsChainEntry, Assignments pendingAssignments, Assignments stableAssignments, long configurationTerm, long configurationIndex) {
        if (assignmentsChainEntry.value() != null) {
            AssignmentsChain updatedAssignmentsChain = RebalanceRaftGroupEventsListener.updateAssignmentsChain(AssignmentsChain.fromBytes((byte[])assignmentsChainEntry.value()), stableAssignments, pendingAssignments, configurationTerm, configurationIndex);
            return Operations.put((ByteArray)assignmentsChainKey, (byte[])updatedAssignmentsChain.toBytes());
        }
        return Operations.noop();
    }

    private static AssignmentsChain updateAssignmentsChain(AssignmentsChain assignmentsChain, Assignments newStable, Assignments pendingAssignments, long configurationTerm, long configurationIndex) {
        assert (assignmentsChain != null) : "Assignments chain cannot be null in HA mode.";
        assert (assignmentsChain.size() > 0) : "Assignments chain cannot be empty on stable switch.";
        if (!pendingAssignments.force() && !pendingAssignments.fromReset()) {
            return AssignmentsChain.of((long)configurationTerm, (long)configurationIndex, (Assignments[])new Assignments[]{newStable});
        }
        if (!pendingAssignments.force() && pendingAssignments.fromReset()) {
            assignmentsChain.replaceLast(newStable, configurationTerm, configurationIndex);
        } else {
            assignmentsChain.addLast(newStable, configurationTerm, configurationIndex);
        }
        return assignmentsChain;
    }

    private static Set<Assignment> createAssignments(PeersAndLearners configuration) {
        Stream<Assignment> newAssignments = Stream.concat(configuration.peers().stream().map(peer -> Assignment.forPeer((String)peer.consistentId())), configuration.learners().stream().map(peer -> Assignment.forLearner((String)peer.consistentId())));
        return newAssignments.collect(Collectors.toSet());
    }

    private static Assignments readAssignments(Entry entry) {
        byte[] value = entry.value();
        return value == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])value);
    }
}

