/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpRequestWrapper;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;
import java.util.Objects;

public interface NettyHttpRequestBuilder {
    @NonNull
    public FullHttpRequest toFullHttpRequest();

    @NonNull
    public StreamedHttpRequest toStreamHttpRequest();

    @NonNull
    public io.netty.handler.codec.http.HttpRequest toHttpRequest();

    public boolean isStream();

    @NonNull
    public static io.netty.handler.codec.http.HttpRequest toHttpRequest(@NonNull HttpRequest<?> request) {
        Objects.requireNonNull(request, "The request cannot be null");
        while (request instanceof HttpRequestWrapper) {
            request = ((HttpRequestWrapper)request).getDelegate();
        }
        if (request instanceof NettyHttpRequestBuilder) {
            return ((NettyHttpRequestBuilder)request).toHttpRequest();
        }
        ByteBuf byteBuf = request.getBody(ByteBuf.class).orElse(null);
        DefaultFullHttpRequest nettyRequest = byteBuf != null ? new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getMethodName()), request.getUri().toString(), byteBuf) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getMethodName()), request.getUri().toString());
        request.getHeaders().forEach((arg_0, arg_1) -> NettyHttpRequestBuilder.lambda$toHttpRequest$0((io.netty.handler.codec.http.HttpRequest)nettyRequest, arg_0, arg_1));
        return nettyRequest;
    }

    private static /* synthetic */ void lambda$toHttpRequest$0(io.netty.handler.codec.http.HttpRequest nettyRequest, String s, List strings) {
        nettyRequest.headers().add(s, (Iterable)strings);
    }
}

