/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.PropertiesHelper;

public final class ReaderWriter {
    private static final Logger LOGGER = Logger.getLogger(ReaderWriter.class.getName());
    @Deprecated(forRemoval=true)
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    public static final int BUFFER_SIZE = ReaderWriter.getBufferSize();
    public static final boolean AUTOSIZE_BUFFER = ReaderWriter.getAutosizeBuffer();
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    private static int getIOBufferSize() {
        String value = AccessController.doPrivileged(PropertiesHelper.getSystemProperty("jersey.config.io.bufferSize"));
        if (value != null) {
            try {
                int i = Integer.parseInt(value);
                if (i <= 0) {
                    throw new NumberFormatException("Value not positive.");
                }
                return i;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.CONFIG, "Value of jersey.config.io.bufferSize property is not a valid positive integer [" + value + "]. Reverting to default [at JRE's discretion].", e);
            }
        }
        return -1;
    }

    private static int getBufferSize() {
        int ioBufferSize = ReaderWriter.getIOBufferSize();
        return ioBufferSize == -1 ? 8192 : ioBufferSize;
    }

    private static boolean getAutosizeBuffer() {
        return ReaderWriter.getIOBufferSize() == -1;
    }

    public static void writeTo(InputStream in, OutputStream out) throws IOException {
        int read;
        if (AUTOSIZE_BUFFER) {
            in.transferTo(out);
            return;
        }
        byte[] data = new byte[BUFFER_SIZE];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
    }

    public static void writeTo(Reader in, Writer out) throws IOException {
        int read;
        if (AUTOSIZE_BUFFER) {
            in.transferTo(out);
            return;
        }
        char[] data = new char[BUFFER_SIZE];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
    }

    public static Charset getCharset(MediaType m) {
        String name = m == null ? null : (String)m.getParameters().get("charset");
        return name == null ? StandardCharsets.UTF_8 : Charset.forName(name);
    }

    public static String readFromAsString(InputStream in, MediaType type) throws IOException {
        return new String(ReaderWriter.readAllBytes(in), ReaderWriter.getCharset(type));
    }

    public static String readFromAsString(Reader reader) throws IOException {
        int l;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[BUFFER_SIZE];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = Integer.MAX_VALUE;
        do {
            byte[] buf = new byte[Math.min(remaining, BUFFER_SIZE)];
            int nread = 0;
            while ((n = inputStream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                remaining -= n;
                if ((nread += n) != BUFFER_SIZE) continue;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public static void writeToAsString(String s, OutputStream out, MediaType type) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, ReaderWriter.getCharset(type));
        osw.write(s);
        ((Writer)osw).flush();
    }

    public static void safelyClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), ioe);
        }
        catch (ProcessingException pe) {
            LOGGER.log(Level.FINE, LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), pe);
        }
    }

    private ReaderWriter() {
    }
}

