/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;

public class NotNullConstraint
implements Serializable {
    Map<String, String> notNullConstraints;
    String databaseName;
    String tableName;

    public NotNullConstraint() {
    }

    public NotNullConstraint(List<SQLNotNullConstraint> nns, String tableName, String databaseName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.notNullConstraints = new TreeMap<String, String>();
        if (nns == null) {
            return;
        }
        for (SQLNotNullConstraint pk : nns) {
            if (!pk.getTable_db().equalsIgnoreCase(databaseName) || !pk.getTable_name().equalsIgnoreCase(tableName)) continue;
            this.notNullConstraints.put(pk.getNn_name(), pk.getColumn_name());
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getNotNullConstraints() {
        return this.notNullConstraints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Not Null Constraints for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.notNullConstraints != null && this.notNullConstraints.size() > 0) {
            for (Map.Entry<String, String> me : this.notNullConstraints.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey());
                sb.append(", Column Name: " + me.getValue());
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }
}

