/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ExprNodeConstantDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final transient char[] hexArray = "0123456789ABCDEF".toCharArray();
    private Object value;
    private transient String foldedFromCol;
    private transient String foldedFromVal;

    public ExprNodeConstantDesc setFoldedFromVal(String foldedFromVal) {
        this.foldedFromVal = foldedFromVal;
        return this;
    }

    public String getFoldedFromVal() {
        return this.foldedFromVal;
    }

    public String getFoldedFromCol() {
        return this.foldedFromCol;
    }

    public void setFoldedFromCol(String foldedFromCol) {
        this.foldedFromCol = foldedFromCol;
    }

    public ExprNodeConstantDesc() {
    }

    public ExprNodeConstantDesc(TypeInfo typeInfo, Object value) {
        super(typeInfo);
        this.setValue(value);
    }

    public ExprNodeConstantDesc(Object value) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(value.getClass()), value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            value = StringInternUtils.internIfNotNull((String)value);
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public ConstantObjectInspector getWritableObjectInspector() {
        return ObjectInspectorUtils.getConstantObjectInspector(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(this.typeInfo), this.value);
    }

    public String toString() {
        return "Const " + this.typeInfo.toString() + " " + this.value;
    }

    private static String getFormatted(TypeInfo typeInfo, Object value) {
        if (value == null) {
            return "null";
        }
        if (typeInfo.getTypeName().equals("string") || typeInfo instanceof BaseCharTypeInfo) {
            return "'" + value.toString() + "'";
        }
        if (typeInfo.getTypeName().equals("binary")) {
            byte[] bytes = (byte[])value;
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
        if (typeInfo.getTypeName().equals("date")) {
            return "DATE'" + value.toString() + "'";
        }
        if (typeInfo.getTypeName().equals("timestamp")) {
            return "TIMESTAMP'" + value.toString() + "'";
        }
        if (typeInfo.getTypeName().equals("timestamp with local time zone")) {
            return "TIMESTAMPLOCALTZ'" + value.toString() + "'";
        }
        if (typeInfo.getTypeName().equals("tinyint")) {
            return value.toString() + "Y";
        }
        if (typeInfo.getTypeName().equals("smallint")) {
            return value.toString() + "S";
        }
        if (typeInfo.getTypeName().equals("bigint")) {
            return value.toString() + "L";
        }
        if (typeInfo.getTypeName().equals("double")) {
            return value.toString() + "D";
        }
        if (typeInfo.getTypeName().equals("decimal")) {
            return value.toString() + "BD";
        }
        if (typeInfo.getTypeName().equals("interval_day_time") || typeInfo.getTypeName().equals("interval_year_month")) {
            return "INTERVAL'" + value.toString() + "'";
        }
        return value.toString();
    }

    @Override
    public String getExprString() {
        if (this.typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return ExprNodeConstantDesc.getFormatted(this.typeInfo, this.value);
        }
        if (this.typeInfo.getCategory() == ObjectInspector.Category.STRUCT) {
            StringBuilder sb = new StringBuilder();
            sb.append("const struct(");
            List items = (List)this.getWritableObjectInspector().getWritableConstantValue();
            ArrayList<TypeInfo> structTypes = ((StructTypeInfo)this.typeInfo).getAllStructFieldTypeInfos();
            for (int i = 0; i < structTypes.size(); ++i) {
                Object o = i < items.size() ? items.get(i) : null;
                sb.append(ExprNodeConstantDesc.getFormatted((TypeInfo)structTypes.get(i), o)).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
            return sb.toString();
        }
        return this.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeConstantDesc(this.typeInfo, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeConstantDesc)) {
            return false;
        }
        ExprNodeConstantDesc dest = (ExprNodeConstantDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return !(this.value == null ? dest.getValue() != null : !this.value.equals(dest.getValue()));
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.value);
        return builder.toHashCode();
    }
}

