/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.service;

import java.text.MessageFormat;
import org.apache.linkis.datasource.client.impl.LinkisDataSourceRemoteClient;
import org.apache.linkis.datasource.client.request.GetInfoPublishedByDataSourceNameAction;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.engineplugin.spark.datacalc.exception.DataSourceNotConfigException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataSource;
import org.apache.linkis.engineplugin.spark.datacalc.service.LinkisDataSourceContext;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisDataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(LinkisDataSourceService.class);

    public static DataCalcDataSource getDatasource(String datasourceName) {
        LinkisDataSourceRemoteClient dataSourceClient = new LinkisDataSourceRemoteClient();
        GetInfoPublishedByDataSourceNameAction action = GetInfoPublishedByDataSourceNameAction.builder().setDataSourceName(datasourceName).setUser(StorageUtils.getJvmUser()).build();
        DataSource datasource = dataSourceClient.getInfoPublishedByDataSourceName(action).getDataSource();
        if (datasource == null) {
            int code = SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorCode();
            String errDesc = SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorDesc();
            String msg = MessageFormat.format(errDesc, datasourceName);
            logger.error(msg);
            throw new DataSourceNotConfigException(code, msg);
        }
        LinkisDataSourceContext dataSourceContext = new LinkisDataSourceContext(datasource);
        return dataSourceContext.getDataCalcDataSource();
    }
}

