/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import ch.cern.sparkmeasure.StageMetrics;
import ch.cern.sparkmeasure.TaskMetrics;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.SparkSQL;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.executor.SQLSession$;
import org.apache.linkis.engineplugin.spark.executor.SparkEngineConnExecutor;
import org.apache.linkis.engineplugin.spark.extension.SparkSqlExtension;
import org.apache.linkis.engineplugin.spark.extension.SparkSqlExtension$;
import org.apache.linkis.engineplugin.spark.sparkmeasure.SparkSqlMeasure;
import org.apache.linkis.engineplugin.spark.utils.DirectPushCache$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.constant.job.JobRequestConstants$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0006\r\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!AA\u0006\u0001B\u0001B\u0003%Q\u0006C\u0003A\u0001\u0011\u0005\u0011\tC\u0003G\u0001\u0011\u0005s\tC\u0003L\u0001\u0011EC\nC\u0003T\u0001\u0011%A\u000bC\u0003l\u0001\u0011EC\u000eC\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005-\u0002\u0001\"\u0015\u0002.\t\u00012\u000b]1sWN\u000bH.\u0012=fGV$xN\u001d\u0006\u0003\u001b9\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005M!\u0012A\u00027j].L7O\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u00031I!!\b\u0007\u0003/M\u0003\u0018M]6F]\u001eLg.Z\"p]:,\u00050Z2vi>\u0014\u0018AE:qCJ\\WI\\4j]\u0016\u001cVm]:j_:\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\b\u0002\r\u0015tG/\u001b;z\u0013\t!\u0013E\u0001\nTa\u0006\u00148.\u00128hS:,7+Z:tS>t\u0017AA5e!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0011auN\\4\u0002\u000f=\u0004H/[8ogB!afM\u001b6\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001c>\u001d\t94\b\u0005\u00029Q5\t\u0011H\u0003\u0002;1\u00051AH]8pizJ!\u0001\u0010\u0015\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y!\na\u0001P5oSRtD\u0003\u0002\"D\t\u0016\u0003\"a\u0007\u0001\t\u000by!\u0001\u0019A\u0010\t\u000b\u0015\"\u0001\u0019\u0001\u0014\t\u000b1\"\u0001\u0019A\u0017\u0002\t%t\u0017\u000e\u001e\u000b\u0002\u0011B\u0011q%S\u0005\u0003\u0015\"\u0012A!\u00168ji\u00069q-\u001a;LS:$W#A'\u0011\u00059\u000bV\"A(\u000b\u0005As\u0011AB2p[6|g.\u0003\u0002S\u001f\n!1*\u001b8e\u0003]\u0019XOY7jiJ+7/\u001e7u'\u0016$\u0018\n^3sCR|'\u000fF\u0002I+^CQAV\u0004A\u0002U\na\u0001^1tW&#\u0007\"\u0002-\b\u0001\u0004I\u0016A\u00013g!\tQ\u0006N\u0004\u0002\\K:\u0011AL\u0019\b\u0003;\u0006t!A\u00181\u000f\u0005az\u0016\"A\f\n\u0005U1\u0012BA\b\u0015\u0013\t\u0019G-A\u0002tc2T!a\u0004\u000b\n\u0005\u0019<\u0017a\u00029bG.\fw-\u001a\u0006\u0003G\u0012L!!\u001b6\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00014h\u0003\u001d\u0011XO\\\"pI\u0016$b!\\;wq\u0006-\u0001C\u00018t\u001b\u0005y'B\u00019r\u0003!)\u00070Z2vi\u0016\u0014(B\u0001:\u0013\u0003%\u00198\r[3ek2,'/\u0003\u0002u_\nyQ\t_3dkR,'+Z:q_:\u001cX\rC\u0003\u000e\u0011\u0001\u0007!\u0004C\u0003x\u0011\u0001\u0007Q'\u0001\u0003d_\u0012,\u0007\"B=\t\u0001\u0004Q\u0018AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0007m\f9!D\u0001}\u0015\tih0A\u0004fq\u0016\u001cW\u000f^3\u000b\u00055y(\u0002BA\u0001\u0003\u0007\t1bY8naV$\u0018\r^5p]*\u0019\u0011Q\u0001\n\u0002\u0015\u0015tw-\u001b8fG>tg.C\u0002\u0002\nq\u0014a#\u00128hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u001bA\u0001\u0019A\u001b\u0002\u0011)|'m\u0012:pkB\f!c\u0019:fCR,7\u000b]1sW6+\u0017m];sKRA\u00111CA\u0013\u0003O\tI\u0003E\u0003(\u0003+\tI\"C\u0002\u0002\u0018!\u0012aa\u00149uS>t\u0007\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a\"\u0001\u0007ta\u0006\u00148.\\3bgV\u0014X-\u0003\u0003\u0002$\u0005u!aD*qCJ\\7+\u001d7NK\u0006\u001cXO]3\t\u000beL\u0001\u0019\u0001>\t\u000byI\u0001\u0019A\u0010\t\u000b]L\u0001\u0019A\u001b\u0002'\u001d,G/\u0012=fGV$xN]%e!J,g)\u001b=\u0016\u0003U\u0002")
public class SparkSqlExecutor
extends SparkEngineConnExecutor {
    private final SparkEngineSession sparkEngineSession;
    private final Map<String, String> options;

    @Override
    public void init() {
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
        this.logger().info("spark sql executor start");
    }

    @Override
    public Kind getKind() {
        return new SparkSQL();
    }

    private void submitResultSetIterator(String taskId, Dataset<Row> df) {
        if (!DirectPushCache$.MODULE$.isTaskCached(taskId)) {
            DirectPushCache$.MODULE$.submitExecuteResult(taskId, df);
            return;
        }
        this.logger().error(new StringBuilder(40).append("Task ").append(taskId).append(" already exists in resultSet cache.").toString());
    }

    @Override
    public ExecuteResponse runCode(SparkEngineConnExecutor executor, String code, EngineExecutionContext engineExecutionContext, String jobGroup) {
        ErrorExecuteResponse errorExecuteResponse;
        BoxedUnit boxedUnit;
        if (engineExecutionContext.getCurrentParagraph() == 1 && engineExecutionContext.getProperties().containsKey(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB())) {
            String defaultDB = (String)engineExecutionContext.getProperties().get(JobRequestConstants$.MODULE$.LINKIS_JDBC_DEFAULT_DB());
            this.logger().info(new StringBuilder(18).append("set default DB to ").append(defaultDB).toString());
            boxedUnit = this.sparkEngineSession.sqlContext().sql(new StringBuilder(4).append("use ").append(defaultDB).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logger().info(new StringBuilder(23).append("SQLExecutor run query: ").append(code).toString());
        engineExecutionContext.appendStdout(new StringBuilder(4).append(EngineUtils$.MODULE$.getName()).append(" >> ").append(code).toString());
        ClassLoader standInClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                long sqlStartTime = System.currentTimeMillis();
                Thread.currentThread().setContextClassLoader((ClassLoader)this.sparkEngineSession.sparkSession().sharedState().jarClassLoader());
                SparkSqlExtension[] extensions = SparkSqlExtension$.MODULE$.getSparkSqlExtensions();
                Option<SparkSqlMeasure> sparkMeasure = this.createSparkMeasure(engineExecutionContext, this.sparkEngineSession, code);
                Option sparkMetrics = sparkMeasure.flatMap((Function1 & Serializable & scala.Serializable)measure -> {
                    Option<Either<StageMetrics, TaskMetrics>> metrics2 = measure.getSparkMetrics();
                    metrics2.foreach((Function1 & Serializable & scala.Serializable)metrics -> {
                        measure.begin((Either<StageMetrics, TaskMetrics>)metrics);
                        return BoxedUnit.UNIT;
                    });
                    return metrics2;
                });
                Dataset df = this.sparkEngineSession.sqlContext().sql(code);
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extensions)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.afterExecutingSQL(this.sparkEngineSession.sqlContext(), code, (Dataset<Row>)df, BoxesRunTime.unboxToLong((Object)SparkConfiguration$.MODULE$.SQL_EXTENSION_TIMEOUT().getValue()), sqlStartTime);
                    return BoxedUnit.UNIT;
                }));
                if (engineExecutionContext.isEnableDirectPush()) {
                    this.submitResultSetIterator(this.lastTask().getTaskId(), (Dataset<Row>)df);
                } else {
                    SQLSession$.MODULE$.showDF(this.sparkEngineSession.sparkContext(), jobGroup, (Dataset<Row>)df, null, BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SHOW_DF_MAX_RES().getValue()), engineExecutionContext);
                }
                sparkMeasure.foreach((Function1 & Serializable & scala.Serializable)measure -> {
                    SparkSqlExecutor.$anonfun$runCode$5(sparkMetrics, measure);
                    return BoxedUnit.UNIT;
                });
                errorExecuteResponse = new SuccessExecuteResponse();
            }
            catch (InvocationTargetException e) {
                Throwable cause = ExceptionUtils.getCause((Throwable)e);
                if (cause == null) {
                    cause = e;
                }
                errorExecuteResponse = new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)e), cause);
            }
            catch (Exception ite) {
                errorExecuteResponse = new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)ite), (Throwable)ite);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(standInClassLoader);
        }
        return errorExecuteResponse;
    }

    private Option<SparkSqlMeasure> createSparkMeasure(EngineExecutionContext engineExecutionContext, SparkEngineSession sparkEngineSession, String code) {
        String sparkMeasureType = engineExecutionContext.getProperties().getOrDefault(SparkConfiguration$.MODULE$.SPARKMEASURE_AGGREGATE_TYPE(), "").toString();
        if (new StringOps(Predef$.MODULE$.augmentString(sparkMeasureType)).nonEmpty()) {
            String outputPrefix = (String)SparkConfiguration$.MODULE$.SPARKMEASURE_OUTPUT_PREFIX().getValue(this.options);
            FsPath outputPath = FsPath.getFsPath((String)outputPrefix, (String[])new String[]{(String)LabelUtil$.MODULE$.getUserCreator((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])engineExecutionContext.getLabels())).toList()).asJava())._1(), sparkMeasureType, JobUtils$.MODULE$.getJobIdFromMap(engineExecutionContext.getProperties()), Long.toString(new Date().getTime())});
            return new Some((Object)new SparkSqlMeasure(sparkEngineSession.sparkSession(), code, sparkMeasureType, outputPath));
        }
        return None$.MODULE$;
    }

    @Override
    public String getExecutorIdPreFix() {
        return "SparkSqlExecutor_";
    }

    public static final /* synthetic */ void $anonfun$runCode$5(Option sparkMetrics$1, SparkSqlMeasure measure) {
        sparkMetrics$1.foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            measure.end((Either<StageMetrics, TaskMetrics>)metrics);
            return BoxedUnit.UNIT;
        });
        sparkMetrics$1.foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            measure.outputMetrics((Either<StageMetrics, TaskMetrics>)metrics);
            return BoxedUnit.UNIT;
        });
    }

    public SparkSqlExecutor(SparkEngineSession sparkEngineSession, long id, Map<String, String> options) {
        this.sparkEngineSession = sparkEngineSession;
        this.options = options;
        super(sparkEngineSession.sparkContext(), id);
    }
}

