/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class YarnResource
extends Resource {
    private final long queueMemory;
    private final int queueCores;
    private final int queueInstances;
    private final String queueName;
    private final String applicationId;

    public YarnResource(long queueMemory, int queueCores, int queueInstances, String queueName, String applicationId) {
        this.queueMemory = queueMemory;
        this.queueCores = queueCores;
        this.queueInstances = queueInstances;
        this.queueName = queueName;
        this.applicationId = applicationId;
    }

    public YarnResource() {
        this(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "default", "");
    }

    public YarnResource(long queueMemory, int queueCores, int queueInstances, String queueName) {
        this(queueMemory, queueCores, queueInstances, queueName, "");
    }

    YarnResource toYarnResource(Resource r) {
        if (r instanceof YarnResource) {
            return (YarnResource)r;
        }
        return new YarnResource(Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "default");
    }

    public long getQueueMemory() {
        return this.queueMemory;
    }

    public int getQueueCores() {
        return this.queueCores;
    }

    public int getQueueInstances() {
        return this.queueInstances;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public YarnResource add(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return new YarnResource(this.queueMemory + r.getQueueMemory(), this.queueCores + r.getQueueCores(), this.queueInstances + r.getQueueInstances(), r.getQueueName());
    }

    @Override
    public YarnResource minus(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return new YarnResource(this.queueMemory - r.getQueueMemory(), this.queueCores - r.getQueueCores(), this.queueInstances - r.getQueueInstances(), r.getQueueName());
    }

    @Override
    public YarnResource multiplied(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return new YarnResource(this.queueMemory * r.getQueueMemory(), this.queueCores * r.getQueueCores(), this.queueInstances * r.getQueueInstances(), r.getQueueName());
    }

    @Override
    public YarnResource multiplied(float rate) {
        return new YarnResource((long)((float)this.queueMemory * rate), (int)((float)this.queueCores * rate), (int)((float)this.queueInstances * rate), this.queueName);
    }

    @Override
    public YarnResource divide(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return new YarnResource(this.queueMemory / r.getQueueMemory(), this.queueCores / r.getQueueCores(), this.queueInstances / r.getQueueInstances(), r.getQueueName());
    }

    @Override
    public YarnResource divide(int rate) {
        return new YarnResource(this.queueMemory / (long)rate, this.queueCores / rate, this.queueInstances / rate, this.queueName);
    }

    @Override
    public boolean moreThan(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return this.queueMemory > r.getQueueMemory() && this.queueCores > r.getQueueCores();
    }

    @Override
    public boolean caseMore(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return this.queueMemory > r.getQueueMemory() || this.queueCores > r.getQueueCores();
    }

    @Override
    public boolean equalsTo(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return this.queueName.equals(r.getQueueName()) && this.queueMemory == r.getQueueMemory() && this.queueCores == r.getQueueCores() && this.queueInstances == r.getQueueInstances();
    }

    @Override
    public boolean notLess(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        return this.queueMemory >= r.getQueueMemory() && this.queueCores >= r.getQueueCores();
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource resource) {
        YarnResource r = this.toYarnResource(resource);
        if (this.getQueueMemory() > r.getQueueMemory()) {
            return 1;
        }
        if (this.getQueueMemory() < r.getQueueMemory()) {
            return -1;
        }
        return Integer.compare(this.getQueueCores(), r.getQueueCores());
    }

    @Override
    public String toJson() {
        return String.format("{\"queueName\":\"%s\",\"queueMemory\":\"%s\",\"queueCpu\":%d, \"instance\":%d}", this.queueName, ByteTimeUtils.bytesToString((long)this.queueMemory), this.queueCores, this.queueInstances);
    }

    public String toString() {
        return String.format("Queue name(\u961f\u5217\u540d)\uff1a%s\uff0cQueue memory(\u961f\u5217\u5185\u5b58)\uff1a%s\uff0cQueue core number(\u961f\u5217\u6838\u6570)\uff1a%d, Number of queue instances(\u961f\u5217\u5b9e\u4f8b\u6570)\uff1a%d", this.queueName, ByteTimeUtils.bytesToString((long)this.queueMemory), this.queueCores, this.queueInstances);
    }
}

