/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.client.deployment;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.client.context.ExecutionContext;
import org.apache.linkis.engineplugin.spark.client.context.SparkConfig;
import org.apache.linkis.engineplugin.spark.client.deployment.ClusterDescriptorAdapter;
import org.apache.linkis.engineplugin.spark.client.deployment.util.KubernetesHelper;
import org.apache.logging.log4j.util.Strings;
import org.apache.spark.launcher.CustomSparkSubmitLauncher;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesApplicationClusterDescriptorAdapter
extends ClusterDescriptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesApplicationClusterDescriptorAdapter.class);
    protected SparkConfig sparkConfig;
    protected KubernetesClient client;
    protected String driverPodName;
    protected String namespace;

    public KubernetesApplicationClusterDescriptorAdapter(ExecutionContext executionContext) {
        super(executionContext);
        this.sparkConfig = executionContext.getSparkConfig();
        this.client = KubernetesHelper.getKubernetesClient(this.sparkConfig.getK8sConfigFile(), this.sparkConfig.getK8sMasterUrl(), this.sparkConfig.getK8sUsername(), this.sparkConfig.getK8sPassword());
    }

    @Override
    public void deployCluster(String mainClass, String args, Map<String, String> confMap) throws IOException {
        SparkConfig sparkConfig = this.executionContext.getSparkConfig();
        this.sparkLauncher = new CustomSparkSubmitLauncher();
        this.sparkLauncher.setJavaHome(sparkConfig.getJavaHome()).setSparkHome(sparkConfig.getSparkHome()).setMaster(sparkConfig.getK8sMasterUrl()).setDeployMode("cluster").setAppName(sparkConfig.getAppName()).setVerbose(true);
        this.driverPodName = this.generateDriverPodName(sparkConfig.getAppName());
        this.namespace = sparkConfig.getK8sNamespace();
        this.setConf(this.sparkLauncher, "spark.app.name", sparkConfig.getAppName());
        this.setConf(this.sparkLauncher, "spark.ui.port", sparkConfig.getK8sSparkUIPort());
        this.setConf(this.sparkLauncher, "spark.kubernetes.namespace", this.namespace);
        this.setConf(this.sparkLauncher, "spark.kubernetes.container.image", sparkConfig.getK8sImage());
        this.setConf(this.sparkLauncher, "spark.kubernetes.driver.pod.name", this.driverPodName);
        this.setConf(this.sparkLauncher, "spark.kubernetes.driver.request.cores", sparkConfig.getK8sDriverRequestCores());
        this.setConf(this.sparkLauncher, "spark.kubernetes.executor.request.cores", sparkConfig.getK8sExecutorRequestCores());
        this.setConf(this.sparkLauncher, "spark.kubernetes.container.image.pullPolicy", sparkConfig.getK8sImagePullPolicy());
        this.setConf(this.sparkLauncher, "spark.kubernetes.authenticate.driver.serviceAccountName", sparkConfig.getK8sServiceAccount());
        if (confMap != null) {
            confMap.forEach((k, v) -> this.sparkLauncher.setConf((String)k, (String)v));
        }
        this.addSparkArg(this.sparkLauncher, "--jars", sparkConfig.getJars());
        this.addSparkArg(this.sparkLauncher, "--packages", sparkConfig.getPackages());
        this.addSparkArg(this.sparkLauncher, "--exclude-packages", sparkConfig.getExcludePackages());
        this.addSparkArg(this.sparkLauncher, "--repositories", sparkConfig.getRepositories());
        this.addSparkArg(this.sparkLauncher, "--files", sparkConfig.getFiles());
        this.addSparkArg(this.sparkLauncher, "--archives", sparkConfig.getArchives());
        this.addSparkArg(this.sparkLauncher, "--driver-memory", sparkConfig.getDriverMemory());
        this.addSparkArg(this.sparkLauncher, "--driver-java-options", sparkConfig.getDriverJavaOptions());
        this.addSparkArg(this.sparkLauncher, "--driver-library-path", sparkConfig.getDriverLibraryPath());
        this.addSparkArg(this.sparkLauncher, "--driver-class-path", sparkConfig.getDriverClassPath());
        this.addSparkArg(this.sparkLauncher, "--executor-memory", sparkConfig.getExecutorMemory());
        this.addSparkArg(this.sparkLauncher, "--proxy-user", sparkConfig.getProxyUser());
        this.addSparkArg(this.sparkLauncher, "--driver-cores", sparkConfig.getDriverCores().toString());
        this.addSparkArg(this.sparkLauncher, "--total-executor-cores", sparkConfig.getTotalExecutorCores());
        this.addSparkArg(this.sparkLauncher, "--executor-cores", sparkConfig.getExecutorCores().toString());
        this.addSparkArg(this.sparkLauncher, "--num-executors", sparkConfig.getNumExecutors().toString());
        this.addSparkArg(this.sparkLauncher, "--principal", sparkConfig.getPrincipal());
        this.addSparkArg(this.sparkLauncher, "--keytab", sparkConfig.getKeytab());
        this.addSparkArg(this.sparkLauncher, "--py-files", sparkConfig.getPyFiles());
        this.sparkLauncher.setAppResource(sparkConfig.getAppResource());
        this.sparkLauncher.setMainClass(mainClass);
        Arrays.stream(args.split("\\s+")).filter(StringUtils::isNotBlank).forEach(arg -> this.sparkLauncher.addAppArgs(new String[]{arg}));
        this.sparkAppHandle = this.sparkLauncher.startApplication(new SparkAppHandle.Listener[]{new SparkAppHandle.Listener(){

            public void stateChanged(SparkAppHandle sparkAppHandle) {
            }

            public void infoChanged(SparkAppHandle sparkAppHandle) {
            }
        }});
        this.sparkLauncher.setSparkAppHandle(this.sparkAppHandle);
    }

    private void addSparkArg(SparkLauncher sparkLauncher, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            sparkLauncher.addSparkArg(key, value);
        }
    }

    private void setConf(SparkLauncher sparkLauncher, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            sparkLauncher.setConf(key, value);
        }
    }

    @Override
    public boolean initJobId() {
        Pod sparkDriverPod = this.getSparkDriverPod();
        if (null == sparkDriverPod) {
            return false;
        }
        String sparkDriverPodPhase = sparkDriverPod.getStatus().getPhase();
        String sparkApplicationId = (String)sparkDriverPod.getMetadata().getLabels().get("spark-app-selector");
        if (Strings.isNotBlank((String)sparkApplicationId)) {
            this.applicationId = sparkApplicationId;
        }
        if (Strings.isNotBlank((String)sparkDriverPodPhase)) {
            this.jobState = this.kubernetesPodStateConvertSparkState(sparkDriverPodPhase);
        }
        return null != this.getApplicationId() || this.jobState != null && this.jobState.isFinal();
    }

    protected Pod getSparkDriverPod() {
        return (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.driverPodName)).get();
    }

    public String getSparkUIUrl() {
        Pod sparkDriverPod = this.getSparkDriverPod();
        if (null != sparkDriverPod) {
            String sparkDriverPodIP = sparkDriverPod.getStatus().getPodIP();
            if (StringUtils.isNotBlank((CharSequence)sparkDriverPodIP)) {
                return sparkDriverPodIP + ":" + this.sparkConfig.getK8sSparkUIPort();
            }
            logger.info("spark driver pod IP is null, the application may be pending");
        } else {
            logger.info("spark driver pod is not exist");
        }
        return "";
    }

    @Override
    public SparkAppHandle.State getJobState() {
        Pod sparkDriverPod = this.getSparkDriverPod();
        if (null != sparkDriverPod) {
            String sparkDriverPodPhase = sparkDriverPod.getStatus().getPhase();
            this.jobState = this.kubernetesPodStateConvertSparkState(sparkDriverPodPhase);
            logger.info("Job {} state is {}.", (Object)this.getApplicationId(), (Object)this.jobState);
            return this.jobState;
        }
        return null;
    }

    @Override
    public void close() {
        logger.info("Start to close job {}.", (Object)this.getApplicationId());
        this.client.close();
        if (this.isDisposed()) {
            logger.info("Job has finished, close action return.");
            return;
        }
        PodResource sparkDriverPodResource = (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.driverPodName);
        if (null != sparkDriverPodResource.get()) {
            sparkDriverPodResource.delete();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.jobState.isFinal();
    }

    public SparkAppHandle.State kubernetesPodStateConvertSparkState(String kubernetesState) {
        if (StringUtils.isBlank((CharSequence)kubernetesState)) {
            return SparkAppHandle.State.UNKNOWN;
        }
        switch (kubernetesState.toUpperCase()) {
            case "PENDING": {
                return SparkAppHandle.State.CONNECTED;
            }
            case "RUNNING": {
                return SparkAppHandle.State.RUNNING;
            }
            case "SUCCEEDED": {
                return SparkAppHandle.State.FINISHED;
            }
            case "FAILED": {
                return SparkAppHandle.State.FAILED;
            }
        }
        return SparkAppHandle.State.UNKNOWN;
    }

    public String generateDriverPodName(String appName) {
        return appName + "-" + UUID.randomUUID().toString().replace("-", "") + "-driver";
    }
}

