/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.cs.common.entity.listener.CommonContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.listener.callback.imp.ContextKeyValueBean;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.apache.linkis.cs.persistence.ContextPersistenceManager;
import org.apache.linkis.cs.persistence.persistence.ContextIDListenerPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextKeyListenerPersistence;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.service.ContextListenerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextListenerServiceImpl
extends ContextListenerService {
    @Autowired
    private ContextPersistenceManager persistenceManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private ContextIDListenerPersistence getIDListenerPersistence() throws CSErrorException {
        return this.persistenceManager.getContextIDListenerPersistence();
    }

    private ContextKeyListenerPersistence getKeyListenerPersistence() throws CSErrorException {
        return this.persistenceManager.getContextKeyListenerPersistence();
    }

    @Override
    public String getName() {
        return ServiceType.CONTEXT_LISTENER.name();
    }

    @Override
    public void onBind(ContextID contextID, ContextIDListenerDomain domain) throws CSErrorException {
        this.logger.info(String.format("onBind,csId:%s", contextID.getContextId()));
        domain.setContextID(contextID);
        this.getIDListenerPersistence().create(contextID, domain);
        DefaultContextListenerManager instance = DefaultContextListenerManager.getInstance();
        instance.getContextIDCallbackEngine().registerClient((ListenerDomain)domain);
    }

    @Override
    public void onBind(ContextID contextID, ContextKey contextKey, ContextKeyListenerDomain domain) throws CSErrorException {
        this.logger.info(String.format("onBind,csId:%s,key:%s", contextID.getContextId(), contextKey.getKey()));
        domain.setContextKey(contextKey);
        if (domain instanceof CommonContextKeyListenerDomain) {
            ((CommonContextKeyListenerDomain)domain).setContextID(contextID);
        }
        this.getKeyListenerPersistence().create(contextID, domain);
        DefaultContextListenerManager instance = DefaultContextListenerManager.getInstance();
        instance.getContextKeyCallbackEngine().registerClient((ListenerDomain)domain);
    }

    @Override
    public List<ContextKeyValueBean> heartbeat(String clientSource) {
        this.logger.info(String.format("heartbeat,clientSource:%s", clientSource));
        DefaultContextListenerManager instance = DefaultContextListenerManager.getInstance();
        ArrayList idCallback = instance.getContextIDCallbackEngine().getListenerCallback(clientSource);
        ArrayList keyCallback = instance.getContextKeyCallbackEngine().getListenerCallback(clientSource);
        idCallback.addAll(keyCallback);
        return idCallback;
    }
}

