/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler.queue;

import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.listener.ListenerEventBus;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.scheduler.event.ScheduleEvent;
import org.apache.linkis.scheduler.exception.LinkisJobRetryException$;
import org.apache.linkis.scheduler.executer.AsynReturnExecuteResponse;
import org.apache.linkis.scheduler.executer.CompletedExecuteResponse;
import org.apache.linkis.scheduler.executer.ConcurrentTaskOperateSupport;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteRequest;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.IncompleteExecuteResponse;
import org.apache.linkis.scheduler.executer.SingleTaskOperateSupport;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.scheduler.future.BDPFuture;
import org.apache.linkis.scheduler.listener.JobListener;
import org.apache.linkis.scheduler.listener.LogListener;
import org.apache.linkis.scheduler.listener.ProgressListener;
import org.apache.linkis.scheduler.listener.SchedulerListener;
import org.apache.linkis.scheduler.queue.JobDaemon;
import org.apache.linkis.scheduler.queue.JobInfo;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rme!\u0002)R\u0003\u0003a\u0006\"\u0002>\u0001\t\u0003Y\bBC?\u0001\u0001\u0004\u0005\r\u0011\"\u0001V}\"a\u0011q\u0006\u0001A\u0002\u0003\u0007I\u0011A+\u00022!Q\u0011\u0011\u0004\u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u0019\u0005\u0015\u0003\u00011AA\u0002\u0013\u0005\u0011+a\u0012\t\u0019\u0005M\u0003\u00011AA\u0002\u0013\u0005\u0011+!\u0016\t\u0017\u0005e\u0003\u00011A\u0001B\u0003&\u0011\u0011\n\u0005\n\u00037\u0002\u0001\u0019!C\t\u0003;B\u0011\"a\u001b\u0001\u0001\u0004%\t\"!\u001c\t\u0011\u0005E\u0004\u0001)Q\u0005\u0003?B1\"a\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002v!Y\u0011Q\u0016\u0001A\u0002\u0003\u0007I\u0011BAX\u0011-\tY\t\u0001a\u0001\u0002\u0003\u0006K!a\u001e\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0019\u0005\f\u0003\u001f\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u000eC\u0006\u0002V\u0002\u0001\r\u0011!Q!\n\u0005\r\u0007\"CAl\u0001\u0001\u0007I\u0011BAm\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BAn\u0011%\tY\u000f\u0001a\u0001\n\u0013\ti\u000fC\u0005\u0002x\u0002\u0001\r\u0011\"\u0003\u0002z\"A\u0011Q \u0001!B\u0013\ty\u000fC\u0005\u0002\u0000\u0002\u0001\r\u0011\"\u0003\u0003\u0002!I!1\u0002\u0001A\u0002\u0013%!Q\u0002\u0005\t\u0005#\u0001\u0001\u0015)\u0003\u0003\u0004!Q!1\u0003\u0001A\u0002\u0013\u0005QK!\u0006\t\u0015\tu\u0001\u00011A\u0005\u0002U\u0013y\u0002\u0003\u0005\u0003$\u0001\u0001\u000b\u0015\u0002B\f\u0011%\u0011)\u0003\u0001a\u0001\n\u0013\u00119\u0003C\u0005\u00030\u0001\u0001\r\u0011\"\u0003\u00032!A!Q\u0007\u0001!B\u0013\u0011I\u0003C\u0005\u00038\u0001\u0001\r\u0011\"\u0003\u0003:!I!\u0011\t\u0001A\u0002\u0013%!1\t\u0005\t\u0005\u000f\u0002\u0001\u0015)\u0003\u0003<!a!\u0011\n\u0001A\u0002\u0003\u0007I\u0011A+\u0003L!a!1\u000b\u0001A\u0002\u0003\u0007I\u0011A+\u0003V!Y!\u0011\f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B'\u0011\u001d\u0011Y\u0006\u0001C!\u0005+AqA!\u0018\u0001\t\u0003\u0012)\u0002C\u0004\u0003`\u0001!\tA!\u0019\t\u0011\t\r\u0004\u0001\"\u0001R\u0003;BqA!\u001a\u0001\t\u0003\u0012\t\u0007C\u0004\u0003h\u0001!\tE!\u001b\t\u000f\t\u0005\u0005\u0001\"\u0011\u0003b!9!1\u0011\u0001\u0005B\t\u0005\u0004b\u0002BC\u0001\u0011%!\u0011\r\u0005\b\u0005\u000f\u0003A\u0011\u0001BE\u0011\u001d\u0011)\u000b\u0001C\t\u0005OCqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u0003B\u0002!\tAa1\t\u000f\t\u001d\u0007\u0001\"\u0005\u0002B\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bh\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0011\u001d\u00119\u000e\u0001C\u0001\u0003[DqA!7\u0001\t\u0003\u0011Y\u000eC\u0004\u0003`\u0002!\tA!\u0001\t\u000f\t\u0005\b\u0001\"\u0001\u0003(!9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bu\u0001\u0019\u0005!\u0011\r\u0005\b\u0007?\u0001a\u0011CB\u0011\u0011\u001d\u0019)\u0004\u0001D\u0001\u0005\u007fDqaa\u000e\u0001\r\u0003\u0019I\u0004C\u0004\u0004B\u0001!\tAa\u0013\t\u000f\r\r\u0003\u0001\"\u0005\u0003\u0016!91Q\t\u0001\u0005\u0012\r\u001d\u0003bBB%\u0001\u0011E11\n\u0005\b\u0007'\u0002A\u0011IB+\u0011\u001d\u0019i\u0007\u0001C!\u0007_Bqa!\u001e\u0001\t#\u00199\bC\u0004\u0004\u0004\u0002!\tA!\u0006\t\u000f\r\u0015\u0005\u0001\"\u0001\u0003:!91q\u0011\u0001\u0005\u0012\te\u0002bBBE\u0001\u0011E11\u0012\u0005\b\u0007\u001f\u0003AQ\u0001B\u000b\u0011\u001d\u0019\t\n\u0001C\u0003\u0007'Cqa!&\u0001\t\u0003\u0012\t\u0007C\u0004\u0004\u0018\u0002!\tE!\u001b\t\u000f\re\u0005\u0001\"\u0001\u0003b\t\u0019!j\u001c2\u000b\u0005I\u001b\u0016!B9vKV,'B\u0001+V\u0003%\u00198\r[3ek2,'O\u0003\u0002W/\u00061A.\u001b8lSNT!\u0001W-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0016aA8sO\u000e\u00011C\u0002\u0001^K\"d'\u000f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\r=\u0013'.Z2u!\tqf-\u0003\u0002h?\nA!+\u001e8oC\ndW\r\u0005\u0002jU6\t\u0011+\u0003\u0002l#\nq1k\u00195fIVdWM]#wK:$\bCA7q\u001b\u0005q'BA8b\u0003\tIw.\u0003\u0002r]\nI1\t\\8tK\u0006\u0014G.\u001a\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fQ!\u001e;jYNT!a^+\u0002\r\r|W.\\8o\u0013\tIHOA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005a\bCA5\u0001\u0003\u00191W\u000f^;sKV\tq\u0010\r\u0003\u0002\u0002\u0005U\u0001CBA\u0002\u0003\u001b\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0017\t\u0017\u0001B;uS2LA!a\u0004\u0002\u0006\t1a)\u001e;ve\u0016\u0004B!a\u0005\u0002\u00161\u0001AaCA\f\t\u0005\u0005\t\u0011!B\u0001\u00037\u00111a\u0018\u00132\u0003\u001d1W\u000f^;sK\u0002\nB!!\b\u0002*A!\u0011qDA\u0013\u001b\t\t\tC\u0003\u0002\u0002$\u0005)1oY1mC&!\u0011qEA\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\b\u0002,%!\u0011QFA\u0011\u0005\r\te._\u0001\u000bMV$XO]3`I\u0015\fH\u0003BA\u001a\u0003s\u0001B!a\b\u00026%!\u0011qGA\u0011\u0005\u0011)f.\u001b;\t\u0013\u0005m2!!AA\u0002\u0005u\u0012a\u0001=%cA\"\u0011qHA\"!\u0019\t\u0019!!\u0004\u0002BA!\u00111CA\"\t1\t9\"!\u000f\u0002\u0002\u0003\u0005)\u0011AA\u000e\u00039\u0019wN\\:v[\u0016\u0014h)\u001e;ve\u0016,\"!!\u0013\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR!!`*\n\t\u0005E\u0013Q\n\u0002\n\u0005\u0012\u0003f)\u001e;ve\u0016\f!cY8ogVlWM\u001d$viV\u0014Xm\u0018\u0013fcR!\u00111GA,\u0011%\tYDBA\u0001\u0002\u0004\tI%A\bd_:\u001cX/\\3s\rV$XO]3!\u0003%QwN\u0019#bK6|g.\u0006\u0002\u0002`A1\u0011qDA1\u0003KJA!a\u0019\u0002\"\t1q\n\u001d;j_:\u00042![A4\u0013\r\tI'\u0015\u0002\n\u0015>\u0014G)Y3n_:\fQB[8c\t\u0006,Wn\u001c8`I\u0015\fH\u0003BA\u001a\u0003_B\u0011\"a\u000f\n\u0003\u0003\u0005\r!a\u0018\u0002\u0015)|'\rR1f[>t\u0007%\u0001\tfm\u0016tG\u000fT5ti\u0016tWM\u001d\"vgV\u0011\u0011q\u000f\u0019\u0007\u0003s\n9)a'\u0011\u0011\u0005m\u0014\u0011QAC\u00033k!!! \u000b\u0007\u0005}d/\u0001\u0005mSN$XM\\3s\u0013\u0011\t\u0019)! \u0003!1K7\u000f^3oKJ,e/\u001a8u\u0005V\u001c\b\u0003BA\n\u0003\u000f#1\"!#\u000e\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\n\u0019q\f\n\u001a\u0002#\u00154XM\u001c;MSN$XM\\3s\u0005V\u001c\b%\u0005\u0003\u0002\u001e\u0005=\u0005\u0003BAI\u0003+k!!a%\u000b\u0007\u0005}4+\u0003\u0003\u0002\u0018\u0006M%!E*dQ\u0016$W\u000f\\3s\u0019&\u001cH/\u001a8feB!\u00111CAN\t-\ti*DA\u0001\u0002\u0003\u0015\t!a(\u0003\u0007}#3'\u0005\u0003\u0002\u001e\u0005\u0005\u0006\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001d6+A\u0003fm\u0016tG/\u0003\u0003\u0002,\u0006\u0015&!D*dQ\u0016$W\u000f\\3Fm\u0016tG/\u0001\u000bfm\u0016tG\u000fT5ti\u0016tWM\u001d\"vg~#S-\u001d\u000b\u0005\u0003g\t\t\fC\u0005\u0002<1\t\t\u00111\u0001\u00024B2\u0011QWA]\u0003{\u0003\u0002\"a\u001f\u0002\u0002\u0006]\u00161\u0018\t\u0005\u0003'\tI\f\u0002\u0007\u0002\n\u0006E\u0016\u0011!A\u0001\u0006\u0003\ti\t\u0005\u0003\u0002\u0014\u0005uF\u0001DAO\u0003c\u000b\t\u0011!A\u0003\u0002\u0005}\u0015\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\u0005\r\u0007\u0003BAc\u0003\u0017l!!a2\u000b\u0007\u0005%7+\u0001\u0005fq\u0016\u001cW\u000f^3s\u0013\u0011\ti-a2\u0003\u0011\u0015CXmY;u_J\fA\"\u001a=fGV$xN]0%KF$B!a\r\u0002T\"I\u00111H\b\u0002\u0002\u0003\u0007\u00111Y\u0001\nKb,7-\u001e;pe\u0002\n1B[8c\u0019&\u001cH/\u001a8feV\u0011\u00111\u001c\t\u0007\u0003?\t\t'!8\u0011\t\u0005E\u0015q\\\u0005\u0005\u0003C\f\u0019JA\u0006K_\nd\u0015n\u001d;f]\u0016\u0014\u0018a\u00046pE2K7\u000f^3oKJ|F%Z9\u0015\t\u0005M\u0012q\u001d\u0005\n\u0003w\u0011\u0012\u0011!a\u0001\u00037\fAB[8c\u0019&\u001cH/\u001a8fe\u0002\n1\u0002\\8h\u0019&\u001cH/\u001a8feV\u0011\u0011q\u001e\t\u0007\u0003?\t\t'!=\u0011\t\u0005E\u00151_\u0005\u0005\u0003k\f\u0019JA\u0006M_\u001ed\u0015n\u001d;f]\u0016\u0014\u0018a\u00047pO2K7\u000f^3oKJ|F%Z9\u0015\t\u0005M\u00121 \u0005\n\u0003w)\u0012\u0011!a\u0001\u0003_\fA\u0002\\8h\u0019&\u001cH/\u001a8fe\u0002\n\u0001\u0003\u001d:pOJ,7o\u001d'jgR,g.\u001a:\u0016\u0005\t\r\u0001CBA\u0010\u0003C\u0012)\u0001\u0005\u0003\u0002\u0012\n\u001d\u0011\u0002\u0002B\u0005\u0003'\u0013\u0001\u0003\u0015:pOJ,7o\u001d'jgR,g.\u001a:\u0002)A\u0014xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014x\fJ3r)\u0011\t\u0019Da\u0004\t\u0013\u0005m\u0002$!AA\u0002\t\r\u0011!\u00059s_\u001e\u0014Xm]:MSN$XM\\3sA\u0005I\u0011N\u001c;feJ,\b\u000f^\u000b\u0003\u0005/\u0001B!a\b\u0003\u001a%!!1DA\u0011\u0005\u001d\u0011un\u001c7fC:\fQ\"\u001b8uKJ\u0014X\u000f\u001d;`I\u0015\fH\u0003BA\u001a\u0005CA\u0011\"a\u000f\u001c\u0003\u0003\u0005\rAa\u0006\u0002\u0015%tG/\u001a:skB$\b%\u0001\u0005qe><'/Z:t+\t\u0011I\u0003\u0005\u0003\u0002 \t-\u0012\u0002\u0002B\u0017\u0003C\u0011QA\u00127pCR\fA\u0002\u001d:pOJ,7o]0%KF$B!a\r\u00034!I\u00111\b\u0010\u0002\u0002\u0003\u0007!\u0011F\u0001\naJ|wM]3tg\u0002\n\u0001B]3ueftU/\\\u000b\u0003\u0005w\u0001B!a\b\u0003>%!!qHA\u0011\u0005\rIe\u000e^\u0001\re\u0016$(/\u001f(v[~#S-\u001d\u000b\u0005\u0003g\u0011)\u0005C\u0005\u0002<\u0005\n\t\u00111\u0001\u0003<\u0005I!/\u001a;ss:+X\u000eI\u0001\u0015KJ\u0014xN]#yK\u000e,H/\u001a*fgB|gn]3\u0016\u0005\t5\u0003\u0003BAc\u0005\u001fJAA!\u0015\u0002H\n!RI\u001d:pe\u0016CXmY;uKJ+7\u000f]8og\u0016\f\u0001$\u001a:s_J,\u00050Z2vi\u0016\u0014Vm\u001d9p]N,w\fJ3r)\u0011\t\u0019Da\u0016\t\u0013\u0005mB%!AA\u0002\t5\u0013!F3se>\u0014X\t_3dkR,'+Z:q_:\u001cX\rI\u0001\nSN<\u0016-\u001b;j]\u001e\f1\"[:D_6\u0004H.\u001a;fI\u0006!1.\u001b7m)\t\t\u0019$\u0001\u0007hKRTuN\u0019#bK6|g.\u0001\u0004dC:\u001cW\r\\\u0001\u0006O\u0016$\u0018\n\u001a\u000b\u0003\u0005W\u0002BA!\u001c\u0003|9!!q\u000eB<!\u0011\u0011\t(!\t\u000e\u0005\tM$b\u0001B;7\u00061AH]8pizJAA!\u001f\u0002\"\u00051\u0001K]3eK\u001aLAA! \u0003\u0000\t11\u000b\u001e:j]\u001eTAA!\u001f\u0002\"\u0005)\u0001/Y;tK\u00061!/Z:v[\u0016\fab[5mY\nKX\t_3dkR|'/A\u0005p]\u001a\u000b\u0017\u000e\\;sKR1\u00111\u0007BF\u0005\u001fCqA!$0\u0001\u0004\u0011Y'\u0001\u0005feJ|'/T:h\u0011\u001d\u0011\tj\fa\u0001\u0005'\u000b\u0011\u0001\u001e\t\u0005\u0005+\u0013yJ\u0004\u0003\u0003\u0018\nme\u0002\u0002B9\u00053K!!a\t\n\t\tu\u0015\u0011E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tKa)\u0003\u0013QC'o\\<bE2,'\u0002\u0002BO\u0003C\t1BZ8sG\u0016\u001c\u0015M\\2fYR!\u00111\u0007BU\u0011\u001d\u0011\t\n\ra\u0001\u0005'\u000b1c]3u\u0019&\u001cH/\u001a8fe\u00163XM\u001c;CkN$B!a\r\u00030\"9\u00111O\u0019A\u0002\tE\u0006G\u0002BZ\u0005o\u0013i\f\u0005\u0005\u0002|\u0005\u0005%Q\u0017B^!\u0011\t\u0019Ba.\u0005\u0019\te&qVA\u0001\u0002\u0003\u0015\t!!$\u0003\u0007}#C\u0007\u0005\u0003\u0002\u0014\tuF\u0001\u0004B`\u0005_\u000b\t\u0011!A\u0003\u0002\u0005}%aA0%k\u0005Y1/\u001a;Fq\u0016\u001cW\u000f^8s)\u0011\t\u0019D!2\t\u000f\u0005}&\u00071\u0001\u0002D\u0006Yq-\u001a;Fq\u0016\u001cW\u000f^8s\u00039\u0019X\r\u001e&pE2K7\u000f^3oKJ$B!a\r\u0003N\"9\u0011q\u001b\u001bA\u0002\u0005u\u0017AD4fi*{'\rT5ti\u0016tWM]\u0001\u000fg\u0016$Hj\\4MSN$XM\\3s)\u0011\t\u0019D!6\t\u000f\u0005-h\u00071\u0001\u0002r\u0006qq-\u001a;M_\u001ed\u0015n\u001d;f]\u0016\u0014\u0018aE:fiB\u0013xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014H\u0003BA\u001a\u0005;Dq!a@9\u0001\u0004\u0011)!A\nhKR\u0004&o\\4sKN\u001cH*[:uK:,'/A\u0006hKR\u0004&o\\4sKN\u001c\u0018aC:fiB\u0013xn\u001a:fgN$B!a\r\u0003h\"9!QE\u001eA\u0002\t%\u0012\u0001B5oSRDS\u0001\u0010Bw\u0005s\u0004b!a\b\u0003p\nM\u0018\u0002\u0002By\u0003C\u0011a\u0001\u001e5s_^\u001c\b\u0003\u0002BK\u0005kLAAa>\u0003$\nIQ\t_2faRLwN\\\u0019\b=\t-$1`B\u000fc%\u0019#Q`B\u0003\u0007'\u00199!\u0006\u0003\u0003\u0000\u000e\u0005QC\u0001B6\t\u001d\u0019\u0019a\u0017b\u0001\u0007\u001b\u0011\u0011\u0001V\u0005\u0005\u0007\u000f\u0019I!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0005\u0007\u0017\t\t#\u0001\u0004uQJ|wo]\t\u0005\u0003;\u0019y\u0001\u0005\u0003\u0004\u0012\t}e\u0002BA\u0010\u00057\u000b\u0014bIB\u000b\u0007/\u0019Iba\u0003\u000f\t\u0005}1qC\u0005\u0005\u0007\u0017\t\t#M\u0004#\u0003?\t\tca\u0007\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\u0012\u00190A\nk_\n$v.\u0012=fGV$XMU3rk\u0016\u001cH/\u0006\u0002\u0004$A!\u0011QYB\u0013\u0013\u0011\u00199#a2\u0003\u001d\u0015CXmY;uKJ+\u0017/^3ti\"*QH!<\u0004,E:aDa\u001b\u0004.\rM\u0012'C\u0012\u0003~\u000e\u00151qFB\u0004c%\u00193QCB\f\u0007c\u0019Y!M\u0004#\u0003?\t\tca\u00072\u0007\u0019\u0012\u00190A\u0004hKRt\u0015-\\3\u0002\u0015\u001d,GOS8c\u0013:4w.\u0006\u0002\u0004<A\u0019\u0011n!\u0010\n\u0007\r}\u0012KA\u0004K_\nLeNZ8\u0002!\u001d,G/\u0012:s_J\u0014Vm\u001d9p]N,\u0017aD3ySN$8OS8c\t\u0006,Wn\u001c8\u0002\u001f\r\u0014X-\u0019;f\u0015>\u0014G)Y3n_:,\"!!\u001a\u0002/)|'\rR1f[>tW\u000b\u001d3bi\u0016Le\u000e^3sm\u0006dWCAB'!\u0011\tyba\u0014\n\t\rE\u0013\u0011\u0005\u0002\u0005\u0019>tw-\u0001\ncK\u001a|'/Z*uCR,7\t[1oO\u0016$GCBA\u001a\u0007/\u001aI\u0007C\u0004\u0004Z\u0011\u0003\raa\u0017\u0002\u0013\u0019\u0014x.\\*uCR,\u0007\u0003BB/\u0007Gr1![B0\u0013\r\u0019\t'U\u0001\u0014'\u000eDW\rZ;mKJ,e/\u001a8u'R\fG/Z\u0005\u0005\u0007K\u001a9GA\nTG\",G-\u001e7fe\u00163XM\u001c;Ti\u0006$XMC\u0002\u0004bECqaa\u001bE\u0001\u0004\u0019Y&A\u0004u_N#\u0018\r^3\u0002#\u00054G/\u001a:Ti\u0006$Xm\u00115b]\u001e,G\r\u0006\u0004\u00024\rE41\u000f\u0005\b\u00073*\u0005\u0019AB.\u0011\u001d\u0019Y'\u0012a\u0001\u00077\n1\u0003\u001e:b]NLG/[8o\u0007>l\u0007\u000f\\3uK\u0012$B!a\r\u0004z!911\u0010$A\u0002\ru\u0014\u0001E3yK\u000e,H/Z\"p[BdW\r^3e!\u0011\t)ma \n\t\r\u0005\u0015q\u0019\u0002\u0019\u0007>l\u0007\u000f\\3uK\u0012,\u00050Z2vi\u0016\u0014Vm\u001d9p]N,\u0017!E5t\u0015>\u00147+\u001e9q_J$(+\u001a;ss\u0006Yq-\u001a;SKR\u0014\u0018PT;n\u000399W\r^'bqJ+GO]=Ok6\f\u0001#[:K_\n\u001c\u0006n\\;mIJ+GO]=\u0015\t\t]1Q\u0012\u0005\b\u0005\u0013R\u0005\u0019\u0001B'\u00035I7OS8c\u0007\u0006t'+\u001a;ss\u0006YA/\u001e:o)>\u0014V\r\u001e:z)\t\u00119\"A\u0002sk:\f\u0001\u0002^8TiJLgnZ\u0001\u0006G2,\u0017M\u001d")
public abstract class Job
implements Runnable,
SchedulerEvent,
Closeable {
    private Future<?> future;
    private BDPFuture consumerFuture;
    private Option<JobDaemon> jobDaemon;
    private ListenerEventBus<? extends SchedulerListener, ? extends ScheduleEvent> eventListenerBus;
    private Executor executor;
    private Option<JobListener> jobListener;
    private Option<LogListener> logListener;
    private Option<ProgressListener> progressListener;
    private boolean interrupt;
    private float progress;
    private int retryNum;
    private ErrorExecuteResponse errorExecuteResponse;
    private String id;
    private Enumeration.Value org$apache$linkis$scheduler$queue$SchedulerEvent$$state;
    private final long createTime;
    private long scheduledTime;
    private long startTime;
    private long endTime;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public long getEndTime() {
        return SchedulerEvent.getEndTime$(this);
    }

    @Override
    public long getStartTime() {
        return SchedulerEvent.getStartTime$(this);
    }

    @Override
    public long getScheduledTime() {
        return SchedulerEvent.getScheduledTime$(this);
    }

    @Override
    public void setId(String id) {
        SchedulerEvent.setId$(this, id);
    }

    @Override
    public boolean turnToScheduled() {
        return SchedulerEvent.turnToScheduled$(this);
    }

    @Override
    public boolean isScheduled() {
        return SchedulerEvent.isScheduled$(this);
    }

    @Override
    public boolean isRunning() {
        return SchedulerEvent.isRunning$(this);
    }

    @Override
    public boolean isSucceed() {
        return SchedulerEvent.isSucceed$(this);
    }

    @Override
    public boolean isWaitForRetry() {
        return SchedulerEvent.isWaitForRetry$(this);
    }

    @Override
    public Enumeration.Value getState() {
        return SchedulerEvent.getState$(this);
    }

    @Override
    public void transition(Enumeration.Value state) {
        SchedulerEvent.transition$(this, state);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void id_$eq(String x$1) {
        this.id = x$1;
    }

    @Override
    public Enumeration.Value org$apache$linkis$scheduler$queue$SchedulerEvent$$state() {
        return this.org$apache$linkis$scheduler$queue$SchedulerEvent$$state;
    }

    @Override
    public void org$apache$linkis$scheduler$queue$SchedulerEvent$$state_$eq(Enumeration.Value x$1) {
        this.org$apache$linkis$scheduler$queue$SchedulerEvent$$state = x$1;
    }

    @Override
    public long createTime() {
        return this.createTime;
    }

    @Override
    public long scheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public void scheduledTime_$eq(long x$1) {
        this.scheduledTime = x$1;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void endTime_$eq(long x$1) {
        this.endTime = x$1;
    }

    @Override
    public void org$apache$linkis$scheduler$queue$SchedulerEvent$_setter_$createTime_$eq(long x$1) {
        this.createTime = x$1;
    }

    private Logger logger$lzycompute() {
        Job job = this;
        synchronized (job) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Future<?> future() {
        return this.future;
    }

    public void future_$eq(Future<?> x$1) {
        this.future = x$1;
    }

    public BDPFuture consumerFuture() {
        return this.consumerFuture;
    }

    public void consumerFuture_$eq(BDPFuture x$1) {
        this.consumerFuture = x$1;
    }

    public Option<JobDaemon> jobDaemon() {
        return this.jobDaemon;
    }

    public void jobDaemon_$eq(Option<JobDaemon> x$1) {
        this.jobDaemon = x$1;
    }

    private ListenerEventBus<? extends SchedulerListener, ? extends ScheduleEvent> eventListenerBus() {
        return this.eventListenerBus;
    }

    private void eventListenerBus_$eq(ListenerEventBus<? extends SchedulerListener, ? extends ScheduleEvent> x$1) {
        this.eventListenerBus = x$1;
    }

    private Executor executor() {
        return this.executor;
    }

    private void executor_$eq(Executor x$1) {
        this.executor = x$1;
    }

    private Option<JobListener> jobListener() {
        return this.jobListener;
    }

    private void jobListener_$eq(Option<JobListener> x$1) {
        this.jobListener = x$1;
    }

    private Option<LogListener> logListener() {
        return this.logListener;
    }

    private void logListener_$eq(Option<LogListener> x$1) {
        this.logListener = x$1;
    }

    private Option<ProgressListener> progressListener() {
        return this.progressListener;
    }

    private void progressListener_$eq(Option<ProgressListener> x$1) {
        this.progressListener = x$1;
    }

    public boolean interrupt() {
        return this.interrupt;
    }

    public void interrupt_$eq(boolean x$1) {
        this.interrupt = x$1;
    }

    private float progress() {
        return this.progress;
    }

    private void progress_$eq(float x$1) {
        this.progress = x$1;
    }

    private int retryNum() {
        return this.retryNum;
    }

    private void retryNum_$eq(int x$1) {
        this.retryNum = x$1;
    }

    public ErrorExecuteResponse errorExecuteResponse() {
        return this.errorExecuteResponse;
    }

    public void errorExecuteResponse_$eq(ErrorExecuteResponse x$1) {
        this.errorExecuteResponse = x$1;
    }

    @Override
    public boolean isWaiting() {
        return SchedulerEvent.isWaiting$(this) && !this.interrupt();
    }

    @Override
    public boolean isCompleted() {
        return SchedulerEvent.isCompleted$(this) || this.interrupt();
    }

    public void kill() {
        this.onFailure("Job is killed by user!", null);
    }

    public Option<JobDaemon> getJobDaemon() {
        if (!this.existsJobDaemon()) {
            return None$.MODULE$;
        }
        if (this.jobDaemon().isEmpty()) {
            Job job = this;
            synchronized (job) {
                if (this.jobDaemon().isEmpty()) {
                    this.jobDaemon_$eq((Option<JobDaemon>)new Some((Object)this.createJobDaemon()));
                }
            }
        }
        return this.jobDaemon();
    }

    @Override
    public void cancel() {
        this.kill();
    }

    @Override
    public String getId() {
        return SchedulerEvent.getId$(this);
    }

    @Override
    public void pause() {
        if (this.executor() != null) {
            Executor executor = this.executor();
            if (executor instanceof SingleTaskOperateSupport) {
                Executor executor2 = executor;
                ((SingleTaskOperateSupport)((Object)executor2)).pause();
                return;
            }
            if (executor instanceof ConcurrentTaskOperateSupport) {
                Executor executor3 = executor;
                ((ConcurrentTaskOperateSupport)((Object)executor3)).pause(this.getId());
                return;
            }
            return;
        }
    }

    @Override
    public void resume() {
        if (this.executor() != null) {
            Executor executor = this.executor();
            if (executor instanceof SingleTaskOperateSupport) {
                Executor executor2 = executor;
                ((SingleTaskOperateSupport)((Object)executor2)).resume();
                return;
            }
            if (executor instanceof ConcurrentTaskOperateSupport) {
                Executor executor3 = executor;
                ((ConcurrentTaskOperateSupport)((Object)executor3)).resume(this.getId());
                return;
            }
            return;
        }
    }

    private void killByExecutor() {
        if (this.executor() != null) {
            Executor executor = this.executor();
            if (executor instanceof SingleTaskOperateSupport) {
                Executor executor2 = executor;
                ((SingleTaskOperateSupport)((Object)executor2)).kill();
                return;
            }
            if (executor instanceof ConcurrentTaskOperateSupport) {
                Executor executor3 = executor;
                ((ConcurrentTaskOperateSupport)((Object)executor3)).kill(this.getId());
                return;
            }
            return;
        }
    }

    public void onFailure(String errorMsg, Throwable t2) {
        if (!SchedulerEventState$.MODULE$.isCompleted(this.getState())) {
            Object object;
            this.logger().info(new StringBuilder(44).append("job ").append(this.toString()).append(" is onFailure on state ").append(this.getState()).append(" with errorMsg: ").append(errorMsg).append(".").toString());
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.logListener().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.onLogUpdate(this, LogUtils$.MODULE$.generateERROR(errorMsg));
                    return BoxedUnit.UNIT;
                });
                if (t2 != null) {
                    this.logListener().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                        x$2.onLogUpdate(this, LogUtils$.MODULE$.generateERROR(ExceptionUtils.getStackTrace((Throwable)t2)));
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }, this.logger());
            this.errorExecuteResponse_$eq(new ErrorExecuteResponse(errorMsg, t2));
            this.jobDaemon().foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.kill());
            this.interrupt_$eq(true);
            if (this.future() != null && !SchedulerEventState$.MODULE$.isCompleted(this.getState())) {
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.killByExecutor(), (Function1 & Serializable & scala.Serializable)t -> {
                    Job.$anonfun$onFailure$6(this, t);
                    return BoxedUnit.UNIT;
                });
                object = BoxesRunTime.boxToBoolean((boolean)this.future().cancel(true));
            } else {
                object = BoxedUnit.UNIT;
            }
            if (this.consumerFuture() != null && this.executor() == null) {
                this.logger().warn(new StringBuilder(91).append("This executor of job(").append(this.toString()).append(") in starting status,When kill job need to interrupter consumer Future").toString());
                this.consumerFuture().cancel();
                this.consumerFuture_$eq(null);
            }
            if (SchedulerEvent.isWaiting$(this) || SchedulerEvent.isScheduled$(this)) {
                this.transitionCompleted(this.errorExecuteResponse());
            }
            this.logger().info(new StringBuilder(26).append(this.toString()).append(" execute failed. Reason: ").append(errorMsg).append(".").toString(), t2);
            return;
        }
    }

    public void forceCancel(Throwable t) {
        this.logger().info(new StringBuilder(20).append("force to cancel job ").append(this.getName()).toString());
        ErrorExecuteResponse executeCompleted = new ErrorExecuteResponse("force to transition Failed", t);
        this.transitionCompleted(executeCompleted);
    }

    public void setListenerEventBus(ListenerEventBus<? extends SchedulerListener, ? extends ScheduleEvent> eventListenerBus) {
        this.eventListenerBus_$eq(eventListenerBus);
    }

    public void setExecutor(Executor executor) {
        this.executor_$eq(executor);
    }

    public Executor getExecutor() {
        return this.executor();
    }

    public void setJobListener(JobListener jobListener) {
        this.jobListener_$eq((Option<JobListener>)new Some((Object)jobListener));
    }

    public Option<JobListener> getJobListener() {
        return this.jobListener();
    }

    public void setLogListener(LogListener logListener) {
        this.logListener_$eq((Option<LogListener>)new Some((Object)logListener));
    }

    public Option<LogListener> getLogListener() {
        return this.logListener();
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener_$eq((Option<ProgressListener>)new Some((Object)progressListener));
    }

    public Option<ProgressListener> getProgressListener() {
        return this.progressListener();
    }

    public float getProgress() {
        return this.progress();
    }

    public void setProgress(float progress) {
        this.progress_$eq(progress);
    }

    public abstract void init() throws Exception;

    public abstract ExecuteRequest jobToExecuteRequest() throws Exception;

    public abstract String getName();

    public abstract JobInfo getJobInfo();

    public ErrorExecuteResponse getErrorResponse() {
        return this.errorExecuteResponse();
    }

    public boolean existsJobDaemon() {
        return false;
    }

    public JobDaemon createJobDaemon() {
        return new JobDaemon(this, this.jobDaemonUpdateInterval(), this.executor());
    }

    public long jobDaemonUpdateInterval() {
        return 1000L;
    }

    @Override
    public void beforeStateChanged(Enumeration.Value fromState, Enumeration.Value toState) {
        boolean bl;
        Enumeration.Value value = toState;
        Enumeration.Value value2 = SchedulerEventState$.MODULE$.Succeed();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SchedulerEventState$.MODULE$.Failed();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = SchedulerEventState$.MODULE$.Cancelled();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value8 = SchedulerEventState$.MODULE$.Timeout();
                    Enumeration.Value value9 = value;
                    bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
                }
            }
        }
        if (bl) {
            this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onJobCompleted(this);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void afterStateChanged(Enumeration.Value fromState, Enumeration.Value toState) {
        Enumeration.Value value = toState;
        Enumeration.Value value2 = SchedulerEventState$.MODULE$.Inited();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.onJobInited(this);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Enumeration.Value value4 = SchedulerEventState$.MODULE$.Scheduled();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.onJobScheduled(this);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Enumeration.Value value6 = SchedulerEventState$.MODULE$.Running();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.onJobRunning(this);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Enumeration.Value value8 = SchedulerEventState$.MODULE$.WaitForRetry();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.onJobWaitForRetry(this);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.jobDaemon().foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.kill());
        this.jobListener().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.onJobCompleted(this);
            return BoxedUnit.UNIT;
        });
    }

    public void transitionCompleted(CompletedExecuteResponse executeCompleted) {
        Enumeration.Value state = this.getState();
        CompletedExecuteResponse completedExecuteResponse = executeCompleted;
        if (completedExecuteResponse instanceof SuccessExecuteResponse) {
            if (!this.interrupt()) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.transition(SchedulerEventState$.MODULE$.Succeed()), new StringBuilder(36).append("update Job ").append(this.toString()).append(" from ").append(state).append(" to Succeed failed.").toString(), this.logger());
            } else {
                this.transitionCompleted(this.errorExecuteResponse());
            }
        } else if (completedExecuteResponse instanceof ErrorExecuteResponse) {
            ErrorExecuteResponse errorExecuteResponse = (ErrorExecuteResponse)completedExecuteResponse;
            boolean canRetry = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.isJobShouldRetry(errorExecuteResponse), (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Job.$anonfun$transitionCompleted$3(this, errorExecuteResponse, t))));
            if (canRetry) {
                this.progress_$eq(0.0f);
                Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.transition(SchedulerEventState$.MODULE$.WaitForRetry()), new StringBuilder(41).append("update Job ").append(this.toString()).append(" from ").append(state).append(" to WaitForRetry failed.").toString(), this.logger());
                return;
            }
            this.errorExecuteResponse_$eq(errorExecuteResponse);
            BoxedUnit cfr_ignored_1 = (BoxedUnit)Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.transition(this.interrupt() && this.errorExecuteResponse().t() == null ? SchedulerEventState$.MODULE$.Cancelled() : SchedulerEventState$.MODULE$.Failed()), new StringBuilder(35).append("update Job ").append(this.toString()).append(" from ").append(state).append(" to Failed failed.").toString(), this.logger());
        } else {
            throw new MatchError((Object)completedExecuteResponse);
        }
        this.endTime_$eq(System.currentTimeMillis());
        IOUtils.closeQuietly((Closeable)this);
    }

    public boolean isJobSupportRetry() {
        return true;
    }

    public int getRetryNum() {
        return this.retryNum();
    }

    public int getMaxRetryNum() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isJobShouldRetry(ErrorExecuteResponse errorExecuteResponse) {
        if (!this.isJobSupportRetry()) return false;
        if (errorExecuteResponse == null) return false;
        Throwable throwable = errorExecuteResponse.t();
        if (!(throwable instanceof LinkisRetryException)) return false;
        LinkisRetryException linkisRetryException = (LinkisRetryException)throwable;
        this.logger().warn(new StringBuilder(25).append("Job ").append(this.toString()).append(" is desired to retry.").toString(), (Throwable)linkisRetryException);
        if (linkisRetryException.getErrCode() != LinkisJobRetryException$.MODULE$.JOB_RETRY_ERROR_CODE()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isJobCanRetry() {
        if (!this.isJobSupportRetry()) return false;
        Enumeration.Value value = this.getState();
        Enumeration.Value value2 = SchedulerEventState$.MODULE$.WaitForRetry();
        if (value == null ? value2 != null : !value.equals(value2)) {
            return false;
        }
        Job job = this;
        synchronized (job) {
            Enumeration.Value value3 = this.getState();
            Enumeration.Value value4 = SchedulerEventState$.MODULE$.WaitForRetry();
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                if (this.getMaxRetryNum() < 1) return true;
                if (this.retryNum() < this.getMaxRetryNum()) {
                    return true;
                }
            }
            Enumeration.Value value5 = SchedulerEventState$.MODULE$.WaitForRetry();
            Enumeration.Value value6 = this.getState();
            if (value5 == null) {
                if (value6 != null) {
                    return false;
                }
            } else if (!value5.equals(value6)) return false;
            if (this.getMaxRetryNum() <= 0) return false;
            if (this.retryNum() < this.getMaxRetryNum()) return false;
            this.logListener().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                x$12.onLogUpdate(this, LogUtils$.MODULE$.generateInfo(new StringBuilder(41).append("Job cancelled since reached maxRetryNum ").append(this.getMaxRetryNum()).append(".").toString()));
                return BoxedUnit.UNIT;
            });
            this.transition(SchedulerEventState$.MODULE$.Failed());
            return false;
        }
    }

    public final boolean turnToRetry() {
        boolean bl;
        block6: {
            block5: {
                if (!this.isJobSupportRetry()) break block5;
                Enumeration.Value value = this.getState();
                Enumeration.Value value2 = SchedulerEventState$.MODULE$.WaitForRetry();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block6;
            }
            return false;
        }
        Job job = this;
        synchronized (job) {
            bl = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isJobCanRetry()) {
                    this.transition(SchedulerEventState$.MODULE$.Scheduled());
                    this.retryNum_$eq(this.retryNum() + 1);
                    return true;
                }
                return false;
            }, (Function1 & Serializable & scala.Serializable)t -> {
                this.retryNum_$eq(this.retryNum() + 1);
                return t;
            }));
        }
        return bl;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(new StringBuilder(11).append("Job_").append(this.toString()).append("_Thread").toString());
        if (!this.isScheduled() || this.interrupt()) {
            return;
        }
        this.startTime_$eq(System.currentTimeMillis());
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.transition(SchedulerEventState$.MODULE$.Running()), this.logger());
        if (this.interrupt()) {
            this.endTime_$eq(System.currentTimeMillis());
            this.transition(SchedulerEventState$.MODULE$.Cancelled());
            this.close();
            return;
        }
        ExecuteResponse rs = (ExecuteResponse)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.executor().execute(this.jobToExecuteRequest()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof InterruptedException) {
                InterruptedException interruptedException = (InterruptedException)throwable;
                this.logger().warn(new StringBuilder(28).append("job ").append(this.toString()).append(" is interrupted by user!").toString(), (Throwable)interruptedException);
                return new ErrorExecuteResponse("job is interrupted by user!", interruptedException);
            }
            this.logger().warn(new StringBuilder(20).append("execute job ").append(this.toString()).append(" failed!").toString(), throwable);
            return new ErrorExecuteResponse("execute job failed!", throwable);
        });
        ExecuteResponse executeResponse = rs;
        if (executeResponse instanceof CompletedExecuteResponse) {
            CompletedExecuteResponse completedExecuteResponse = (CompletedExecuteResponse)executeResponse;
            this.transitionCompleted(completedExecuteResponse);
            return;
        }
        if (executeResponse instanceof IncompleteExecuteResponse) {
            IncompleteExecuteResponse incompleteExecuteResponse = (IncompleteExecuteResponse)executeResponse;
            this.transitionCompleted(new ErrorExecuteResponse(StringUtils.isNotEmpty((CharSequence)incompleteExecuteResponse.message()) ? incompleteExecuteResponse.message() : "incomplete code.", null));
            return;
        }
        if (executeResponse instanceof AsynReturnExecuteResponse) {
            AsynReturnExecuteResponse asynReturnExecuteResponse = (AsynReturnExecuteResponse)executeResponse;
            asynReturnExecuteResponse.notify((Function1<ExecuteResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r1 -> {
                Job.$anonfun$run$4(this, r1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)executeResponse);
    }

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.getName())) {
            return this.getName();
        }
        return this.getId();
    }

    public void clear() {
        this.logger().info(new StringBuilder(21).append(" clear job base info ").append(this.getId()).toString());
        this.executor_$eq(null);
        this.jobDaemon_$eq(null);
    }

    public static final /* synthetic */ void $anonfun$onFailure$6(Job $this, Throwable t) {
        $this.logger().error(new StringBuilder(16).append("kill job ").append($this.getName()).append(" failed").toString(), t);
        ErrorException s = new ErrorException(23333, new StringBuilder(16).append("kill job ").append($this.getName()).append(" failed").toString());
        s.initCause(t);
        $this.forceCancel((Throwable)s);
    }

    public static final /* synthetic */ boolean $anonfun$transitionCompleted$3(Job $this, ErrorExecuteResponse x3$1, Throwable t) {
        block0: {
            $this.logger().error(new StringBuilder(41).append("Job ").append($this.toString()).append(" failed to get the retry information!").toString(), t);
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.logListener().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.onLogUpdate($this, LogUtils$.MODULE$.generateERROR(new StringBuilder(37).append("failed to get the retry information! ").append(ExceptionUtils.getStackTrace((Throwable)t)).toString()));
                return BoxedUnit.UNIT;
            }), $this.logger());
            if (x3$1.t() != null) break block0;
            $this.errorExecuteResponse_$eq(new ErrorExecuteResponse(x3$1.message(), t));
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$run$4(Job $this, ExecuteResponse r1) {
        CompletedExecuteResponse completedExecuteResponse;
        if ($this.interrupt()) {
            completedExecuteResponse = $this.errorExecuteResponse();
        } else {
            ExecuteResponse executeResponse = r1;
            if (executeResponse instanceof IncompleteExecuteResponse) {
                IncompleteExecuteResponse incompleteExecuteResponse = (IncompleteExecuteResponse)executeResponse;
                completedExecuteResponse = new ErrorExecuteResponse(StringUtils.isNotEmpty((CharSequence)incompleteExecuteResponse.message()) ? incompleteExecuteResponse.message() : "incomplete code.", null);
            } else if (executeResponse instanceof CompletedExecuteResponse) {
                CompletedExecuteResponse completedExecuteResponse2 = (CompletedExecuteResponse)executeResponse;
                completedExecuteResponse = completedExecuteResponse2;
            } else {
                throw new MatchError((Object)executeResponse);
            }
        }
        ErrorExecuteResponse realRS = completedExecuteResponse;
        $this.transitionCompleted(realRS);
    }

    public Job() {
        Logging.$init$((Logging)this);
        SchedulerEvent.$init$(this);
        this.jobDaemon = None$.MODULE$;
        this.jobListener = None$.MODULE$;
        this.logListener = None$.MODULE$;
        this.progressListener = None$.MODULE$;
        this.interrupt = false;
        this.progress = 0.0f;
        this.retryNum = 0;
    }
}

