/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.util.internal.instant.InstantFormatter;
import org.apache.logging.log4j.core.util.internal.instant.InstantNumberFormatter;
import org.apache.logging.log4j.core.util.internal.instant.InstantPatternFormatter;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class TimestampResolver
implements EventResolver {
    private final EventResolver internalResolver;
    private static final EventResolver EPOCH_NANOS_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_NANOS.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_MILLIS_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_MILLIS.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_MILLIS_ROUNDED_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_MILLIS_ROUNDED.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_MILLIS_NANOS_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_MILLIS_NANOS.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_SECS_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_SECONDS.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_SECS_ROUNDED_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_SECONDS_ROUNDED.formatTo(buffer, instant);
    };
    private static final EventResolver EPOCH_SECS_NANOS_RESOLVER = (logEvent, jsonWriter) -> {
        StringBuilder buffer = jsonWriter.getStringBuilder();
        Instant instant = logEvent.getInstant();
        InstantNumberFormatter.EPOCH_SECONDS_NANOS.formatTo(buffer, instant);
    };

    TimestampResolver(TemplateResolverConfig config) {
        this.internalResolver = TimestampResolver.createResolver(config);
    }

    private static EventResolver createResolver(TemplateResolverConfig config) {
        boolean patternProvided = config.exists("pattern");
        boolean epochProvided = config.exists("epoch");
        if (patternProvided && epochProvided) {
            throw new IllegalArgumentException("conflicting configuration options are provided: " + config);
        }
        return epochProvided ? TimestampResolver.createEpochResolver(config) : TimestampResolver.createPatternResolver(config);
    }

    private static EventResolver createPatternResolver(TemplateResolverConfig config) {
        String pattern = TimestampResolver.readPattern(config);
        TimeZone timeZone = TimestampResolver.readTimeZone(config);
        Locale locale = config.getLocale(new String[]{"pattern", "locale"});
        InstantPatternFormatter formatter = InstantPatternFormatter.newBuilder().setPattern(pattern).setTimeZone(timeZone).setLocale(locale).build();
        return new PatternResolver((InstantFormatter)formatter);
    }

    private static String readPattern(TemplateResolverConfig config) {
        String format = config.getString(new String[]{"pattern", "format"});
        return format != null ? format : JsonTemplateLayoutDefaults.getTimestampFormatPattern();
    }

    private static TimeZone readTimeZone(TemplateResolverConfig config) {
        String timeZoneId = config.getString(new String[]{"pattern", "timeZone"});
        if (timeZoneId == null) {
            return JsonTemplateLayoutDefaults.getTimeZone();
        }
        boolean found = false;
        for (String availableTimeZone : TimeZone.getAvailableIDs()) {
            if (!availableTimeZone.equalsIgnoreCase(timeZoneId)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("invalid timestamp time zone: " + config);
        }
        return TimeZone.getTimeZone(timeZoneId);
    }

    private static EventResolver createEpochResolver(TemplateResolverConfig config) {
        String unit = config.getString(new String[]{"epoch", "unit"});
        Boolean rounded = config.getBoolean(new String[]{"epoch", "rounded"});
        if ("nanos".equals(unit) && !Boolean.FALSE.equals(rounded)) {
            return EPOCH_NANOS_RESOLVER;
        }
        if ("millis".equals(unit)) {
            return !Boolean.TRUE.equals(rounded) ? EPOCH_MILLIS_RESOLVER : EPOCH_MILLIS_ROUNDED_RESOLVER;
        }
        if ("millis.nanos".equals(unit) && rounded == null) {
            return EPOCH_MILLIS_NANOS_RESOLVER;
        }
        if ("secs".equals(unit)) {
            return !Boolean.TRUE.equals(rounded) ? EPOCH_SECS_RESOLVER : EPOCH_SECS_ROUNDED_RESOLVER;
        }
        if ("secs.nanos".equals(unit) && rounded == null) {
            return EPOCH_SECS_NANOS_RESOLVER;
        }
        throw new IllegalArgumentException("invalid epoch configuration: " + config);
    }

    static String getName() {
        return "timestamp";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    private static final class PatternResolver
    implements EventResolver {
        private final InstantFormatter formatter;

        private PatternResolver(InstantFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
            jsonWriter.writeString((arg_0, arg_1) -> ((InstantFormatter)this.formatter).formatTo(arg_0, arg_1), logEvent.getInstant());
        }
    }
}

