/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.text;

import java.beans.PropertyDescriptor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.ModelDriven;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.text.AbstractLocalizedTextProvider;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.util.reflection.ReflectionProvider;

public class StrutsLocalizedTextProvider
extends AbstractLocalizedTextProvider {
    private static final Logger LOG = LogManager.getLogger(StrutsLocalizedTextProvider.class);
    private transient ReflectionProvider reflectionProvider;

    public StrutsLocalizedTextProvider() {
        this.addDefaultResourceBundle("org/apache/struts2/xwork-messages");
        this.addDefaultResourceBundle("org/apache/struts2/struts-messages");
    }

    @Override
    public String findText(Class<?> startClazz, String textKey, Locale locale) {
        return this.findText(startClazz, textKey, locale, textKey, new Object[0]);
    }

    @Override
    public String findText(Class<?> startClazz, String textKey, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return this.findText(startClazz, textKey, locale, defaultMessage, args, valueStack);
    }

    @Override
    public String findText(Class<?> startClazz, String textKey, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        Object model;
        Object action;
        ActionContext context;
        ActionInvocation actionInvocation;
        String msg;
        if (textKey == null) {
            LOG.debug("Key is null, short-circuit to default message");
            return defaultMessage;
        }
        String indexedTextName = this.extractIndexedName(textKey);
        boolean performedInitialDefaultBundlesMessageLookup = false;
        AbstractLocalizedTextProvider.GetDefaultMessageReturnArg result = null;
        if (this.searchDefaultBundlesFirst) {
            result = this.getDefaultMessageWithAlternateKey(textKey, indexedTextName, locale, valueStack, args, defaultMessage);
            performedInitialDefaultBundlesMessageLookup = true;
            if (!this.unableToFindTextForKey(result)) {
                return result.message;
            }
        }
        if ((msg = this.findMessage(startClazz, textKey, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        if (ModelDriven.class.isAssignableFrom(startClazz) && (actionInvocation = (context = ActionContext.getContext()).getActionInvocation()) != null && (action = actionInvocation.getAction()) instanceof ModelDriven && (model = ((ModelDriven)action).getModel()) != null && (msg = this.findMessage(model.getClass(), textKey, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        for (Class<?> clazz = startClazz; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            String basePackageName = clazz.getName();
            while (basePackageName.lastIndexOf(46) != -1) {
                String packageName = (basePackageName = basePackageName.substring(0, basePackageName.lastIndexOf(46))) + ".package";
                msg = this.getMessage(packageName, locale, textKey, valueStack, args);
                if (msg != null) {
                    return msg;
                }
                if (indexedTextName == null || (msg = this.getMessage(packageName, locale, indexedTextName, valueStack, args)) == null) continue;
                return msg;
            }
        }
        int idx = textKey.indexOf(46);
        if (idx != -1) {
            Object newKey = null;
            String prop = null;
            if (textKey.startsWith("invalid.fieldvalue.")) {
                idx = textKey.indexOf(46, "invalid.fieldvalue.".length());
                if (idx != -1) {
                    prop = textKey.substring("invalid.fieldvalue.".length(), idx);
                    newKey = "invalid.fieldvalue." + textKey.substring(idx + 1);
                }
            } else {
                prop = textKey.substring(0, idx);
                newKey = textKey.substring(idx + 1);
            }
            if (prop != null) {
                Object obj = valueStack.findValue(prop);
                try {
                    Class<?> clazz;
                    PropertyDescriptor propertyDescriptor;
                    Object actionObj = this.reflectionProvider.getRealTarget(prop, valueStack.getContext(), valueStack.getRoot());
                    if (actionObj != null && (propertyDescriptor = this.reflectionProvider.getPropertyDescriptor(actionObj.getClass(), prop)) != null && (clazz = propertyDescriptor.getPropertyType()) != null) {
                        if (obj != null) {
                            valueStack.push(obj);
                        }
                        msg = this.findText(clazz, (String)newKey, locale, null, args);
                        if (obj != null) {
                            valueStack.pop();
                        }
                        if (msg != null) {
                            return msg;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug("unable to find property {}", (Object)prop, (Object)e);
                }
            }
        }
        if (!performedInitialDefaultBundlesMessageLookup) {
            result = this.getDefaultMessageWithAlternateKey(textKey, indexedTextName, locale, valueStack, args, defaultMessage);
        }
        this.logMissingText(startClazz, textKey, locale, result, indexedTextName);
        return result != null ? result.message : null;
    }

    @Override
    public String findText(ResourceBundle bundle, String textKey, Locale locale) {
        return this.findText(bundle, textKey, locale, textKey, new Object[0]);
    }

    @Override
    public String findText(ResourceBundle bundle, String textKey, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return this.findText(bundle, textKey, locale, defaultMessage, args, valueStack);
    }

    @Inject
    public void setReflectionProvider(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }
}

