#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Age
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='broken-age'
GAME_NAME='Broken Age'

ARCHIVE_BASE_0_NAME='gog_broken_age_2.5.0.11.sh'
ARCHIVE_BASE_0_MD5='c875f1e09f1d1a26e19266d7a5a6045f'
ARCHIVE_BASE_0_SIZE='2240040'
ARCHIVE_BASE_0_VERSION='2.4.800398-gog2.5.0.11'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/broken_age'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN_FILES='
libfmodevent-4.42.16.so
libfmodeventnet-4.42.16.so
libfmodex-4.42.16.so'
CONTENT_GAME_BIN_FILES='
BrokenAge'
CONTENT_GAME_DATA_FILES='
*.pck'
CONTENT_DOC_DATA_FILES='
*.txt'

APP_MAIN_EXE='BrokenAge'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
