# Copyright 2019 OpenStack Foundation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""add-floatingip

Revision ID: e069c014356d
Revises: 9593f3656974
Create Date: 2019-01-10 10:15:47.874521

"""

# revision identifiers, used by Alembic.
revision = 'e069c014356d'
down_revision = '9593f3656974'

from alembic import op
import sqlalchemy as sa


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('floatingips',
                    sa.Column('created_at', sa.DateTime(), nullable=True),
                    sa.Column('updated_at', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.String(length=36), nullable=False),
                    sa.Column('floating_network_id', sa.String(length=255),
                              nullable=False),
                    sa.Column('subnet_id', sa.String(length=255),
                              nullable=False),
                    sa.Column('floating_ip_address', sa.String(length=255),
                              nullable=False),
                    sa.Column('reservable', sa.Boolean(),
                              server_default=sa.text('true'), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('subnet_id', 'floating_ip_address'))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('floatingips')
    # ### end Alembic commands ###
