<!--
%CopyrightBegin%

SPDX-License-Identifier: Apache-2.0

Copyright Ericsson AB 2023-2025. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# SASL Release Notes

This document describes the changes made to the SASL application.

## SASL 4.3

### Fixed Bugs and Malfunctions

- Fixed the documentation for the ExtraFiles option to `systools:make_tar/2`.

  Own Id: OTP-19279 Aux Id: [GH-8842], [PR-8894]

[GH-8842]: https://github.com/erlang/otp/issues/8842
[PR-8894]: https://github.com/erlang/otp/pull/8894

### Improvements and New Features

- [`.appup`](appup.md) files are now included in releases in order to make it possible to create upgrade packages from an installed release.

  Own Id: OTP-19398 Aux Id: [PR-8973]

- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.

  Own Id: OTP-19575 Aux Id: [PR-9670]

[PR-8973]: https://github.com/erlang/otp/pull/8973
[PR-9670]: https://github.com/erlang/otp/pull/9670

## SASL 4.2.2

### Improvements and New Features

- The documentation has been migrated to use Markdown and ExDoc.

  Own Id: OTP-18955 Aux Id: [PR-8026]

[PR-8026]: https://github.com/erlang/otp/pull/8026

## SASL 4.2.1

### Fixed Bugs and Malfunctions

- Improved error message from `systools:make_script`, when .app parameters
  contain duplicates. The parameters that will be checked are modules,
  applications and registered.

  Own Id: OTP-18300 Aux Id: PR-6389

## SASL 4.2

### Fixed Bugs and Malfunctions

- Fix systools:make\* to recursively search for source code when doing a
  `src_tests`.

  Own Id: OTP-17752 Aux Id: PR-5302

### Improvements and New Features

- An Erlang installation directory is now relocatable on the file system given
  that the paths in the installation's `RELEASES` file are paths that are
  relative to the installations root directory. The
  `` `release_handler:create_RELEASES/4 `` function can generate a `RELEASES`
  file with relative paths if its `RootDir` parameter is set to the empty
  string.

  Own Id: OTP-17304

## SASL 4.1.2

### Fixed Bugs and Malfunctions

- Fix bug in systools:make_script/1 documentation.

  Own Id: OTP-17854 Aux Id: PR-5596

## SASL 4.1.1

### Fixed Bugs and Malfunctions

- Make `release_handler` even more resilient against exiting processes during
  upgrade. Same kind of bug fix as OTP-16744 released in sasl-4.0.1 (OTP 23.1).

  Own Id: OTP-17748 Aux Id: GH-5387, PR-5389

## SASL 4.1

### Improvements and New Features

- The experimental HiPE application has been removed, together with all related
  functionality in other applications.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-16963

- Recognize new key 'optional_applications' in application resource files.

  Own Id: OTP-17189 Aux Id: PR-2675

- Removed timestamps from files generated by `sasl` and `reltool` to enable
  deterministic builds.

  Own Id: OTP-17292 Aux Id: PR-4685, PR-4684

## SASL 4.0.2

### Fixed Bugs and Malfunctions

- Fix dependent application to be stopped after the primary application when
  upgrading a release and the primary and dependent application is removed.

  Example: In a release where app1 depends on app2 and we should remove app1 and
  app2 using a release upgrade. When the release upgrade is done app1 should be
  stopped and purged before app2 as otherwise app1 could start crashing when its
  dependency is removed.

  This bugfix changes the order of removal to be correct.

  Own Id: OTP-17113 Aux Id: ERL-1410 PR-2882

## SASL 4.0.1

### Fixed Bugs and Malfunctions

- Make `release_handler` more resilient against exiting processes during
  upgrade.

  Own Id: OTP-16744 Aux Id: ERL-1247, PR-2666

## SASL 4.0

### Improvements and New Features

- Remove usage and documentation of old requests of the I/O-protocol.

  Own Id: OTP-15695

- `systools:make_script/2` now accepts the name of the boot file to create, it
  is not restricted to only `RelName.boot` or `start.boot`.

  `systools:make_tar/2` now accepts the option `extra_files` to add any extra
  non release related files to the tar file.

  Own Id: OTP-16561 Aux Id: PR-2420

- [`systools:make_tar/1,2`](`systools:make_tar/1`) now filters out any tools
  from erts if included in the release tar ball. See the documentation for more
  details.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-16603

## SASL 3.4.2

### Improvements and New Features

- A socket "registry" has been added making it possible to list current open
  sockets.

  Own Id: OTP-16309

## SASL 3.4.1

### Improvements and New Features

- The net module has been split into 'net' (kernel) and prim_net (preloaded).

  Own Id: OTP-15765

## SASL 3.4

### Improvements and New Features

- Change the first module called by erts to be named erl_init instead of
  otp_ring0. systools in sasl have been updated to reflect this change.

  Own Id: OTP-15336 Aux Id: PR-1825

## SASL 3.3

### Improvements and New Features

- New `counters` and `atomics` modules supplies access to highly efficient
  operations on mutable fixed word sized variables.

  Own Id: OTP-13468

## SASL 3.2.1

### Fixed Bugs and Malfunctions

- Improved documentation.

  Own Id: OTP-15190

## SASL 3.2

### Improvements and New Features

- A new logging API is added to Erlang/OTP, see the `m:logger` manual page, and
  section [Logging](`e:kernel:logger_chapter.md`) in the Kernel User's Guide.

  Calls to `error_logger` are automatically redirected to the new API, and
  legacy error logger event handlers can still be used. It is, however,
  recommended to use the Logger API directly when writing new code.

  Notice the following potential incompatibilities:

  - Kernel configuration parameters `error_logger` still works, but is overruled
    if the default handler's output destination is configured with Kernel
    configuration parameter `logger`.

    In general, parameters for configuring error logger are overwritten by new
    parameters for configuring Logger.

  - The concept of SASL error logging is deprecated, meaning that by default the
    SASL application does not affect which log events are logged.

    By default, supervisor reports and crash reports are logged by the default
    Logger handler started by Kernel, and end up at the same destination
    (terminal or file) as other standard log event from Erlang/OTP.

    Progress reports are not logged by default, but can be enabled by setting
    the primary log level to info, for example with the Kernel configuration
    parameter `logger_level`.

    To obtain backwards compatibility with the SASL error logging functionality
    from earlier releases, set Kernel configuration parameter
    `logger_sasl_compatible` to `true`. This prevents the default Logger handler
    from logging any supervisor-, crash-, or progress reports. Instead, SASL
    adds a separate Logger handler during application start, which takes care of
    these log events. The SASL configuration parameters `sasl_error_logger` and
    `sasl_errlog_type` specify the destination (terminal or file) and severity
    level to log for these events.

  Since Logger is new in Erlang/OTP 21.0, we do reserve the right to introduce
  changes to the Logger API and functionality in patches following this release.
  These changes might or might not be backwards compatible with the initial
  version.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-13295

- The old and outdated "Status Inspection" tool (modules `si` and `si_sasl_sup`)
  is removed.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-14469

- When creating the release tar file, systools now includes sys.config.src if it
  exists in the $ROOT/releases/<vsn>/ directory. This is to allow adjustments,
  e.g. resolving environment variables, after unpacking the release, but before
  installing it. This functionality requires a custom tool which uses
  sys.config.src as input and creates a correct sys.config file.

  Own Id: OTP-14950 Aux Id: PR-1560

## SASL 3.1.2

### Fixed Bugs and Malfunctions

- When upgrading with instruction 'restart_new_emulator', the generated
  temporary boot file used 'kernelProcess' statements from the old release
  instead of the new release. This is now corrected.

  This correction is needed for upgrade to OTP-21.

  Own Id: OTP-15017

## SASL 3.1.1

### Fixed Bugs and Malfunctions

- The Report Browser, rb, could earlier not handle reports that were not lists,
  for example generated by `error_logger:info_report({some, tuple})`. This term
  is allowed as input to error_logger, but rb would state that "A report on bad
  form was encountered". This is now corrected.

  Own Id: OTP-13906 Aux Id: ERL-261

## SASL 3.1

### Improvements and New Features

- General Unicode improvements.

  Own Id: OTP-14462

- Files generated by `release_handler` and `reltool`, which might contain
  Unicode characters, are now encoded as UTF-8 and written with format "~tp" or
  "~ts". If the file is to be read by `file:consult/1`, an encoding comment is
  added.

  Own Id: OTP-14463

- The SASL error logger event handler, `sasl_report_file_h`, will now by default
  open its log file with encoding UTF-8. This can be overridden when configuring
  SASL, see configuration parameter `sasl_error_logger` in the SASL reference
  manual.

  Own Id: OTP-14618

## SASL 3.0.4

### Fixed Bugs and Malfunctions

- Documented default values for the 'mod' and 'start_phases' fields in .app
  files were not allowed as actual values in a .app file. This is now corrected.

  Own Id: OTP-14029

### Improvements and New Features

- Miscellaneous updates due to atoms containing arbitrary Unicode characters.

  Own Id: OTP-14285

## SASL 3.0.3

### Fixed Bugs and Malfunctions

- When both options 'warnings_as_errors' and 'silent' were given to
  systools:make_script or systools:make_relup, no error reason would be returned
  if warnings occurred. Instead only the atom 'error' was returned. This is now
  corrected.

  Options 'warnings_as_errors' and 'no_warn_sasl' are now also allowed for
  systools:make_tar.

  Own Id: OTP-14170

## SASL 3.0.2

### Fixed Bugs and Malfunctions

- `code:add_pathsa/1` and command line option `-pa` both revert the given list
  of directories when adding it at the beginning of the code path. This is now
  documented.

  Own Id: OTP-13920 Aux Id: ERL-267

## SASL 3.0.1

### Improvements and New Features

- Improved dirty scheduler support. A purge of a module can now be performed
  without having to wait for completion of all ongoing dirty NIF calls.

  Note that when enabling support for dirty schedulers, a new purge strategy
  will as of ERTS version 8.1 be enabled. This new strategy is not fully
  backwards compatible with the strategy used by default. For more information
  see the documentation of `erlang:check_process_code/3`.

  Own Id: OTP-13808 Aux Id: OTP-13833

- A new purge strategy has been introduced. The new strategy will by default be
  disabled during the OTP 19 release, but will be the only strategy available as
  of the OTP 20 release.

  The new strategy is slightly incompatible with the strategy being used by
  default in OTP 19. Using the default strategy, processes holding `fun`s that
  refer to the module being purged either fail a soft purge, or will be killed
  during a hard purge. The new strategy completely ignores `fun`s. If `fun`s
  referring to the code being purged exist, and are used after a purge, an
  exception will be raised upon usage. That is, the behavior will be exactly the
  same as the case when a `fun` is received by a process after the purge.

  The new strategy can optionally be enabled when building OTP during OTP 19,
  and will automatically be enabled if the runtime system is built with support
  for dirty schedulers.

  For more information see the documentation of `erlang:check_process_code/3`.

  Own Id: OTP-13833

## SASL 3.0

### Improvements and New Features

- The module 'overload' is removed.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-13184

## SASL 2.7

### Fixed Bugs and Malfunctions

- During upgrade, the release_handler collects a list of supervisor pids in
  order to list all processes in the supervisor tree. If one of the supervisors
  (legitimately) exits before release_handler can examine it, then
  `sys:get_status/1` would earlier be called with a dead pid, causing a
  `'noproc'` error. This has been corrected.

  Own Id: OTP-13291

### Improvements and New Features

- The module `overload` is deprecated and will be removed in OTP 19.

  Own Id: OTP-13057

- Improve implementation of supervisor child count, making it faster and more
  accurate for dynamic processes of a `simple_one_for_one` supervisor.

  Own Id: OTP-13290

## SASL 2.6.1

### Improvements and New Features

- Documentation improvements

  Own Id: OTP-13000

## SASL 2.6

### Improvements and New Features

- A mechanism for limiting the amount of text that the built-in error logger
  events will produce has been introduced. It is useful for limiting both the
  size of log files and the CPU time used to produce them.

  This mechanism is experimental in the sense that it may be changed if it turns
  out that it does not solve the problem it is supposed to solve. In that case,
  there may be backward incompatible improvements to this mechanism.

  See the documentation for the config parameter `error_logger_format_depth` in
  the Kernel application for information about how to turn on this feature.

  Own Id: OTP-12864

## SASL 2.5

### Fixed Bugs and Malfunctions

- The undocumented upgrade instruction
  `{remove_module,PrePurge,PostPurge,DepMods}` is removed. This instruction was
  added for symmetry reasons in OTP R7B, but was never documented or tested.

  The existing instruction `{add_module,Mod,DepMods}` is now documented, and the
  complementing instruction `{delete_module,Mod,DepMods}` is added.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-11540

### Improvements and New Features

- The `sasl_error_logger` configuration parameter now supports the value
  `{file,FileName,Modes}` which allows the log file to be opened in other mode
  than write (for example, append mode).

  Own Id: OTP-12778

## SASL 2.4.1

### Fixed Bugs and Malfunctions

- The documentation erroneously specified that `alarm_handler:clear_alarm/1`
  would clear _all_ alarms with id `AlarmId`. This is now corrected according to
  the implementation - only the latest received alarm with the given `AlarmId`
  is cleared by the simple default handler.

  Own Id: OTP-12025

## SASL 2.4

### Fixed Bugs and Malfunctions

- The upgrade instruction 'restart_application' would earlier ignore the restart
  type configured in the .rel file and always restart the application as
  permanent. This is now changed, and the restart type from the .rel file is
  used. If restart type is 'load', the application will only be loaded and not
  started. If the restart type is 'none', the application will not be loaded nor
  started, but all modules in the application will be loaded. (Thanks to Tobias
  Schlager for reporting this problem)

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-11716

- If `systools:make_script/2` failed with reason `duplicate_modules`, and the
  `silent` flag was not used, a crash with reason `function_clause` would occur
  when `systools` tried to format the error message. This has been corrected.
  (Thanks to Jean-Sébastien Pédron)

  Own Id: OTP-11819

### Improvements and New Features

- Calls to erlang:open_port/2 with 'spawn' are updated to handle space in the
  command path.

  Own Id: OTP-10842

- Some more documentation is added to explain the behavior when an upgrade
  includes new versions of ERTS, Kernel, STDLIB or SASL.

  Own Id: OTP-11717

## SASL 2.3.4

### Fixed Bugs and Malfunctions

- Don't try to add the log_mf_h handler in sasl unless configured to do so.
  Thanks to Richard Carlsson.

  Own Id: OTP-11464

- Fix confusing documentation about error handlers in SASL.(Thanks to Richard
  Carlsson)

  Own Id: OTP-11507

- A bug in the mechanism for upgrading core parts of Erlang/OTP (emulator,
  kernel, stdlib, sasl) caused a switch of paths between stdlib and sasl in the
  intermediate .script/.boot file. The bug was introduces along with this
  upgrade mechanism in R15B. It has now been corrected. (Thanks to Tobias
  Schlager)

  Own Id: OTP-11529

### Improvements and New Features

- Added a boot file which skips loading the "$HOME/.erlang" file on startup.
  Enable by starting erlang with "erl -boot no_dot_erlang".

  \*** INCOMPATIBILITY with false \***

  Own Id: OTP-8479 Aux Id: seq11510

## SASL 2.3.3

### Improvements and New Features

- Add Fd usage in rb logging. Thanks to Eric Pailleau.

  Own Id: OTP-11252

## SASL 2.3.2

### Fixed Bugs and Malfunctions

- Fix receive support in erl_eval with a BEAM module. Thanks to Anthony Ramine.

  Own Id: OTP-11137

## SASL 2.3.1

### Improvements and New Features

- Some updates are made to systools and release_handler for handling of unicode.

  Own Id: OTP-10782

## SASL 2.3

### Fixed Bugs and Malfunctions

- release_handler_SUITE:otp_9864 deleted parts of the release_handler_SUITE_data
  directory so the test suite could not be executed twice without
  re-installation. This has been corrected.

  Own Id: OTP-10394 Aux Id: kunagi-187 \[98]

- It is no longer possible to have `{Mod,Vsn}` in the 'modules' list in a .app
  file.

  This was earlier possible, although never documented in the .app file
  reference manual. It was however visible in the documentation of
  `application:load/[1,2]`, where the same term as in a .app file can be used as
  the first argument.

  The possibility has been removed since the `Vsn` part was never used.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-10417

- release_handler:upgrade_script and release_handler:downgrade_script could not
  read appup files with regexps. This has been corrected. (Thanks to Ulf Wiger)

  Own Id: OTP-10463

### Improvements and New Features

- Where necessary a comment stating encoding has been added to Erlang files. The
  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the
  default encoding.

  Own Id: OTP-10630

## SASL 2.2.1

### Fixed Bugs and Malfunctions

- If sys.config existed, but was not readable or parseable, this would not be
  detected until after the upgrade and at the next node restart. The possibility
  for this to happen is now reduced by adding a check to systools:make_tar which
  fails the creation of the tar file if sys.config or relup does not have
  reasonable contents. Note that there are no detailed checks, only parsing and
  erlang term format check.

  Own Id: OTP-9539

- systools:make_script would allow \{kernel,Vsn,load\} in the .rel file, causing
  a .boot file which only loaded kernel and did not start it. This has been
  corrected. Only start type 'permanent', which is the default, is now allowed
  for kernel and stdlib.

  Own Id: OTP-9652

- release_handler:remove_release/1 now handles symlinked files properly

  Own Id: OTP-9864

- If stdlib was stated with a start type different from `permanent` in a .rel
  file, systools would incorrectly say that sasl had faulty start type. This has
  been corrected.

  Own Id: OTP-9888

- Sasl documentation earlier said that the InclApps parameters in a .rel file
  defaults to the empty list. This is not correct. It defaults to the same value
  as specified in the .app file. This has been corrected.

  Own Id: OTP-9980

- Applications that are listed in `{applications,Apps}` in the .app file were
  not sorted correctly by `systools:make_script/1,2`. They got the reverse order
  of how they were listed in the .app file. This is corrected so they are now
  sorted (internally between each other) in the same order as they are listed in
  the .rel file (i.e. the order they are listed in the .app file does no longer
  matter).

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-9984

- Documentation of .appup files now also states that `UpFromVsn` and `DownToVsn`
  can be specified as regular expressions in order to avoid duplicated upgrade
  instructions.

  Own Id: OTP-10001

- Reltool would sometimes generate a .app file containing
  `{start_phases,undefined}`, which would cause an exception in systools at
  parse time. This has been corrected so reltool now omits the `start_phases`
  entry if the value is `undefined`. (Thanks to Juan Jose Comellas)

  In order to align with reltool, sasl will also omit `start_phases` entries
  with value `undefined` in .script files.

  Own Id: OTP-10003

## SASL 2.2

### Fixed Bugs and Malfunctions

- Fix the mechanism for upgrading emulator.

  The appup files for kernel, stdlib and sasl do now recognize two major
  releases back and include a 'restart_new_emulator' instruction.

  Appup files can include regular expressions for matching earlier releases.

  The mechanism for upgrading the emulator is changed so 'restart_new_emulator'
  will be the first instruction executed. The rest of the upgrade instruction
  will be executed after the emulator restart.

  A new upgrade instruction 'restart_emulator' is added for the case where the
  emulator shall be restarted after all other upgrade instructions.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-9438

- Add release_handler:which_releases/1

  This is an extension to which_releases that allows a user to specify the
  status of the releases they wish to be returned. For instance it allows for
  quickly determining which release is 'permanent' without the need of parsing
  the entire release list. (Thanks to Joe Williams)

  Own Id: OTP-9717

- Add copy of rel file in releases/Vsn in release tar file

  systool:make_tar stores the rel file in the releases directory. When unpacking
  with release_handler:unpack_release, the file is automatically moved to
  releases/Vsn/. If, however, the tar file is unpacked manually, the rel file
  might not be moved, and the next release unpacked might overwrite the rel
  file. To overcome this, systools:make_tar now stores a copy of the rel file in
  releases/Vsn/ directly and it is not longer necessary to move the file after
  unpacking.

  The reason for keeping the file in the releases directory also is that is
  needs to be extracted separately before the release version (Vsn) is known.

  Own Id: OTP-9746

## SASL 2.1.10

### Fixed Bugs and Malfunctions

- The release_handler functionality on windows services was broken. This has
  been corrected.

  Own Id: OTP-9306

- If a new version of an application did not include any erlang module changes,
  the code path of the application was not updated by the release_handler unless
  a 'load_object_code' instruction was added for the application. This would be
  a problem if e.g. only some files in the priv dir were changed since calls to
  code:lib_dir or code:priv_dir would then point to the old location of the
  application. This has been corrected - now code:replace_path/2 will be called
  for all applications that are changed (i.e. when the application's vsn is
  changed in the .rel file).

  Own Id: OTP-9402

- The appup instruction 'delete_module' would cause a crash during upgrade if
  the module to be deleted was not loaded. This has been corrected.

  Own Id: OTP-9417

- If a path was given as ONLY 'ebin' and not for example './ebin', then
  systools:make_tar would fail with a `function_clause` exception in
  filename:join/1. This has been corrected. (Thanks to Nikola Skoric for
  reporting).

  Own Id: OTP-9507

- Implement or fix -Werror option

  If -Werror is enabled and there are warnings no output file is written. Also
  make sure that error/warning reporting is consistent. (Thanks to Tuncer Ayaz)

  Own Id: OTP-9536

- Improved error information for timeouts during
  release_handler:install_release.

  This patch addresses two cases where a timeout will occur during upgrade. 1)
  if a supervisor is suspended (call to get children from supervisor will
  hang) 2) if the child spec for a supervisor incorrectly states that it is a
  worker with a dynamic set of modules (call to get modules from gen_event will
  hang)

  An error report will now be printed, and the return value of
  release_handler:install_release will indicate what happened. (Thanks to joe
  williams)

  Own Id: OTP-9546

### Improvements and New Features

- `release_handler:install_release` could be very slow when there are many
  processes in the system. Some optimization work has been done both in erts and
  in the release handler in order to improve this.

  A new option, `purge`, is added to `release_handler:check_install_release`
  which can be called first in order to speed up the execution of
  `release_handler:install_release`.

  Own Id: OTP-9395

## SASL 2.1.9.4

### Fixed Bugs and Malfunctions

- Remove traces of release_handler reading from filesystem when it has Masters
  list

  There are a couple of places in release_handler and release_handler_1 that
  assumed it has a disk to read from, which in the case of an erl_prim_loader
  Loader other than efile is not necessarily true

  Add check_paths/2 to do the equivalent of check_path/1 for when there is a
  Masters list

  Change get_vsn to no longer get sent File paths but instead use the Bin since
  beam_lib:version being sent a file path causes it to read the local file
  system

  Add get_current_vsn/1 as an equivalent to beam_lib:version(code:which(Mod)),
  but using erl_prim_loader:get_file instead of reading from local file system

  (Thanks to Steven Gravell)

  Own Id: OTP-9142

- rb:stop did sometimes return \{error,running\}. This came from
  supervisor:delete_child and happened when the rb_server has not yet terminated
  when this function was called. Instead of having a separate gen_server call to
  rb_server for stopping the process, supervisor:terminate_child is now called.
  This is a synchronous function - i.e. it waits for the process to actually
  terminate before it returns.

  A file descriptor leak in rb:scan_files is corrected. The index file was never
  closed after reading.

  A mismatch in the behavior of rb:filter, when filter included 'no', is
  corrected. Such filters will now return _all_ non-matching reports, not only
  the 'proplist' reports.

  Own Id: OTP-9149

- Start and end date for rb:filter/2 was specified as \{\{Y-M-D\},...\} in the
  help text instead of \{\{Y,M,D\},...\}. This has been corrected.

  Own Id: OTP-9166

- If some, but not all, of the sasl environment variables related to the
  log_mf_h error handler were missing sasl would successfully start but silently
  skip starting log_mf_h. This is corrected so sasl startup will now fail if one
  or two of the three variables are given. If none of the variables are given,
  sasl will start as before without starting log_mf_h.

  Own Id: OTP-9185

### Improvements and New Features

- Change default behaviour to not check src code when creating release

  Add new option `src_tests` to systools:make_script and systools:make_tar. The
  old option `no_module_tests` is now ignored as this is the default behaviour.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-9146 Aux Id: seq11803

## SASL 2.1.9.3

### Improvements and New Features

- Honor start type in .rel files when building relup files

  Previously, relup file always included an application:start(Application,
  permanent) apply instruction for every application that appear in the
  UpTo/DowFrom release file, whatever their start type in the release file.

  The new implementation fixes this bug by honoring the start type according to
  the rel(5) format. If the start type is none, no apply line is included in the
  relup. If the start type is load, the relup includes instruction to only load
  the application. Otherwise, the relup includes an instruction to start the
  application to the according type.

  The fix is implemented by adding a new parameter to the add_application high
  level appup instruction. This new parameter is documented in appup(5).

  Own Id: OTP-9097

## SASL 2.1.9.2

### Fixed Bugs and Malfunctions

- In R13B04 sys:get_status was modified to invoke format_status/2 in the
  callback module if the module exports that function. This resulted in a change
  to the term returned from calling sys:get_status on the supervisor module,
  since supervisor is a gen_server and gen_server exports format_status. The
  sasl release_handler_1 module had a dependency on the pre-R13B04 term returned
  by sys:get_status when invoked on a supervisor, so the R13B04 change broke
  that dependency.

  This problem has been fixed by change release_handler_1 to handle both the
  pre-R13B04 and R13B04 terms that sys:get_status can return from a supervisor.

  Own Id: OTP-8619 Aux Id: seq11570

## SASL 2.1.9.1

### Improvements and New Features

- Use an infinity timeout in all calls to `gen_server:call()` in the SASL
  application.

  Own Id: OTP-8506 Aux Id: seq11509

## SASL 2.1.9

### Improvements and New Features

- The `re:grep/1` function now uses the '`re`' module instead of the deprecated
  '`regexp`' module. There are new functions `rb:filter/1` and `rb:filter/2` for
  easier filtering of reports. (Thanks to Alvaro Videla.)

  Own Id: OTP-8443

- There is new function `sasl_report:format_report/3` that works like the
  existing `sasl_report:write_report/3` function except that it returns a
  formatted string. Note that there is currently no documentation for the
  `sasl_report` module. (Thanks to Jay Nelson.)

  Own Id: OTP-8445

- Cleanups suggested by tidier and modernization of types and specs.

  Own Id: OTP-8455

## SASL 2.1.8

### Improvements and New Features

- The documentation is now built with open source tools (xsltproc and fop) that
  exists on most platforms. One visible change is that the frames are removed.

  Own Id: OTP-8201

## SASL 2.1.7

### Improvements and New Features

- The Windows utility Erlsrv, run in interactive mode now accepts options for
  registering internal service name and description field of Windows registry
  database.

  Own Id: OTP-8132

## SASL 2.1.6

### Fixed Bugs and Malfunctions

- When using the SASL application configuration parameter `masters` the error
  tuple `{error,{no_such_file,{Master,FileName}}}` was sometimes returned even
  though the file `FileName` existed.

  Own Id: OTP-7667

### Improvements and New Features

- Missing preloaded modules added

  Own Id: OTP-7820

## SASL 2.1.5.4

### Improvements and New Features

- A Dialyzer warning was eliminated

  Own Id: OTP-7635

## SASL 2.1.5.3

### Improvements and New Features

- Minor changes.

  Own Id: OTP-7388

## SASL 2.1.5.2

### Improvements and New Features

- Minor updates.

  Own Id: OTP-6998

## SASL 2.1.5.1

### Improvements and New Features

- Minor Makefile changes.

  Own Id: OTP-6689

- Obsolete guard tests (such as list()) have been replaced with the modern guard
  tests (such as is_list()).

  Own Id: OTP-6725

## SASL 2.1.5

### Fixed Bugs and Malfunctions

- Removed some dead code from `erlsrv:get_service/2`,
  `release_handler:do_write_file/2`, `systools_relup:foreach_baserel_up/7` and
  `systools_relup:foreach_baserel_dn/7`.

  Own Id: OTP-6499

## SASL 2.1.4

### Improvements and New Features

- Added an option `{outdir,Dir}` to the functions in `systools`, making it
  possible to specify in which directory a boot script, relup file or release
  package file should be placed.

  Also, when using `systools:make_tar/2` to create a release package file, the
  boot script, relup file and `sys.config` are now searched for also in the
  current working directory and any directory specified by the `path` option,
  not only in the directory of the `.rel` file.

  As part of the work some minor bugs have been corrected:

  - `systools:make_script/1,2` now returns `error` if the `.script` and/or
    `.boot` file could not be opened for writing, not `ok`.
  - `systools:make_tar/1,2` can now handle a `RelName` argument which includes a
    path. Previously this would cause the `.rel` file to end up in the wrong
    directory in the resulting tar file.
  - A documentation error for `systools:make_tar/1,2`: The `.rel` file is placed
    in the `releases` directory in the tar file, not `releases/RelVsn`.

  Own Id: OTP-6226

## SASL 2.1.3

### Fixed Bugs and Malfunctions

- `release_handler:upgrade_app/2` and `release_handler:downgrade_app/2,3` \--
  used for testing application upgrade and downgrade according to the `.appup`
  file -- now update application configuration parameters correctly. (Thanks to
  Serge Aleynikov)

  Own Id: OTP-6162

## SASL 2.1.2

### Fixed Bugs and Malfunctions

- Fixed some minor bugs in `release_handler` found by Dialyzer.

  Own Id: OTP-6039

## SASL 2.1.1

### Improvements and New Features

- Added a number of functions to `release_handler` which makes it possible to
  test upgrade and downgrade of applications according to an `.appup` file "on
  the fly":  
  \- `upgrade_app/2`  
  \- `upgrade_script/2`  
  \- `downgrade_app/2,3`  
  \- `downgrade_script/3`  
  \- `eval_appup_script/4`

  Own Id: OTP-5858

## SASL 2.1

### Improvements and New Features

- A new option `{update_paths,Bool}` has been added for
  `release_handler:install_release/2`. It indicates if all application code
  paths should be updated (`Bool==true`), or if only code paths for modified
  applications should be updated (`Bool==false`, default).

  `release_handler:set_unpacked/2` now returns an error tuple if a specified
  application directory does not exist.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-5761

## SASL 2.0.1

### Improvements and New Features

- A bug that made it impossible to call `rb:show(N)` (`N` being an integer)
  twice without getting an error has been fixed.

  Own Id: OTP-5287
