// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"
)

func New(name string) Interface {
	common := NewCommon(name)
	switch name {
	case "<root>":
		return &common
	case ResourceAttachment:
		return &Attachment{}
	case ResourceAttachments:
		return &common
	case ResourceComment:
		return &Comment{}
	case ResourceComments:
		return &common
	case ResourceIssue:
		return &Issue{}
	case ResourceIssues:
		return &common
	case ResourceLabel:
		return &Label{}
	case ResourceLabels:
		return &common
	case ResourceMilestone:
		return &Milestone{}
	case ResourceMilestones:
		return &common
	case ResourceOrganization:
		return &Organization{}
	case ResourceOrganizations:
		return &common
	case ResourceProject:
		return &Project{}
	case ResourceProjects:
		return &common
	case ResourcePullRequest:
		return &PullRequest{}
	case ResourcePullRequests:
		return &common
	case ResourceReaction:
		return &Reaction{}
	case ResourceReactions:
		return &common
	case ResourceRelease:
		return &Release{}
	case ResourceReleases:
		return &common
	case ResourceRepository:
		return &Repository{}
	case ResourceRepositories:
		return &common
	case ResourceReview:
		return &Review{}
	case ResourceReviews:
		return &common
	case ResourceReviewComment:
		return &ReviewComment{}
	case ResourceReviewComments:
		return &common
	case ResourceTopic:
		return &Topic{}
	case ResourceTopics:
		return &common
	case ResourceUser:
		return &User{}
	case ResourceUsers:
		return &common
	case ResourceForge:
		return &Forge{}
	default:
		panic(fmt.Errorf("unknown %s", name))
	}
}
