// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package generic

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/options"
	"code.forgejo.org/f3/gof3/v3/path"
)

type TreeInterface interface {
	logger.Interface

	Init(TreeInterface, options.Interface) TreeInterface

	GetOptions() options.Interface
	SetOptions(options.Interface)

	GetSelf() TreeInterface
	SetSelf(TreeInterface)

	SetRoot(NodeInterface)
	GetRoot() NodeInterface

	SetLogger(logger.Interface)
	GetLogger() logger.Interface

	GetDriver() TreeDriverInterface
	SetDriver(TreeDriverInterface)

	GetChildrenKind(kind.Kind) kind.Kind

	GetPageSize() int

	AllocateID() bool

	Clear(context.Context)

	Diff(a, b NodeInterface) string

	MustFind(path.Path) NodeInterface
	Find(path.Path) NodeInterface
	FindAndGet(context.Context, path.Path) NodeInterface
	Exists(context.Context, path.Path) bool

	Walk(context.Context, *WalkOptions)
	WalkAndGet(context.Context, *WalkOptions)
	Apply(context.Context, path.Path, *ApplyOptions) bool
	ApplyAndGet(context.Context, path.Path, *ApplyOptions) bool

	Register(kind kind.Kind, factory FactoryFun)
	Factory(ctx context.Context, kind kind.Kind) NodeInterface
}
