#ifndef LFORTRAN_WASM_INSTS_VISITOR_H
#define LFORTRAN_WASM_INSTS_VISITOR_H

// Generated by grammar/wasm_instructions_visitor.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/codegen/wasm_utils.h>


namespace LCompilers {

namespace WASM_INSTS_VISITOR {

template <class StructType>
class BaseWASMVisitor {
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    Vec<uint8_t> &code;
    uint32_t offset;

    BaseWASMVisitor(Vec<uint8_t> &code, uint32_t offset): code(code), offset(offset) {}
    void visit_EmtpyBlockType() {throw LCompilersException("visit_EmtpyBlockType() not implemented");}

    void visit_Unreachable() {throw LCompilersException("visit_Unreachable() not implemented");}

    void visit_Nop() {throw LCompilersException("visit_Nop() not implemented");}

    void visit_Loop() {throw LCompilersException("visit_Loop() not implemented");}

    void visit_If() {throw LCompilersException("visit_If() not implemented");}

    void visit_Else() {throw LCompilersException("visit_Else() not implemented");}

    void visit_Br(uint32_t /*labelidx*/) {throw LCompilersException("visit_Br() not implemented");}

    void visit_BrIf(uint32_t /*labelidx*/) {throw LCompilersException("visit_BrIf() not implemented");}

    void visit_Return() {throw LCompilersException("visit_Return() not implemented");}

    void visit_Call(uint32_t /*funcidx*/) {throw LCompilersException("visit_Call() not implemented");}

    void visit_CallIndirect(uint32_t /*typeidx*/, uint32_t /*tableidx*/) {throw LCompilersException("visit_CallIndirect() not implemented");}

    void visit_RefNull(uint8_t /*reftype*/) {throw LCompilersException("visit_RefNull() not implemented");}

    void visit_RefIsNull() {throw LCompilersException("visit_RefIsNull() not implemented");}

    void visit_RefFunc(uint32_t /*funcidx*/) {throw LCompilersException("visit_RefFunc() not implemented");}

    void visit_Drop() {throw LCompilersException("visit_Drop() not implemented");}

    void visit_Select() {throw LCompilersException("visit_Select() not implemented");}

    void visit_LocalGet(uint32_t /*localidx*/) {throw LCompilersException("visit_LocalGet() not implemented");}

    void visit_LocalSet(uint32_t /*localidx*/) {throw LCompilersException("visit_LocalSet() not implemented");}

    void visit_LocalTee(uint32_t /*localidx*/) {throw LCompilersException("visit_LocalTee() not implemented");}

    void visit_GlobalGet(uint32_t /*globalidx*/) {throw LCompilersException("visit_GlobalGet() not implemented");}

    void visit_GlobalSet(uint32_t /*globalidx*/) {throw LCompilersException("visit_GlobalSet() not implemented");}

    void visit_TableGet(uint32_t /*tableidx*/) {throw LCompilersException("visit_TableGet() not implemented");}

    void visit_TableSet(uint32_t /*tableidx*/) {throw LCompilersException("visit_TableSet() not implemented");}

    void visit_TableInit(uint32_t /*elemidx*/, uint32_t /*tableidx*/) {throw LCompilersException("visit_TableInit() not implemented");}

    void visit_ElemDrop(uint32_t /*elemidx*/) {throw LCompilersException("visit_ElemDrop() not implemented");}

    void visit_TableCopy(uint32_t /*des_tableidx*/, uint32_t /*src_tableidx*/) {throw LCompilersException("visit_TableCopy() not implemented");}

    void visit_TableGrow(uint32_t /*tableidx*/) {throw LCompilersException("visit_TableGrow() not implemented");}

    void visit_TableSize(uint32_t /*tableidx*/) {throw LCompilersException("visit_TableSize() not implemented");}

    void visit_TableFill(uint32_t /*tableidx*/) {throw LCompilersException("visit_TableFill() not implemented");}

    void visit_I32Load(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Load() not implemented");}

    void visit_I64Load(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load() not implemented");}

    void visit_F32Load(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_F32Load() not implemented");}

    void visit_F64Load(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_F64Load() not implemented");}

    void visit_I32Load8S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Load8S() not implemented");}

    void visit_I32Load8U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Load8U() not implemented");}

    void visit_I32Load16S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Load16S() not implemented");}

    void visit_I32Load16U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Load16U() not implemented");}

    void visit_I64Load8S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load8S() not implemented");}

    void visit_I64Load8U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load8U() not implemented");}

    void visit_I64Load16S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load16S() not implemented");}

    void visit_I64Load16U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load16U() not implemented");}

    void visit_I64Load32S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load32S() not implemented");}

    void visit_I64Load32U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Load32U() not implemented");}

    void visit_I32Store(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Store() not implemented");}

    void visit_I64Store(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Store() not implemented");}

    void visit_F32Store(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_F32Store() not implemented");}

    void visit_F64Store(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_F64Store() not implemented");}

    void visit_I32Store8(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Store8() not implemented");}

    void visit_I32Store16(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I32Store16() not implemented");}

    void visit_I64Store8(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Store8() not implemented");}

    void visit_I64Store16(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Store16() not implemented");}

    void visit_I64Store32(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_I64Store32() not implemented");}

    void visit_DataDrop(uint32_t /*dataidx*/) {throw LCompilersException("visit_DataDrop() not implemented");}

    void visit_I32Const(int32_t /*n*/) {throw LCompilersException("visit_I32Const() not implemented");}

    void visit_I64Const(int64_t /*n*/) {throw LCompilersException("visit_I64Const() not implemented");}

    void visit_F32Const(float /*z*/) {throw LCompilersException("visit_F32Const() not implemented");}

    void visit_F64Const(double /*z*/) {throw LCompilersException("visit_F64Const() not implemented");}

    void visit_I32Eqz() {throw LCompilersException("visit_I32Eqz() not implemented");}

    void visit_I32Eq() {throw LCompilersException("visit_I32Eq() not implemented");}

    void visit_I32Ne() {throw LCompilersException("visit_I32Ne() not implemented");}

    void visit_I32LtS() {throw LCompilersException("visit_I32LtS() not implemented");}

    void visit_I32LtU() {throw LCompilersException("visit_I32LtU() not implemented");}

    void visit_I32GtS() {throw LCompilersException("visit_I32GtS() not implemented");}

    void visit_I32GtU() {throw LCompilersException("visit_I32GtU() not implemented");}

    void visit_I32LeS() {throw LCompilersException("visit_I32LeS() not implemented");}

    void visit_I32LeU() {throw LCompilersException("visit_I32LeU() not implemented");}

    void visit_I32GeS() {throw LCompilersException("visit_I32GeS() not implemented");}

    void visit_I32GeU() {throw LCompilersException("visit_I32GeU() not implemented");}

    void visit_I64Eqz() {throw LCompilersException("visit_I64Eqz() not implemented");}

    void visit_I64Eq() {throw LCompilersException("visit_I64Eq() not implemented");}

    void visit_I64Ne() {throw LCompilersException("visit_I64Ne() not implemented");}

    void visit_I64LtS() {throw LCompilersException("visit_I64LtS() not implemented");}

    void visit_I64LtU() {throw LCompilersException("visit_I64LtU() not implemented");}

    void visit_I64GtS() {throw LCompilersException("visit_I64GtS() not implemented");}

    void visit_I64GtU() {throw LCompilersException("visit_I64GtU() not implemented");}

    void visit_I64LeS() {throw LCompilersException("visit_I64LeS() not implemented");}

    void visit_I64LeU() {throw LCompilersException("visit_I64LeU() not implemented");}

    void visit_I64GeS() {throw LCompilersException("visit_I64GeS() not implemented");}

    void visit_I64GeU() {throw LCompilersException("visit_I64GeU() not implemented");}

    void visit_F32Eq() {throw LCompilersException("visit_F32Eq() not implemented");}

    void visit_F32Ne() {throw LCompilersException("visit_F32Ne() not implemented");}

    void visit_F32Lt() {throw LCompilersException("visit_F32Lt() not implemented");}

    void visit_F32Gt() {throw LCompilersException("visit_F32Gt() not implemented");}

    void visit_F32Le() {throw LCompilersException("visit_F32Le() not implemented");}

    void visit_F32Ge() {throw LCompilersException("visit_F32Ge() not implemented");}

    void visit_F64Eq() {throw LCompilersException("visit_F64Eq() not implemented");}

    void visit_F64Ne() {throw LCompilersException("visit_F64Ne() not implemented");}

    void visit_F64Lt() {throw LCompilersException("visit_F64Lt() not implemented");}

    void visit_F64Gt() {throw LCompilersException("visit_F64Gt() not implemented");}

    void visit_F64Le() {throw LCompilersException("visit_F64Le() not implemented");}

    void visit_F64Ge() {throw LCompilersException("visit_F64Ge() not implemented");}

    void visit_I32Clz() {throw LCompilersException("visit_I32Clz() not implemented");}

    void visit_I32Ctz() {throw LCompilersException("visit_I32Ctz() not implemented");}

    void visit_I32Popcnt() {throw LCompilersException("visit_I32Popcnt() not implemented");}

    void visit_I32Add() {throw LCompilersException("visit_I32Add() not implemented");}

    void visit_I32Sub() {throw LCompilersException("visit_I32Sub() not implemented");}

    void visit_I32Mul() {throw LCompilersException("visit_I32Mul() not implemented");}

    void visit_I32DivS() {throw LCompilersException("visit_I32DivS() not implemented");}

    void visit_I32DivU() {throw LCompilersException("visit_I32DivU() not implemented");}

    void visit_I32RemS() {throw LCompilersException("visit_I32RemS() not implemented");}

    void visit_I32RemU() {throw LCompilersException("visit_I32RemU() not implemented");}

    void visit_I32And() {throw LCompilersException("visit_I32And() not implemented");}

    void visit_I32Or() {throw LCompilersException("visit_I32Or() not implemented");}

    void visit_I32Xor() {throw LCompilersException("visit_I32Xor() not implemented");}

    void visit_I32Shl() {throw LCompilersException("visit_I32Shl() not implemented");}

    void visit_I32ShrS() {throw LCompilersException("visit_I32ShrS() not implemented");}

    void visit_I32ShrU() {throw LCompilersException("visit_I32ShrU() not implemented");}

    void visit_I32Rotl() {throw LCompilersException("visit_I32Rotl() not implemented");}

    void visit_I32Rotr() {throw LCompilersException("visit_I32Rotr() not implemented");}

    void visit_I64Clz() {throw LCompilersException("visit_I64Clz() not implemented");}

    void visit_I64Ctz() {throw LCompilersException("visit_I64Ctz() not implemented");}

    void visit_I64Popcnt() {throw LCompilersException("visit_I64Popcnt() not implemented");}

    void visit_I64Add() {throw LCompilersException("visit_I64Add() not implemented");}

    void visit_I64Sub() {throw LCompilersException("visit_I64Sub() not implemented");}

    void visit_I64Mul() {throw LCompilersException("visit_I64Mul() not implemented");}

    void visit_I64DivS() {throw LCompilersException("visit_I64DivS() not implemented");}

    void visit_I64DivU() {throw LCompilersException("visit_I64DivU() not implemented");}

    void visit_I64RemS() {throw LCompilersException("visit_I64RemS() not implemented");}

    void visit_I64RemU() {throw LCompilersException("visit_I64RemU() not implemented");}

    void visit_I64And() {throw LCompilersException("visit_I64And() not implemented");}

    void visit_I64Or() {throw LCompilersException("visit_I64Or() not implemented");}

    void visit_I64Xor() {throw LCompilersException("visit_I64Xor() not implemented");}

    void visit_I64Shl() {throw LCompilersException("visit_I64Shl() not implemented");}

    void visit_I64ShrS() {throw LCompilersException("visit_I64ShrS() not implemented");}

    void visit_I64ShrU() {throw LCompilersException("visit_I64ShrU() not implemented");}

    void visit_I64Rotl() {throw LCompilersException("visit_I64Rotl() not implemented");}

    void visit_I64Rotr() {throw LCompilersException("visit_I64Rotr() not implemented");}

    void visit_F32Abs() {throw LCompilersException("visit_F32Abs() not implemented");}

    void visit_F32Neg() {throw LCompilersException("visit_F32Neg() not implemented");}

    void visit_F32Ceil() {throw LCompilersException("visit_F32Ceil() not implemented");}

    void visit_F32Floor() {throw LCompilersException("visit_F32Floor() not implemented");}

    void visit_F32Trunc() {throw LCompilersException("visit_F32Trunc() not implemented");}

    void visit_F32Nearest() {throw LCompilersException("visit_F32Nearest() not implemented");}

    void visit_F32Sqrt() {throw LCompilersException("visit_F32Sqrt() not implemented");}

    void visit_F32Add() {throw LCompilersException("visit_F32Add() not implemented");}

    void visit_F32Sub() {throw LCompilersException("visit_F32Sub() not implemented");}

    void visit_F32Mul() {throw LCompilersException("visit_F32Mul() not implemented");}

    void visit_F32Div() {throw LCompilersException("visit_F32Div() not implemented");}

    void visit_F32Min() {throw LCompilersException("visit_F32Min() not implemented");}

    void visit_F32Max() {throw LCompilersException("visit_F32Max() not implemented");}

    void visit_F32Copysign() {throw LCompilersException("visit_F32Copysign() not implemented");}

    void visit_F64Abs() {throw LCompilersException("visit_F64Abs() not implemented");}

    void visit_F64Neg() {throw LCompilersException("visit_F64Neg() not implemented");}

    void visit_F64Ceil() {throw LCompilersException("visit_F64Ceil() not implemented");}

    void visit_F64Floor() {throw LCompilersException("visit_F64Floor() not implemented");}

    void visit_F64Trunc() {throw LCompilersException("visit_F64Trunc() not implemented");}

    void visit_F64Nearest() {throw LCompilersException("visit_F64Nearest() not implemented");}

    void visit_F64Sqrt() {throw LCompilersException("visit_F64Sqrt() not implemented");}

    void visit_F64Add() {throw LCompilersException("visit_F64Add() not implemented");}

    void visit_F64Sub() {throw LCompilersException("visit_F64Sub() not implemented");}

    void visit_F64Mul() {throw LCompilersException("visit_F64Mul() not implemented");}

    void visit_F64Div() {throw LCompilersException("visit_F64Div() not implemented");}

    void visit_F64Min() {throw LCompilersException("visit_F64Min() not implemented");}

    void visit_F64Max() {throw LCompilersException("visit_F64Max() not implemented");}

    void visit_F64Copysign() {throw LCompilersException("visit_F64Copysign() not implemented");}

    void visit_I32WrapI64() {throw LCompilersException("visit_I32WrapI64() not implemented");}

    void visit_I32TruncF32S() {throw LCompilersException("visit_I32TruncF32S() not implemented");}

    void visit_I32TruncF32U() {throw LCompilersException("visit_I32TruncF32U() not implemented");}

    void visit_I32TruncF64S() {throw LCompilersException("visit_I32TruncF64S() not implemented");}

    void visit_I32TruncF64U() {throw LCompilersException("visit_I32TruncF64U() not implemented");}

    void visit_I64ExtendI32S() {throw LCompilersException("visit_I64ExtendI32S() not implemented");}

    void visit_I64ExtendI32U() {throw LCompilersException("visit_I64ExtendI32U() not implemented");}

    void visit_I64TruncF32S() {throw LCompilersException("visit_I64TruncF32S() not implemented");}

    void visit_I64TruncF32U() {throw LCompilersException("visit_I64TruncF32U() not implemented");}

    void visit_I64TruncF64S() {throw LCompilersException("visit_I64TruncF64S() not implemented");}

    void visit_I64TruncF64U() {throw LCompilersException("visit_I64TruncF64U() not implemented");}

    void visit_F32ConvertI32S() {throw LCompilersException("visit_F32ConvertI32S() not implemented");}

    void visit_F32ConvertI32U() {throw LCompilersException("visit_F32ConvertI32U() not implemented");}

    void visit_F32ConvertI64S() {throw LCompilersException("visit_F32ConvertI64S() not implemented");}

    void visit_F32ConvertI64U() {throw LCompilersException("visit_F32ConvertI64U() not implemented");}

    void visit_F32DemoteF64() {throw LCompilersException("visit_F32DemoteF64() not implemented");}

    void visit_F64ConvertI32S() {throw LCompilersException("visit_F64ConvertI32S() not implemented");}

    void visit_F64ConvertI32U() {throw LCompilersException("visit_F64ConvertI32U() not implemented");}

    void visit_F64ConvertI64S() {throw LCompilersException("visit_F64ConvertI64S() not implemented");}

    void visit_F64ConvertI64U() {throw LCompilersException("visit_F64ConvertI64U() not implemented");}

    void visit_F64PromoteF32() {throw LCompilersException("visit_F64PromoteF32() not implemented");}

    void visit_I32ReinterpretF32() {throw LCompilersException("visit_I32ReinterpretF32() not implemented");}

    void visit_I64ReinterpretF64() {throw LCompilersException("visit_I64ReinterpretF64() not implemented");}

    void visit_F32ReinterpretI32() {throw LCompilersException("visit_F32ReinterpretI32() not implemented");}

    void visit_F64ReinterpretI64() {throw LCompilersException("visit_F64ReinterpretI64() not implemented");}

    void visit_I32Extend8S() {throw LCompilersException("visit_I32Extend8S() not implemented");}

    void visit_I32Extend16S() {throw LCompilersException("visit_I32Extend16S() not implemented");}

    void visit_I64Extend8S() {throw LCompilersException("visit_I64Extend8S() not implemented");}

    void visit_I64Extend16S() {throw LCompilersException("visit_I64Extend16S() not implemented");}

    void visit_I64Extend32S() {throw LCompilersException("visit_I64Extend32S() not implemented");}

    void visit_I32TruncSatF32S() {throw LCompilersException("visit_I32TruncSatF32S() not implemented");}

    void visit_I32TruncSatF32U() {throw LCompilersException("visit_I32TruncSatF32U() not implemented");}

    void visit_I32TruncSatF64S() {throw LCompilersException("visit_I32TruncSatF64S() not implemented");}

    void visit_I32TruncSatF64U() {throw LCompilersException("visit_I32TruncSatF64U() not implemented");}

    void visit_I64TruncSatF32S() {throw LCompilersException("visit_I64TruncSatF32S() not implemented");}

    void visit_I64TruncSatF32U() {throw LCompilersException("visit_I64TruncSatF32U() not implemented");}

    void visit_I64TruncSatF64S() {throw LCompilersException("visit_I64TruncSatF64S() not implemented");}

    void visit_I64TruncSatF64U() {throw LCompilersException("visit_I64TruncSatF64U() not implemented");}

    void visit_V128Load(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load() not implemented");}

    void visit_V128Load8x8S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load8x8S() not implemented");}

    void visit_V128Load8x8U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load8x8U() not implemented");}

    void visit_V128Load16x4S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load16x4S() not implemented");}

    void visit_V128Load16x4U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load16x4U() not implemented");}

    void visit_V128Load32x2S(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load32x2S() not implemented");}

    void visit_V128Load32x2U(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load32x2U() not implemented");}

    void visit_V128Load8Splat(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load8Splat() not implemented");}

    void visit_V128Load16Splat(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load16Splat() not implemented");}

    void visit_V128Load32Splat(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load32Splat() not implemented");}

    void visit_V128Load64Splat(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load64Splat() not implemented");}

    void visit_V128Load32Zero(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load32Zero() not implemented");}

    void visit_V128Load64Zero(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Load64Zero() not implemented");}

    void visit_V128Store(uint32_t /*mem_align*/, uint32_t /*mem_offset*/) {throw LCompilersException("visit_V128Store() not implemented");}

    void visit_V128Load8Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Load8Lane() not implemented");}

    void visit_V128Load16Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Load16Lane() not implemented");}

    void visit_V128Load32Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Load32Lane() not implemented");}

    void visit_V128Load64Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Load64Lane() not implemented");}

    void visit_V128Store8Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Store8Lane() not implemented");}

    void visit_V128Store16Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Store16Lane() not implemented");}

    void visit_V128Store32Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Store32Lane() not implemented");}

    void visit_V128Store64Lane(uint32_t /*mem_align*/, uint32_t /*mem_offset*/, uint8_t /*laneidx*/) {throw LCompilersException("visit_V128Store64Lane() not implemented");}

    void visit_I8x16ExtractLaneS(uint8_t /*laneidx*/) {throw LCompilersException("visit_I8x16ExtractLaneS() not implemented");}

    void visit_I8x16ExtractLaneU(uint8_t /*laneidx*/) {throw LCompilersException("visit_I8x16ExtractLaneU() not implemented");}

    void visit_I8x16ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I8x16ReplaceLane() not implemented");}

    void visit_I16x8ExtractLaneS(uint8_t /*laneidx*/) {throw LCompilersException("visit_I16x8ExtractLaneS() not implemented");}

    void visit_I16x8ExtractLaneU(uint8_t /*laneidx*/) {throw LCompilersException("visit_I16x8ExtractLaneU() not implemented");}

    void visit_I16x8ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I16x8ReplaceLane() not implemented");}

    void visit_I32x4ExtractLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I32x4ExtractLane() not implemented");}

    void visit_I32x4ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I32x4ReplaceLane() not implemented");}

    void visit_I64x2ExtractLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I64x2ExtractLane() not implemented");}

    void visit_I64x2ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_I64x2ReplaceLane() not implemented");}

    void visit_F32x4ExtractLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_F32x4ExtractLane() not implemented");}

    void visit_F32x4ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_F32x4ReplaceLane() not implemented");}

    void visit_F64x2ExtractLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_F64x2ExtractLane() not implemented");}

    void visit_F64x2ReplaceLane(uint8_t /*laneidx*/) {throw LCompilersException("visit_F64x2ReplaceLane() not implemented");}

    void visit_I8x16Swizzle() {throw LCompilersException("visit_I8x16Swizzle() not implemented");}

    void visit_I8x16Splat() {throw LCompilersException("visit_I8x16Splat() not implemented");}

    void visit_I16x8Splat() {throw LCompilersException("visit_I16x8Splat() not implemented");}

    void visit_I32x4Splat() {throw LCompilersException("visit_I32x4Splat() not implemented");}

    void visit_I64x2Splat() {throw LCompilersException("visit_I64x2Splat() not implemented");}

    void visit_F32x4Splat() {throw LCompilersException("visit_F32x4Splat() not implemented");}

    void visit_F64x2Splat() {throw LCompilersException("visit_F64x2Splat() not implemented");}

    void visit_I8x16Eq() {throw LCompilersException("visit_I8x16Eq() not implemented");}

    void visit_I8x16Ne() {throw LCompilersException("visit_I8x16Ne() not implemented");}

    void visit_I8x16LtS() {throw LCompilersException("visit_I8x16LtS() not implemented");}

    void visit_I8x16LtU() {throw LCompilersException("visit_I8x16LtU() not implemented");}

    void visit_I8x16GtS() {throw LCompilersException("visit_I8x16GtS() not implemented");}

    void visit_I8x16GtU() {throw LCompilersException("visit_I8x16GtU() not implemented");}

    void visit_I8x16LeS() {throw LCompilersException("visit_I8x16LeS() not implemented");}

    void visit_I8x16LeU() {throw LCompilersException("visit_I8x16LeU() not implemented");}

    void visit_I8x16GeS() {throw LCompilersException("visit_I8x16GeS() not implemented");}

    void visit_I8x16GeU() {throw LCompilersException("visit_I8x16GeU() not implemented");}

    void visit_I16x8Eq() {throw LCompilersException("visit_I16x8Eq() not implemented");}

    void visit_I16x8Ne() {throw LCompilersException("visit_I16x8Ne() not implemented");}

    void visit_I16x8LtS() {throw LCompilersException("visit_I16x8LtS() not implemented");}

    void visit_I16x8LtU() {throw LCompilersException("visit_I16x8LtU() not implemented");}

    void visit_I16x8GtS() {throw LCompilersException("visit_I16x8GtS() not implemented");}

    void visit_I16x8GtU() {throw LCompilersException("visit_I16x8GtU() not implemented");}

    void visit_I16x8LeS() {throw LCompilersException("visit_I16x8LeS() not implemented");}

    void visit_I16x8LeU() {throw LCompilersException("visit_I16x8LeU() not implemented");}

    void visit_I16x8GeS() {throw LCompilersException("visit_I16x8GeS() not implemented");}

    void visit_I16x8GeU() {throw LCompilersException("visit_I16x8GeU() not implemented");}

    void visit_I32x4Eq() {throw LCompilersException("visit_I32x4Eq() not implemented");}

    void visit_I32x4Ne() {throw LCompilersException("visit_I32x4Ne() not implemented");}

    void visit_I32x4LtS() {throw LCompilersException("visit_I32x4LtS() not implemented");}

    void visit_I32x4LtU() {throw LCompilersException("visit_I32x4LtU() not implemented");}

    void visit_I32x4GtS() {throw LCompilersException("visit_I32x4GtS() not implemented");}

    void visit_I32x4GtU() {throw LCompilersException("visit_I32x4GtU() not implemented");}

    void visit_I32x4LeS() {throw LCompilersException("visit_I32x4LeS() not implemented");}

    void visit_I32x4LeU() {throw LCompilersException("visit_I32x4LeU() not implemented");}

    void visit_I32x4GeS() {throw LCompilersException("visit_I32x4GeS() not implemented");}

    void visit_I32x4GeU() {throw LCompilersException("visit_I32x4GeU() not implemented");}

    void visit_I64x2Eq() {throw LCompilersException("visit_I64x2Eq() not implemented");}

    void visit_I64x2Ne() {throw LCompilersException("visit_I64x2Ne() not implemented");}

    void visit_I64x2LtS() {throw LCompilersException("visit_I64x2LtS() not implemented");}

    void visit_I64x2GtS() {throw LCompilersException("visit_I64x2GtS() not implemented");}

    void visit_I64x2LeS() {throw LCompilersException("visit_I64x2LeS() not implemented");}

    void visit_I64x2GeS() {throw LCompilersException("visit_I64x2GeS() not implemented");}

    void visit_F32x4Eq() {throw LCompilersException("visit_F32x4Eq() not implemented");}

    void visit_F32x4Ne() {throw LCompilersException("visit_F32x4Ne() not implemented");}

    void visit_F32x4Lt() {throw LCompilersException("visit_F32x4Lt() not implemented");}

    void visit_F32x4Gt() {throw LCompilersException("visit_F32x4Gt() not implemented");}

    void visit_F32x4Le() {throw LCompilersException("visit_F32x4Le() not implemented");}

    void visit_F32x4Ge() {throw LCompilersException("visit_F32x4Ge() not implemented");}

    void visit_F64x2Eq() {throw LCompilersException("visit_F64x2Eq() not implemented");}

    void visit_F64x2Ne() {throw LCompilersException("visit_F64x2Ne() not implemented");}

    void visit_F64x2Lt() {throw LCompilersException("visit_F64x2Lt() not implemented");}

    void visit_F64x2Gt() {throw LCompilersException("visit_F64x2Gt() not implemented");}

    void visit_F64x2Le() {throw LCompilersException("visit_F64x2Le() not implemented");}

    void visit_F64x2Ge() {throw LCompilersException("visit_F64x2Ge() not implemented");}

    void visit_V128Not() {throw LCompilersException("visit_V128Not() not implemented");}

    void visit_V128And() {throw LCompilersException("visit_V128And() not implemented");}

    void visit_V128Andnot() {throw LCompilersException("visit_V128Andnot() not implemented");}

    void visit_V128Or() {throw LCompilersException("visit_V128Or() not implemented");}

    void visit_V128Xor() {throw LCompilersException("visit_V128Xor() not implemented");}

    void visit_V128Bitselect() {throw LCompilersException("visit_V128Bitselect() not implemented");}

    void visit_V128AnyTrue() {throw LCompilersException("visit_V128AnyTrue() not implemented");}

    void visit_I8x16Abs() {throw LCompilersException("visit_I8x16Abs() not implemented");}

    void visit_I8x16Neg() {throw LCompilersException("visit_I8x16Neg() not implemented");}

    void visit_I8x16Popcnt() {throw LCompilersException("visit_I8x16Popcnt() not implemented");}

    void visit_I8x16AllTrue() {throw LCompilersException("visit_I8x16AllTrue() not implemented");}

    void visit_I8x16Bitmask() {throw LCompilersException("visit_I8x16Bitmask() not implemented");}

    void visit_I8x16NarrowI16x8S() {throw LCompilersException("visit_I8x16NarrowI16x8S() not implemented");}

    void visit_I8x16NarrowI16x8U() {throw LCompilersException("visit_I8x16NarrowI16x8U() not implemented");}

    void visit_I8x16Shl() {throw LCompilersException("visit_I8x16Shl() not implemented");}

    void visit_I8x16ShrS() {throw LCompilersException("visit_I8x16ShrS() not implemented");}

    void visit_I8x16ShrU() {throw LCompilersException("visit_I8x16ShrU() not implemented");}

    void visit_I8x16Add() {throw LCompilersException("visit_I8x16Add() not implemented");}

    void visit_I8x16AddSatS() {throw LCompilersException("visit_I8x16AddSatS() not implemented");}

    void visit_I8x16AddSatU() {throw LCompilersException("visit_I8x16AddSatU() not implemented");}

    void visit_I8x16Sub() {throw LCompilersException("visit_I8x16Sub() not implemented");}

    void visit_I8x16SubSatS() {throw LCompilersException("visit_I8x16SubSatS() not implemented");}

    void visit_I8x16SubSatU() {throw LCompilersException("visit_I8x16SubSatU() not implemented");}

    void visit_I8x16MinS() {throw LCompilersException("visit_I8x16MinS() not implemented");}

    void visit_I8x16MinU() {throw LCompilersException("visit_I8x16MinU() not implemented");}

    void visit_I8x16MaxS() {throw LCompilersException("visit_I8x16MaxS() not implemented");}

    void visit_I8x16MaxU() {throw LCompilersException("visit_I8x16MaxU() not implemented");}

    void visit_I8x16AvgrU() {throw LCompilersException("visit_I8x16AvgrU() not implemented");}

    void visit_I16x8ExtaddPairwiseI8x16S() {throw LCompilersException("visit_I16x8ExtaddPairwiseI8x16S() not implemented");}

    void visit_I16x8ExtaddPairwiseI8x16U() {throw LCompilersException("visit_I16x8ExtaddPairwiseI8x16U() not implemented");}

    void visit_I16x8Abs() {throw LCompilersException("visit_I16x8Abs() not implemented");}

    void visit_I16x8Neg() {throw LCompilersException("visit_I16x8Neg() not implemented");}

    void visit_I16x8Q15mulrSatS() {throw LCompilersException("visit_I16x8Q15mulrSatS() not implemented");}

    void visit_I16x8AllTrue() {throw LCompilersException("visit_I16x8AllTrue() not implemented");}

    void visit_I16x8Bitmask() {throw LCompilersException("visit_I16x8Bitmask() not implemented");}

    void visit_I16x8NarrowI32x4S() {throw LCompilersException("visit_I16x8NarrowI32x4S() not implemented");}

    void visit_I16x8NarrowI32x4U() {throw LCompilersException("visit_I16x8NarrowI32x4U() not implemented");}

    void visit_I16x8ExtendLowI8x16S() {throw LCompilersException("visit_I16x8ExtendLowI8x16S() not implemented");}

    void visit_I16x8ExtendHighI8x16S() {throw LCompilersException("visit_I16x8ExtendHighI8x16S() not implemented");}

    void visit_I16x8ExtendLowI8x16U() {throw LCompilersException("visit_I16x8ExtendLowI8x16U() not implemented");}

    void visit_I16x8ExtendHighI8x16U() {throw LCompilersException("visit_I16x8ExtendHighI8x16U() not implemented");}

    void visit_I16x8Shl() {throw LCompilersException("visit_I16x8Shl() not implemented");}

    void visit_I16x8ShrS() {throw LCompilersException("visit_I16x8ShrS() not implemented");}

    void visit_I16x8ShrU() {throw LCompilersException("visit_I16x8ShrU() not implemented");}

    void visit_I16x8Add() {throw LCompilersException("visit_I16x8Add() not implemented");}

    void visit_I16x8AddSatS() {throw LCompilersException("visit_I16x8AddSatS() not implemented");}

    void visit_I16x8AddSatU() {throw LCompilersException("visit_I16x8AddSatU() not implemented");}

    void visit_I16x8Sub() {throw LCompilersException("visit_I16x8Sub() not implemented");}

    void visit_I16x8SubSatS() {throw LCompilersException("visit_I16x8SubSatS() not implemented");}

    void visit_I16x8SubSatU() {throw LCompilersException("visit_I16x8SubSatU() not implemented");}

    void visit_I16x8Mul() {throw LCompilersException("visit_I16x8Mul() not implemented");}

    void visit_I16x8MinS() {throw LCompilersException("visit_I16x8MinS() not implemented");}

    void visit_I16x8MinU() {throw LCompilersException("visit_I16x8MinU() not implemented");}

    void visit_I16x8MaxS() {throw LCompilersException("visit_I16x8MaxS() not implemented");}

    void visit_I16x8MaxU() {throw LCompilersException("visit_I16x8MaxU() not implemented");}

    void visit_I16x8AvgrU() {throw LCompilersException("visit_I16x8AvgrU() not implemented");}

    void visit_I16x8ExtmulLowI8x16S() {throw LCompilersException("visit_I16x8ExtmulLowI8x16S() not implemented");}

    void visit_I16x8ExtmulHighI8x16S() {throw LCompilersException("visit_I16x8ExtmulHighI8x16S() not implemented");}

    void visit_I16x8ExtmulLowI8x16U() {throw LCompilersException("visit_I16x8ExtmulLowI8x16U() not implemented");}

    void visit_I16x8ExtmulHighI8x16U() {throw LCompilersException("visit_I16x8ExtmulHighI8x16U() not implemented");}

    void visit_I32x4ExtaddPairwiseI16x8S() {throw LCompilersException("visit_I32x4ExtaddPairwiseI16x8S() not implemented");}

    void visit_I32x4ExtaddPairwiseI16x8U() {throw LCompilersException("visit_I32x4ExtaddPairwiseI16x8U() not implemented");}

    void visit_I32x4Abs() {throw LCompilersException("visit_I32x4Abs() not implemented");}

    void visit_I32x4Neg() {throw LCompilersException("visit_I32x4Neg() not implemented");}

    void visit_I32x4AllTrue() {throw LCompilersException("visit_I32x4AllTrue() not implemented");}

    void visit_I32x4Bitmask() {throw LCompilersException("visit_I32x4Bitmask() not implemented");}

    void visit_I32x4ExtendLowI16x8S() {throw LCompilersException("visit_I32x4ExtendLowI16x8S() not implemented");}

    void visit_I32x4ExtendHighI16x8S() {throw LCompilersException("visit_I32x4ExtendHighI16x8S() not implemented");}

    void visit_I32x4ExtendLowI16x8U() {throw LCompilersException("visit_I32x4ExtendLowI16x8U() not implemented");}

    void visit_I32x4ExtendHighI16x8U() {throw LCompilersException("visit_I32x4ExtendHighI16x8U() not implemented");}

    void visit_I32x4Shl() {throw LCompilersException("visit_I32x4Shl() not implemented");}

    void visit_I32x4ShrS() {throw LCompilersException("visit_I32x4ShrS() not implemented");}

    void visit_I32x4ShrU() {throw LCompilersException("visit_I32x4ShrU() not implemented");}

    void visit_I32x4Add() {throw LCompilersException("visit_I32x4Add() not implemented");}

    void visit_I32x4Sub() {throw LCompilersException("visit_I32x4Sub() not implemented");}

    void visit_I32x4Mul() {throw LCompilersException("visit_I32x4Mul() not implemented");}

    void visit_I32x4MinS() {throw LCompilersException("visit_I32x4MinS() not implemented");}

    void visit_I32x4MinU() {throw LCompilersException("visit_I32x4MinU() not implemented");}

    void visit_I32x4MaxS() {throw LCompilersException("visit_I32x4MaxS() not implemented");}

    void visit_I32x4MaxU() {throw LCompilersException("visit_I32x4MaxU() not implemented");}

    void visit_I32x4DotI16x8S() {throw LCompilersException("visit_I32x4DotI16x8S() not implemented");}

    void visit_I32x4ExtmulLowI16x8S() {throw LCompilersException("visit_I32x4ExtmulLowI16x8S() not implemented");}

    void visit_I32x4ExtmulHighI16x8S() {throw LCompilersException("visit_I32x4ExtmulHighI16x8S() not implemented");}

    void visit_I32x4ExtmulLowI16x8U() {throw LCompilersException("visit_I32x4ExtmulLowI16x8U() not implemented");}

    void visit_I32x4ExtmulHighI16x8U() {throw LCompilersException("visit_I32x4ExtmulHighI16x8U() not implemented");}

    void visit_I64x2Abs() {throw LCompilersException("visit_I64x2Abs() not implemented");}

    void visit_I64x2Neg() {throw LCompilersException("visit_I64x2Neg() not implemented");}

    void visit_I64x2AllTrue() {throw LCompilersException("visit_I64x2AllTrue() not implemented");}

    void visit_I64x2Bitmask() {throw LCompilersException("visit_I64x2Bitmask() not implemented");}

    void visit_I64x2ExtendLowI32x4S() {throw LCompilersException("visit_I64x2ExtendLowI32x4S() not implemented");}

    void visit_I64x2ExtendHighI32x4S() {throw LCompilersException("visit_I64x2ExtendHighI32x4S() not implemented");}

    void visit_I64x2ExtendLowI32x4U() {throw LCompilersException("visit_I64x2ExtendLowI32x4U() not implemented");}

    void visit_I64x2ExtendHighI32x4U() {throw LCompilersException("visit_I64x2ExtendHighI32x4U() not implemented");}

    void visit_I64x2Shl() {throw LCompilersException("visit_I64x2Shl() not implemented");}

    void visit_I64x2ShrS() {throw LCompilersException("visit_I64x2ShrS() not implemented");}

    void visit_I64x2ShrU() {throw LCompilersException("visit_I64x2ShrU() not implemented");}

    void visit_I64x2Add() {throw LCompilersException("visit_I64x2Add() not implemented");}

    void visit_I64x2Sub() {throw LCompilersException("visit_I64x2Sub() not implemented");}

    void visit_I64x2Mul() {throw LCompilersException("visit_I64x2Mul() not implemented");}

    void visit_I64x2ExtmulLowI32x4S() {throw LCompilersException("visit_I64x2ExtmulLowI32x4S() not implemented");}

    void visit_I64x2ExtmulHighI32x4S() {throw LCompilersException("visit_I64x2ExtmulHighI32x4S() not implemented");}

    void visit_I64x2ExtmulLowI32x4U() {throw LCompilersException("visit_I64x2ExtmulLowI32x4U() not implemented");}

    void visit_I64x2ExtmulHighI32x4U() {throw LCompilersException("visit_I64x2ExtmulHighI32x4U() not implemented");}

    void visit_F32x4Ceil() {throw LCompilersException("visit_F32x4Ceil() not implemented");}

    void visit_F32x4Floor() {throw LCompilersException("visit_F32x4Floor() not implemented");}

    void visit_F32x4Trunc() {throw LCompilersException("visit_F32x4Trunc() not implemented");}

    void visit_F32x4Nearest() {throw LCompilersException("visit_F32x4Nearest() not implemented");}

    void visit_F32x4Abs() {throw LCompilersException("visit_F32x4Abs() not implemented");}

    void visit_F32x4Neg() {throw LCompilersException("visit_F32x4Neg() not implemented");}

    void visit_F32x4Sqrt() {throw LCompilersException("visit_F32x4Sqrt() not implemented");}

    void visit_F32x4Add() {throw LCompilersException("visit_F32x4Add() not implemented");}

    void visit_F32x4Sub() {throw LCompilersException("visit_F32x4Sub() not implemented");}

    void visit_F32x4Mul() {throw LCompilersException("visit_F32x4Mul() not implemented");}

    void visit_F32x4Div() {throw LCompilersException("visit_F32x4Div() not implemented");}

    void visit_F32x4Min() {throw LCompilersException("visit_F32x4Min() not implemented");}

    void visit_F32x4Max() {throw LCompilersException("visit_F32x4Max() not implemented");}

    void visit_F32x4Pmin() {throw LCompilersException("visit_F32x4Pmin() not implemented");}

    void visit_F32x4Pmax() {throw LCompilersException("visit_F32x4Pmax() not implemented");}

    void visit_F64x2Ceil() {throw LCompilersException("visit_F64x2Ceil() not implemented");}

    void visit_F64x2Floor() {throw LCompilersException("visit_F64x2Floor() not implemented");}

    void visit_F64x2Trunc() {throw LCompilersException("visit_F64x2Trunc() not implemented");}

    void visit_F64x2Nearest() {throw LCompilersException("visit_F64x2Nearest() not implemented");}

    void visit_F64x2Abs() {throw LCompilersException("visit_F64x2Abs() not implemented");}

    void visit_F64x2Neg() {throw LCompilersException("visit_F64x2Neg() not implemented");}

    void visit_F64x2Sqrt() {throw LCompilersException("visit_F64x2Sqrt() not implemented");}

    void visit_F64x2Add() {throw LCompilersException("visit_F64x2Add() not implemented");}

    void visit_F64x2Sub() {throw LCompilersException("visit_F64x2Sub() not implemented");}

    void visit_F64x2Mul() {throw LCompilersException("visit_F64x2Mul() not implemented");}

    void visit_F64x2Div() {throw LCompilersException("visit_F64x2Div() not implemented");}

    void visit_F64x2Min() {throw LCompilersException("visit_F64x2Min() not implemented");}

    void visit_F64x2Max() {throw LCompilersException("visit_F64x2Max() not implemented");}

    void visit_F64x2Pmin() {throw LCompilersException("visit_F64x2Pmin() not implemented");}

    void visit_F64x2Pmax() {throw LCompilersException("visit_F64x2Pmax() not implemented");}

    void visit_I32x4TruncSatF32x4S() {throw LCompilersException("visit_I32x4TruncSatF32x4S() not implemented");}

    void visit_I32x4TruncSatF32x4U() {throw LCompilersException("visit_I32x4TruncSatF32x4U() not implemented");}

    void visit_F32x4ConvertI32x4S() {throw LCompilersException("visit_F32x4ConvertI32x4S() not implemented");}

    void visit_F32x4ConvertI32x4U() {throw LCompilersException("visit_F32x4ConvertI32x4U() not implemented");}

    void visit_I32x4TruncSatF64x2SZero() {throw LCompilersException("visit_I32x4TruncSatF64x2SZero() not implemented");}

    void visit_I32x4TruncSatF64x2UZero() {throw LCompilersException("visit_I32x4TruncSatF64x2UZero() not implemented");}

    void visit_F64x2ConvertLowI32x4S() {throw LCompilersException("visit_F64x2ConvertLowI32x4S() not implemented");}

    void visit_F64x2ConvertLowI32x4U() {throw LCompilersException("visit_F64x2ConvertLowI32x4U() not implemented");}

    void visit_F32x4DemoteF64x2Zero() {throw LCompilersException("visit_F32x4DemoteF64x2Zero() not implemented");}

    void visit_F64x2PromoteLowF32x4() {throw LCompilersException("visit_F64x2PromoteLowF32x4() not implemented");}

    void decode_instructions() {
        uint8_t cur_byte = wasm::read_b8(code, offset);
        while (cur_byte != 0x0B) {
            switch (cur_byte) {
                case 0x40: {
                    self().visit_EmtpyBlockType();
                    break;
                }
                case 0x00: {
                    self().visit_Unreachable();
                    break;
                }
                case 0x01: {
                    self().visit_Nop();
                    break;
                }
                case 0x03: {
                    self().visit_Loop();
                    break;
                }
                case 0x04: {
                    self().visit_If();
                    break;
                }
                case 0x05: {
                    self().visit_Else();
                    break;
                }
                case 0x0C: {
                    uint32_t labelidx = wasm::read_u32(code, offset);
                    self().visit_Br(labelidx);
                    break;
                }
                case 0x0D: {
                    uint32_t labelidx = wasm::read_u32(code, offset);
                    self().visit_BrIf(labelidx);
                    break;
                }
                case 0x0F: {
                    self().visit_Return();
                    break;
                }
                case 0x10: {
                    uint32_t funcidx = wasm::read_u32(code, offset);
                    self().visit_Call(funcidx);
                    break;
                }
                case 0x11: {
                    uint32_t typeidx = wasm::read_u32(code, offset);
                    uint32_t tableidx = wasm::read_u32(code, offset);
                    self().visit_CallIndirect(typeidx, tableidx);
                    break;
                }
                case 0xD0: {
                    uint8_t reftype = wasm::read_b8(code, offset);
                    self().visit_RefNull(reftype);
                    break;
                }
                case 0xD1: {
                    self().visit_RefIsNull();
                    break;
                }
                case 0xD2: {
                    uint32_t funcidx = wasm::read_u32(code, offset);
                    self().visit_RefFunc(funcidx);
                    break;
                }
                case 0x1A: {
                    self().visit_Drop();
                    break;
                }
                case 0x1B: {
                    self().visit_Select();
                    break;
                }
                case 0x20: {
                    uint32_t localidx = wasm::read_u32(code, offset);
                    self().visit_LocalGet(localidx);
                    break;
                }
                case 0x21: {
                    uint32_t localidx = wasm::read_u32(code, offset);
                    self().visit_LocalSet(localidx);
                    break;
                }
                case 0x22: {
                    uint32_t localidx = wasm::read_u32(code, offset);
                    self().visit_LocalTee(localidx);
                    break;
                }
                case 0x23: {
                    uint32_t globalidx = wasm::read_u32(code, offset);
                    self().visit_GlobalGet(globalidx);
                    break;
                }
                case 0x24: {
                    uint32_t globalidx = wasm::read_u32(code, offset);
                    self().visit_GlobalSet(globalidx);
                    break;
                }
                case 0x25: {
                    uint32_t tableidx = wasm::read_u32(code, offset);
                    self().visit_TableGet(tableidx);
                    break;
                }
                case 0x26: {
                    uint32_t tableidx = wasm::read_u32(code, offset);
                    self().visit_TableSet(tableidx);
                    break;
                }
                case 0x28: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Load(mem_align, mem_offset);
                    break;
                }
                case 0x29: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load(mem_align, mem_offset);
                    break;
                }
                case 0x2A: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_F32Load(mem_align, mem_offset);
                    break;
                }
                case 0x2B: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_F64Load(mem_align, mem_offset);
                    break;
                }
                case 0x2C: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Load8S(mem_align, mem_offset);
                    break;
                }
                case 0x2D: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Load8U(mem_align, mem_offset);
                    break;
                }
                case 0x2E: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Load16S(mem_align, mem_offset);
                    break;
                }
                case 0x2F: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Load16U(mem_align, mem_offset);
                    break;
                }
                case 0x30: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load8S(mem_align, mem_offset);
                    break;
                }
                case 0x31: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load8U(mem_align, mem_offset);
                    break;
                }
                case 0x32: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load16S(mem_align, mem_offset);
                    break;
                }
                case 0x33: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load16U(mem_align, mem_offset);
                    break;
                }
                case 0x34: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load32S(mem_align, mem_offset);
                    break;
                }
                case 0x35: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Load32U(mem_align, mem_offset);
                    break;
                }
                case 0x36: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Store(mem_align, mem_offset);
                    break;
                }
                case 0x37: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Store(mem_align, mem_offset);
                    break;
                }
                case 0x38: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_F32Store(mem_align, mem_offset);
                    break;
                }
                case 0x39: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_F64Store(mem_align, mem_offset);
                    break;
                }
                case 0x3A: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Store8(mem_align, mem_offset);
                    break;
                }
                case 0x3B: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I32Store16(mem_align, mem_offset);
                    break;
                }
                case 0x3C: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Store8(mem_align, mem_offset);
                    break;
                }
                case 0x3D: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Store16(mem_align, mem_offset);
                    break;
                }
                case 0x3E: {
                    uint32_t mem_align = wasm::read_u32(code, offset);
                    uint32_t mem_offset = wasm::read_u32(code, offset);
                    self().visit_I64Store32(mem_align, mem_offset);
                    break;
                }
                case 0x41: {
                    int32_t n = wasm::read_i32(code, offset);
                    self().visit_I32Const(n);
                    break;
                }
                case 0x42: {
                    int64_t n = wasm::read_i64(code, offset);
                    self().visit_I64Const(n);
                    break;
                }
                case 0x43: {
                    float z = wasm::read_f32(code, offset);
                    self().visit_F32Const(z);
                    break;
                }
                case 0x44: {
                    double z = wasm::read_f64(code, offset);
                    self().visit_F64Const(z);
                    break;
                }
                case 0x45: {
                    self().visit_I32Eqz();
                    break;
                }
                case 0x46: {
                    self().visit_I32Eq();
                    break;
                }
                case 0x47: {
                    self().visit_I32Ne();
                    break;
                }
                case 0x48: {
                    self().visit_I32LtS();
                    break;
                }
                case 0x49: {
                    self().visit_I32LtU();
                    break;
                }
                case 0x4A: {
                    self().visit_I32GtS();
                    break;
                }
                case 0x4B: {
                    self().visit_I32GtU();
                    break;
                }
                case 0x4C: {
                    self().visit_I32LeS();
                    break;
                }
                case 0x4D: {
                    self().visit_I32LeU();
                    break;
                }
                case 0x4E: {
                    self().visit_I32GeS();
                    break;
                }
                case 0x4F: {
                    self().visit_I32GeU();
                    break;
                }
                case 0x50: {
                    self().visit_I64Eqz();
                    break;
                }
                case 0x51: {
                    self().visit_I64Eq();
                    break;
                }
                case 0x52: {
                    self().visit_I64Ne();
                    break;
                }
                case 0x53: {
                    self().visit_I64LtS();
                    break;
                }
                case 0x54: {
                    self().visit_I64LtU();
                    break;
                }
                case 0x55: {
                    self().visit_I64GtS();
                    break;
                }
                case 0x56: {
                    self().visit_I64GtU();
                    break;
                }
                case 0x57: {
                    self().visit_I64LeS();
                    break;
                }
                case 0x58: {
                    self().visit_I64LeU();
                    break;
                }
                case 0x59: {
                    self().visit_I64GeS();
                    break;
                }
                case 0x5A: {
                    self().visit_I64GeU();
                    break;
                }
                case 0x5B: {
                    self().visit_F32Eq();
                    break;
                }
                case 0x5C: {
                    self().visit_F32Ne();
                    break;
                }
                case 0x5D: {
                    self().visit_F32Lt();
                    break;
                }
                case 0x5E: {
                    self().visit_F32Gt();
                    break;
                }
                case 0x5F: {
                    self().visit_F32Le();
                    break;
                }
                case 0x60: {
                    self().visit_F32Ge();
                    break;
                }
                case 0x61: {
                    self().visit_F64Eq();
                    break;
                }
                case 0x62: {
                    self().visit_F64Ne();
                    break;
                }
                case 0x63: {
                    self().visit_F64Lt();
                    break;
                }
                case 0x64: {
                    self().visit_F64Gt();
                    break;
                }
                case 0x65: {
                    self().visit_F64Le();
                    break;
                }
                case 0x66: {
                    self().visit_F64Ge();
                    break;
                }
                case 0x67: {
                    self().visit_I32Clz();
                    break;
                }
                case 0x68: {
                    self().visit_I32Ctz();
                    break;
                }
                case 0x69: {
                    self().visit_I32Popcnt();
                    break;
                }
                case 0x6A: {
                    self().visit_I32Add();
                    break;
                }
                case 0x6B: {
                    self().visit_I32Sub();
                    break;
                }
                case 0x6C: {
                    self().visit_I32Mul();
                    break;
                }
                case 0x6D: {
                    self().visit_I32DivS();
                    break;
                }
                case 0x6E: {
                    self().visit_I32DivU();
                    break;
                }
                case 0x6F: {
                    self().visit_I32RemS();
                    break;
                }
                case 0x70: {
                    self().visit_I32RemU();
                    break;
                }
                case 0x71: {
                    self().visit_I32And();
                    break;
                }
                case 0x72: {
                    self().visit_I32Or();
                    break;
                }
                case 0x73: {
                    self().visit_I32Xor();
                    break;
                }
                case 0x74: {
                    self().visit_I32Shl();
                    break;
                }
                case 0x75: {
                    self().visit_I32ShrS();
                    break;
                }
                case 0x76: {
                    self().visit_I32ShrU();
                    break;
                }
                case 0x77: {
                    self().visit_I32Rotl();
                    break;
                }
                case 0x78: {
                    self().visit_I32Rotr();
                    break;
                }
                case 0x79: {
                    self().visit_I64Clz();
                    break;
                }
                case 0x7A: {
                    self().visit_I64Ctz();
                    break;
                }
                case 0x7B: {
                    self().visit_I64Popcnt();
                    break;
                }
                case 0x7C: {
                    self().visit_I64Add();
                    break;
                }
                case 0x7D: {
                    self().visit_I64Sub();
                    break;
                }
                case 0x7E: {
                    self().visit_I64Mul();
                    break;
                }
                case 0x7F: {
                    self().visit_I64DivS();
                    break;
                }
                case 0x80: {
                    self().visit_I64DivU();
                    break;
                }
                case 0x81: {
                    self().visit_I64RemS();
                    break;
                }
                case 0x82: {
                    self().visit_I64RemU();
                    break;
                }
                case 0x83: {
                    self().visit_I64And();
                    break;
                }
                case 0x84: {
                    self().visit_I64Or();
                    break;
                }
                case 0x85: {
                    self().visit_I64Xor();
                    break;
                }
                case 0x86: {
                    self().visit_I64Shl();
                    break;
                }
                case 0x87: {
                    self().visit_I64ShrS();
                    break;
                }
                case 0x88: {
                    self().visit_I64ShrU();
                    break;
                }
                case 0x89: {
                    self().visit_I64Rotl();
                    break;
                }
                case 0x8A: {
                    self().visit_I64Rotr();
                    break;
                }
                case 0x8B: {
                    self().visit_F32Abs();
                    break;
                }
                case 0x8C: {
                    self().visit_F32Neg();
                    break;
                }
                case 0x8D: {
                    self().visit_F32Ceil();
                    break;
                }
                case 0x8E: {
                    self().visit_F32Floor();
                    break;
                }
                case 0x8F: {
                    self().visit_F32Trunc();
                    break;
                }
                case 0x90: {
                    self().visit_F32Nearest();
                    break;
                }
                case 0x91: {
                    self().visit_F32Sqrt();
                    break;
                }
                case 0x92: {
                    self().visit_F32Add();
                    break;
                }
                case 0x93: {
                    self().visit_F32Sub();
                    break;
                }
                case 0x94: {
                    self().visit_F32Mul();
                    break;
                }
                case 0x95: {
                    self().visit_F32Div();
                    break;
                }
                case 0x96: {
                    self().visit_F32Min();
                    break;
                }
                case 0x97: {
                    self().visit_F32Max();
                    break;
                }
                case 0x98: {
                    self().visit_F32Copysign();
                    break;
                }
                case 0x99: {
                    self().visit_F64Abs();
                    break;
                }
                case 0x9A: {
                    self().visit_F64Neg();
                    break;
                }
                case 0x9B: {
                    self().visit_F64Ceil();
                    break;
                }
                case 0x9C: {
                    self().visit_F64Floor();
                    break;
                }
                case 0x9D: {
                    self().visit_F64Trunc();
                    break;
                }
                case 0x9E: {
                    self().visit_F64Nearest();
                    break;
                }
                case 0x9F: {
                    self().visit_F64Sqrt();
                    break;
                }
                case 0xA0: {
                    self().visit_F64Add();
                    break;
                }
                case 0xA1: {
                    self().visit_F64Sub();
                    break;
                }
                case 0xA2: {
                    self().visit_F64Mul();
                    break;
                }
                case 0xA3: {
                    self().visit_F64Div();
                    break;
                }
                case 0xA4: {
                    self().visit_F64Min();
                    break;
                }
                case 0xA5: {
                    self().visit_F64Max();
                    break;
                }
                case 0xA6: {
                    self().visit_F64Copysign();
                    break;
                }
                case 0xA7: {
                    self().visit_I32WrapI64();
                    break;
                }
                case 0xA8: {
                    self().visit_I32TruncF32S();
                    break;
                }
                case 0xA9: {
                    self().visit_I32TruncF32U();
                    break;
                }
                case 0xAA: {
                    self().visit_I32TruncF64S();
                    break;
                }
                case 0xAB: {
                    self().visit_I32TruncF64U();
                    break;
                }
                case 0xAC: {
                    self().visit_I64ExtendI32S();
                    break;
                }
                case 0xAD: {
                    self().visit_I64ExtendI32U();
                    break;
                }
                case 0xAE: {
                    self().visit_I64TruncF32S();
                    break;
                }
                case 0xAF: {
                    self().visit_I64TruncF32U();
                    break;
                }
                case 0xB0: {
                    self().visit_I64TruncF64S();
                    break;
                }
                case 0xB1: {
                    self().visit_I64TruncF64U();
                    break;
                }
                case 0xB2: {
                    self().visit_F32ConvertI32S();
                    break;
                }
                case 0xB3: {
                    self().visit_F32ConvertI32U();
                    break;
                }
                case 0xB4: {
                    self().visit_F32ConvertI64S();
                    break;
                }
                case 0xB5: {
                    self().visit_F32ConvertI64U();
                    break;
                }
                case 0xB6: {
                    self().visit_F32DemoteF64();
                    break;
                }
                case 0xB7: {
                    self().visit_F64ConvertI32S();
                    break;
                }
                case 0xB8: {
                    self().visit_F64ConvertI32U();
                    break;
                }
                case 0xB9: {
                    self().visit_F64ConvertI64S();
                    break;
                }
                case 0xBA: {
                    self().visit_F64ConvertI64U();
                    break;
                }
                case 0xBB: {
                    self().visit_F64PromoteF32();
                    break;
                }
                case 0xBC: {
                    self().visit_I32ReinterpretF32();
                    break;
                }
                case 0xBD: {
                    self().visit_I64ReinterpretF64();
                    break;
                }
                case 0xBE: {
                    self().visit_F32ReinterpretI32();
                    break;
                }
                case 0xBF: {
                    self().visit_F64ReinterpretI64();
                    break;
                }
                case 0xC0: {
                    self().visit_I32Extend8S();
                    break;
                }
                case 0xC1: {
                    self().visit_I32Extend16S();
                    break;
                }
                case 0xC2: {
                    self().visit_I64Extend8S();
                    break;
                }
                case 0xC3: {
                    self().visit_I64Extend16S();
                    break;
                }
                case 0xC4: {
                    self().visit_I64Extend32S();
                    break;
                }
                case 0xFC: {
                    uint32_t num = wasm::read_u32(code, offset);
                    switch(num) {
                        case 12U: {
                            uint32_t elemidx = wasm::read_u32(code, offset);
                            uint32_t tableidx = wasm::read_u32(code, offset);
                            self().visit_TableInit(elemidx, tableidx);
                            break;
                        }
                        case 13U: {
                            uint32_t elemidx = wasm::read_u32(code, offset);
                            self().visit_ElemDrop(elemidx);
                            break;
                        }
                        case 14U: {
                            uint32_t des_tableidx = wasm::read_u32(code, offset);
                            uint32_t src_tableidx = wasm::read_u32(code, offset);
                            self().visit_TableCopy(des_tableidx, src_tableidx);
                            break;
                        }
                        case 15U: {
                            uint32_t tableidx = wasm::read_u32(code, offset);
                            self().visit_TableGrow(tableidx);
                            break;
                        }
                        case 16U: {
                            uint32_t tableidx = wasm::read_u32(code, offset);
                            self().visit_TableSize(tableidx);
                            break;
                        }
                        case 17U: {
                            uint32_t tableidx = wasm::read_u32(code, offset);
                            self().visit_TableFill(tableidx);
                            break;
                        }
                        case 9U: {
                            uint32_t dataidx = wasm::read_u32(code, offset);
                            self().visit_DataDrop(dataidx);
                            break;
                        }
                        case 0U: {
                            self().visit_I32TruncSatF32S();
                            break;
                        }
                        case 1U: {
                            self().visit_I32TruncSatF32U();
                            break;
                        }
                        case 2U: {
                            self().visit_I32TruncSatF64S();
                            break;
                        }
                        case 3U: {
                            self().visit_I32TruncSatF64U();
                            break;
                        }
                        case 4U: {
                            self().visit_I64TruncSatF32S();
                            break;
                        }
                        case 5U: {
                            self().visit_I64TruncSatF32U();
                            break;
                        }
                        case 6U: {
                            self().visit_I64TruncSatF64S();
                            break;
                        }
                        case 7U: {
                            self().visit_I64TruncSatF64U();
                            break;
                        }
                        default: {
                            throw LCompilersException("Unknown num for opcode 0xFC");
                        }
                    }
                    break;
                }
                case 0xFD: {
                    uint32_t num = wasm::read_u32(code, offset);
                    switch(num) {
                        case 0U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load(mem_align, mem_offset);
                            break;
                        }
                        case 1U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load8x8S(mem_align, mem_offset);
                            break;
                        }
                        case 2U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load8x8U(mem_align, mem_offset);
                            break;
                        }
                        case 3U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load16x4S(mem_align, mem_offset);
                            break;
                        }
                        case 4U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load16x4U(mem_align, mem_offset);
                            break;
                        }
                        case 5U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load32x2S(mem_align, mem_offset);
                            break;
                        }
                        case 6U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load32x2U(mem_align, mem_offset);
                            break;
                        }
                        case 7U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load8Splat(mem_align, mem_offset);
                            break;
                        }
                        case 8U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load16Splat(mem_align, mem_offset);
                            break;
                        }
                        case 9U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load32Splat(mem_align, mem_offset);
                            break;
                        }
                        case 10U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load64Splat(mem_align, mem_offset);
                            break;
                        }
                        case 92U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load32Zero(mem_align, mem_offset);
                            break;
                        }
                        case 93U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Load64Zero(mem_align, mem_offset);
                            break;
                        }
                        case 11U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            self().visit_V128Store(mem_align, mem_offset);
                            break;
                        }
                        case 84U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Load8Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 85U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Load16Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 86U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Load32Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 87U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Load64Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 88U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Store8Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 89U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Store16Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 90U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Store32Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 91U: {
                            uint32_t mem_align = wasm::read_u32(code, offset);
                            uint32_t mem_offset = wasm::read_u32(code, offset);
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_V128Store64Lane(mem_align, mem_offset, laneidx);
                            break;
                        }
                        case 21U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I8x16ExtractLaneS(laneidx);
                            break;
                        }
                        case 22U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I8x16ExtractLaneU(laneidx);
                            break;
                        }
                        case 23U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I8x16ReplaceLane(laneidx);
                            break;
                        }
                        case 24U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I16x8ExtractLaneS(laneidx);
                            break;
                        }
                        case 25U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I16x8ExtractLaneU(laneidx);
                            break;
                        }
                        case 26U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I16x8ReplaceLane(laneidx);
                            break;
                        }
                        case 27U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I32x4ExtractLane(laneidx);
                            break;
                        }
                        case 28U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I32x4ReplaceLane(laneidx);
                            break;
                        }
                        case 29U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I64x2ExtractLane(laneidx);
                            break;
                        }
                        case 30U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_I64x2ReplaceLane(laneidx);
                            break;
                        }
                        case 31U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_F32x4ExtractLane(laneidx);
                            break;
                        }
                        case 32U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_F32x4ReplaceLane(laneidx);
                            break;
                        }
                        case 33U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_F64x2ExtractLane(laneidx);
                            break;
                        }
                        case 34U: {
                            uint8_t laneidx = wasm::read_b8(code, offset);
                            self().visit_F64x2ReplaceLane(laneidx);
                            break;
                        }
                        case 14U: {
                            self().visit_I8x16Swizzle();
                            break;
                        }
                        case 15U: {
                            self().visit_I8x16Splat();
                            break;
                        }
                        case 16U: {
                            self().visit_I16x8Splat();
                            break;
                        }
                        case 17U: {
                            self().visit_I32x4Splat();
                            break;
                        }
                        case 18U: {
                            self().visit_I64x2Splat();
                            break;
                        }
                        case 19U: {
                            self().visit_F32x4Splat();
                            break;
                        }
                        case 20U: {
                            self().visit_F64x2Splat();
                            break;
                        }
                        case 35U: {
                            self().visit_I8x16Eq();
                            break;
                        }
                        case 36U: {
                            self().visit_I8x16Ne();
                            break;
                        }
                        case 37U: {
                            self().visit_I8x16LtS();
                            break;
                        }
                        case 38U: {
                            self().visit_I8x16LtU();
                            break;
                        }
                        case 39U: {
                            self().visit_I8x16GtS();
                            break;
                        }
                        case 40U: {
                            self().visit_I8x16GtU();
                            break;
                        }
                        case 41U: {
                            self().visit_I8x16LeS();
                            break;
                        }
                        case 42U: {
                            self().visit_I8x16LeU();
                            break;
                        }
                        case 43U: {
                            self().visit_I8x16GeS();
                            break;
                        }
                        case 44U: {
                            self().visit_I8x16GeU();
                            break;
                        }
                        case 45U: {
                            self().visit_I16x8Eq();
                            break;
                        }
                        case 46U: {
                            self().visit_I16x8Ne();
                            break;
                        }
                        case 47U: {
                            self().visit_I16x8LtS();
                            break;
                        }
                        case 48U: {
                            self().visit_I16x8LtU();
                            break;
                        }
                        case 49U: {
                            self().visit_I16x8GtS();
                            break;
                        }
                        case 50U: {
                            self().visit_I16x8GtU();
                            break;
                        }
                        case 51U: {
                            self().visit_I16x8LeS();
                            break;
                        }
                        case 52U: {
                            self().visit_I16x8LeU();
                            break;
                        }
                        case 53U: {
                            self().visit_I16x8GeS();
                            break;
                        }
                        case 54U: {
                            self().visit_I16x8GeU();
                            break;
                        }
                        case 55U: {
                            self().visit_I32x4Eq();
                            break;
                        }
                        case 56U: {
                            self().visit_I32x4Ne();
                            break;
                        }
                        case 57U: {
                            self().visit_I32x4LtS();
                            break;
                        }
                        case 58U: {
                            self().visit_I32x4LtU();
                            break;
                        }
                        case 59U: {
                            self().visit_I32x4GtS();
                            break;
                        }
                        case 60U: {
                            self().visit_I32x4GtU();
                            break;
                        }
                        case 61U: {
                            self().visit_I32x4LeS();
                            break;
                        }
                        case 62U: {
                            self().visit_I32x4LeU();
                            break;
                        }
                        case 63U: {
                            self().visit_I32x4GeS();
                            break;
                        }
                        case 64U: {
                            self().visit_I32x4GeU();
                            break;
                        }
                        case 214U: {
                            self().visit_I64x2Eq();
                            break;
                        }
                        case 215U: {
                            self().visit_I64x2Ne();
                            break;
                        }
                        case 216U: {
                            self().visit_I64x2LtS();
                            break;
                        }
                        case 217U: {
                            self().visit_I64x2GtS();
                            break;
                        }
                        case 218U: {
                            self().visit_I64x2LeS();
                            break;
                        }
                        case 219U: {
                            self().visit_I64x2GeS();
                            break;
                        }
                        case 65U: {
                            self().visit_F32x4Eq();
                            break;
                        }
                        case 66U: {
                            self().visit_F32x4Ne();
                            break;
                        }
                        case 67U: {
                            self().visit_F32x4Lt();
                            break;
                        }
                        case 68U: {
                            self().visit_F32x4Gt();
                            break;
                        }
                        case 69U: {
                            self().visit_F32x4Le();
                            break;
                        }
                        case 70U: {
                            self().visit_F32x4Ge();
                            break;
                        }
                        case 71U: {
                            self().visit_F64x2Eq();
                            break;
                        }
                        case 72U: {
                            self().visit_F64x2Ne();
                            break;
                        }
                        case 73U: {
                            self().visit_F64x2Lt();
                            break;
                        }
                        case 74U: {
                            self().visit_F64x2Gt();
                            break;
                        }
                        case 75U: {
                            self().visit_F64x2Le();
                            break;
                        }
                        case 76U: {
                            self().visit_F64x2Ge();
                            break;
                        }
                        case 77U: {
                            self().visit_V128Not();
                            break;
                        }
                        case 78U: {
                            self().visit_V128And();
                            break;
                        }
                        case 79U: {
                            self().visit_V128Andnot();
                            break;
                        }
                        case 80U: {
                            self().visit_V128Or();
                            break;
                        }
                        case 81U: {
                            self().visit_V128Xor();
                            break;
                        }
                        case 82U: {
                            self().visit_V128Bitselect();
                            break;
                        }
                        case 83U: {
                            self().visit_V128AnyTrue();
                            break;
                        }
                        case 96U: {
                            self().visit_I8x16Abs();
                            break;
                        }
                        case 97U: {
                            self().visit_I8x16Neg();
                            break;
                        }
                        case 98U: {
                            self().visit_I8x16Popcnt();
                            break;
                        }
                        case 99U: {
                            self().visit_I8x16AllTrue();
                            break;
                        }
                        case 100U: {
                            self().visit_I8x16Bitmask();
                            break;
                        }
                        case 101U: {
                            self().visit_I8x16NarrowI16x8S();
                            break;
                        }
                        case 102U: {
                            self().visit_I8x16NarrowI16x8U();
                            break;
                        }
                        case 107U: {
                            self().visit_I8x16Shl();
                            break;
                        }
                        case 108U: {
                            self().visit_I8x16ShrS();
                            break;
                        }
                        case 109U: {
                            self().visit_I8x16ShrU();
                            break;
                        }
                        case 110U: {
                            self().visit_I8x16Add();
                            break;
                        }
                        case 111U: {
                            self().visit_I8x16AddSatS();
                            break;
                        }
                        case 112U: {
                            self().visit_I8x16AddSatU();
                            break;
                        }
                        case 113U: {
                            self().visit_I8x16Sub();
                            break;
                        }
                        case 114U: {
                            self().visit_I8x16SubSatS();
                            break;
                        }
                        case 115U: {
                            self().visit_I8x16SubSatU();
                            break;
                        }
                        case 118U: {
                            self().visit_I8x16MinS();
                            break;
                        }
                        case 119U: {
                            self().visit_I8x16MinU();
                            break;
                        }
                        case 120U: {
                            self().visit_I8x16MaxS();
                            break;
                        }
                        case 121U: {
                            self().visit_I8x16MaxU();
                            break;
                        }
                        case 123U: {
                            self().visit_I8x16AvgrU();
                            break;
                        }
                        case 124U: {
                            self().visit_I16x8ExtaddPairwiseI8x16S();
                            break;
                        }
                        case 125U: {
                            self().visit_I16x8ExtaddPairwiseI8x16U();
                            break;
                        }
                        case 128U: {
                            self().visit_I16x8Abs();
                            break;
                        }
                        case 129U: {
                            self().visit_I16x8Neg();
                            break;
                        }
                        case 130U: {
                            self().visit_I16x8Q15mulrSatS();
                            break;
                        }
                        case 131U: {
                            self().visit_I16x8AllTrue();
                            break;
                        }
                        case 132U: {
                            self().visit_I16x8Bitmask();
                            break;
                        }
                        case 133U: {
                            self().visit_I16x8NarrowI32x4S();
                            break;
                        }
                        case 134U: {
                            self().visit_I16x8NarrowI32x4U();
                            break;
                        }
                        case 135U: {
                            self().visit_I16x8ExtendLowI8x16S();
                            break;
                        }
                        case 136U: {
                            self().visit_I16x8ExtendHighI8x16S();
                            break;
                        }
                        case 137U: {
                            self().visit_I16x8ExtendLowI8x16U();
                            break;
                        }
                        case 138U: {
                            self().visit_I16x8ExtendHighI8x16U();
                            break;
                        }
                        case 139U: {
                            self().visit_I16x8Shl();
                            break;
                        }
                        case 140U: {
                            self().visit_I16x8ShrS();
                            break;
                        }
                        case 141U: {
                            self().visit_I16x8ShrU();
                            break;
                        }
                        case 142U: {
                            self().visit_I16x8Add();
                            break;
                        }
                        case 143U: {
                            self().visit_I16x8AddSatS();
                            break;
                        }
                        case 144U: {
                            self().visit_I16x8AddSatU();
                            break;
                        }
                        case 145U: {
                            self().visit_I16x8Sub();
                            break;
                        }
                        case 146U: {
                            self().visit_I16x8SubSatS();
                            break;
                        }
                        case 147U: {
                            self().visit_I16x8SubSatU();
                            break;
                        }
                        case 149U: {
                            self().visit_I16x8Mul();
                            break;
                        }
                        case 150U: {
                            self().visit_I16x8MinS();
                            break;
                        }
                        case 151U: {
                            self().visit_I16x8MinU();
                            break;
                        }
                        case 152U: {
                            self().visit_I16x8MaxS();
                            break;
                        }
                        case 153U: {
                            self().visit_I16x8MaxU();
                            break;
                        }
                        case 155U: {
                            self().visit_I16x8AvgrU();
                            break;
                        }
                        case 156U: {
                            self().visit_I16x8ExtmulLowI8x16S();
                            break;
                        }
                        case 157U: {
                            self().visit_I16x8ExtmulHighI8x16S();
                            break;
                        }
                        case 158U: {
                            self().visit_I16x8ExtmulLowI8x16U();
                            break;
                        }
                        case 159U: {
                            self().visit_I16x8ExtmulHighI8x16U();
                            break;
                        }
                        case 126U: {
                            self().visit_I32x4ExtaddPairwiseI16x8S();
                            break;
                        }
                        case 127U: {
                            self().visit_I32x4ExtaddPairwiseI16x8U();
                            break;
                        }
                        case 160U: {
                            self().visit_I32x4Abs();
                            break;
                        }
                        case 161U: {
                            self().visit_I32x4Neg();
                            break;
                        }
                        case 163U: {
                            self().visit_I32x4AllTrue();
                            break;
                        }
                        case 164U: {
                            self().visit_I32x4Bitmask();
                            break;
                        }
                        case 167U: {
                            self().visit_I32x4ExtendLowI16x8S();
                            break;
                        }
                        case 168U: {
                            self().visit_I32x4ExtendHighI16x8S();
                            break;
                        }
                        case 169U: {
                            self().visit_I32x4ExtendLowI16x8U();
                            break;
                        }
                        case 170U: {
                            self().visit_I32x4ExtendHighI16x8U();
                            break;
                        }
                        case 171U: {
                            self().visit_I32x4Shl();
                            break;
                        }
                        case 172U: {
                            self().visit_I32x4ShrS();
                            break;
                        }
                        case 173U: {
                            self().visit_I32x4ShrU();
                            break;
                        }
                        case 174U: {
                            self().visit_I32x4Add();
                            break;
                        }
                        case 177U: {
                            self().visit_I32x4Sub();
                            break;
                        }
                        case 181U: {
                            self().visit_I32x4Mul();
                            break;
                        }
                        case 182U: {
                            self().visit_I32x4MinS();
                            break;
                        }
                        case 183U: {
                            self().visit_I32x4MinU();
                            break;
                        }
                        case 184U: {
                            self().visit_I32x4MaxS();
                            break;
                        }
                        case 185U: {
                            self().visit_I32x4MaxU();
                            break;
                        }
                        case 186U: {
                            self().visit_I32x4DotI16x8S();
                            break;
                        }
                        case 188U: {
                            self().visit_I32x4ExtmulLowI16x8S();
                            break;
                        }
                        case 189U: {
                            self().visit_I32x4ExtmulHighI16x8S();
                            break;
                        }
                        case 190U: {
                            self().visit_I32x4ExtmulLowI16x8U();
                            break;
                        }
                        case 191U: {
                            self().visit_I32x4ExtmulHighI16x8U();
                            break;
                        }
                        case 192U: {
                            self().visit_I64x2Abs();
                            break;
                        }
                        case 193U: {
                            self().visit_I64x2Neg();
                            break;
                        }
                        case 195U: {
                            self().visit_I64x2AllTrue();
                            break;
                        }
                        case 196U: {
                            self().visit_I64x2Bitmask();
                            break;
                        }
                        case 199U: {
                            self().visit_I64x2ExtendLowI32x4S();
                            break;
                        }
                        case 200U: {
                            self().visit_I64x2ExtendHighI32x4S();
                            break;
                        }
                        case 201U: {
                            self().visit_I64x2ExtendLowI32x4U();
                            break;
                        }
                        case 202U: {
                            self().visit_I64x2ExtendHighI32x4U();
                            break;
                        }
                        case 203U: {
                            self().visit_I64x2Shl();
                            break;
                        }
                        case 204U: {
                            self().visit_I64x2ShrS();
                            break;
                        }
                        case 205U: {
                            self().visit_I64x2ShrU();
                            break;
                        }
                        case 206U: {
                            self().visit_I64x2Add();
                            break;
                        }
                        case 209U: {
                            self().visit_I64x2Sub();
                            break;
                        }
                        case 213U: {
                            self().visit_I64x2Mul();
                            break;
                        }
                        case 220U: {
                            self().visit_I64x2ExtmulLowI32x4S();
                            break;
                        }
                        case 221U: {
                            self().visit_I64x2ExtmulHighI32x4S();
                            break;
                        }
                        case 222U: {
                            self().visit_I64x2ExtmulLowI32x4U();
                            break;
                        }
                        case 223U: {
                            self().visit_I64x2ExtmulHighI32x4U();
                            break;
                        }
                        case 103U: {
                            self().visit_F32x4Ceil();
                            break;
                        }
                        case 104U: {
                            self().visit_F32x4Floor();
                            break;
                        }
                        case 105U: {
                            self().visit_F32x4Trunc();
                            break;
                        }
                        case 106U: {
                            self().visit_F32x4Nearest();
                            break;
                        }
                        case 224U: {
                            self().visit_F32x4Abs();
                            break;
                        }
                        case 225U: {
                            self().visit_F32x4Neg();
                            break;
                        }
                        case 227U: {
                            self().visit_F32x4Sqrt();
                            break;
                        }
                        case 228U: {
                            self().visit_F32x4Add();
                            break;
                        }
                        case 229U: {
                            self().visit_F32x4Sub();
                            break;
                        }
                        case 230U: {
                            self().visit_F32x4Mul();
                            break;
                        }
                        case 231U: {
                            self().visit_F32x4Div();
                            break;
                        }
                        case 232U: {
                            self().visit_F32x4Min();
                            break;
                        }
                        case 233U: {
                            self().visit_F32x4Max();
                            break;
                        }
                        case 234U: {
                            self().visit_F32x4Pmin();
                            break;
                        }
                        case 235U: {
                            self().visit_F32x4Pmax();
                            break;
                        }
                        case 116U: {
                            self().visit_F64x2Ceil();
                            break;
                        }
                        case 117U: {
                            self().visit_F64x2Floor();
                            break;
                        }
                        case 122U: {
                            self().visit_F64x2Trunc();
                            break;
                        }
                        case 148U: {
                            self().visit_F64x2Nearest();
                            break;
                        }
                        case 236U: {
                            self().visit_F64x2Abs();
                            break;
                        }
                        case 237U: {
                            self().visit_F64x2Neg();
                            break;
                        }
                        case 239U: {
                            self().visit_F64x2Sqrt();
                            break;
                        }
                        case 240U: {
                            self().visit_F64x2Add();
                            break;
                        }
                        case 241U: {
                            self().visit_F64x2Sub();
                            break;
                        }
                        case 242U: {
                            self().visit_F64x2Mul();
                            break;
                        }
                        case 243U: {
                            self().visit_F64x2Div();
                            break;
                        }
                        case 244U: {
                            self().visit_F64x2Min();
                            break;
                        }
                        case 245U: {
                            self().visit_F64x2Max();
                            break;
                        }
                        case 246U: {
                            self().visit_F64x2Pmin();
                            break;
                        }
                        case 247U: {
                            self().visit_F64x2Pmax();
                            break;
                        }
                        case 248U: {
                            self().visit_I32x4TruncSatF32x4S();
                            break;
                        }
                        case 249U: {
                            self().visit_I32x4TruncSatF32x4U();
                            break;
                        }
                        case 250U: {
                            self().visit_F32x4ConvertI32x4S();
                            break;
                        }
                        case 251U: {
                            self().visit_F32x4ConvertI32x4U();
                            break;
                        }
                        case 252U: {
                            self().visit_I32x4TruncSatF64x2SZero();
                            break;
                        }
                        case 253U: {
                            self().visit_I32x4TruncSatF64x2UZero();
                            break;
                        }
                        case 254U: {
                            self().visit_F64x2ConvertLowI32x4S();
                            break;
                        }
                        case 255U: {
                            self().visit_F64x2ConvertLowI32x4U();
                            break;
                        }
                        case 94U: {
                            self().visit_F32x4DemoteF64x2Zero();
                            break;
                        }
                        case 95U: {
                            self().visit_F64x2PromoteLowF32x4();
                            break;
                        }
                        default: {
                            throw LCompilersException("Unknown num for opcode 0xFD");
                        }
                    }
                    break;
                }
                default: {
                    throw LCompilersException("Unknown opcode");
                }
            }
            cur_byte = wasm::read_b8(code, offset);
        }
    }
};

template <class StructType>
class WASMInstsAssembler {
private:
    Allocator &m_al;
    Vec<uint8_t> &m_code;

    StructType &self() { return static_cast<StructType &>(*this); }
public:
    WASMInstsAssembler(Allocator &al, Vec<uint8_t> &code): m_al(al), m_code(code) {}

    void emit_emtpy_block_type() {
        m_code.push_back(m_al, 0x40);
    }

    void emit_unreachable() {
        m_code.push_back(m_al, 0x00);
    }

    void emit_nop() {
        m_code.push_back(m_al, 0x01);
    }

    void emit_loop() {
        m_code.push_back(m_al, 0x03);
    }

    void emit_if() {
        m_code.push_back(m_al, 0x04);
    }

    void emit_else() {
        m_code.push_back(m_al, 0x05);
    }

    void emit_br(uint32_t labelidx) {
        m_code.push_back(m_al, 0x0C);
        wasm::emit_u32(m_code, m_al, labelidx);
    }

    void emit_br_if(uint32_t labelidx) {
        m_code.push_back(m_al, 0x0D);
        wasm::emit_u32(m_code, m_al, labelidx);
    }

    void emit_return() {
        m_code.push_back(m_al, 0x0F);
    }

    void emit_call(uint32_t funcidx) {
        m_code.push_back(m_al, 0x10);
        wasm::emit_u32(m_code, m_al, funcidx);
    }

    void emit_call_indirect(uint32_t typeidx, uint32_t tableidx) {
        m_code.push_back(m_al, 0x11);
        wasm::emit_u32(m_code, m_al, typeidx);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_ref_null(uint8_t reftype) {
        m_code.push_back(m_al, 0xD0);
        wasm::emit_b8(m_code, m_al, reftype);
    }

    void emit_ref_is_null() {
        m_code.push_back(m_al, 0xD1);
    }

    void emit_ref_func(uint32_t funcidx) {
        m_code.push_back(m_al, 0xD2);
        wasm::emit_u32(m_code, m_al, funcidx);
    }

    void emit_drop() {
        m_code.push_back(m_al, 0x1A);
    }

    void emit_select() {
        m_code.push_back(m_al, 0x1B);
    }

    void emit_local_get(uint32_t localidx) {
        m_code.push_back(m_al, 0x20);
        wasm::emit_u32(m_code, m_al, localidx);
    }

    void emit_local_set(uint32_t localidx) {
        m_code.push_back(m_al, 0x21);
        wasm::emit_u32(m_code, m_al, localidx);
    }

    void emit_local_tee(uint32_t localidx) {
        m_code.push_back(m_al, 0x22);
        wasm::emit_u32(m_code, m_al, localidx);
    }

    void emit_global_get(uint32_t globalidx) {
        m_code.push_back(m_al, 0x23);
        wasm::emit_u32(m_code, m_al, globalidx);
    }

    void emit_global_set(uint32_t globalidx) {
        m_code.push_back(m_al, 0x24);
        wasm::emit_u32(m_code, m_al, globalidx);
    }

    void emit_table_get(uint32_t tableidx) {
        m_code.push_back(m_al, 0x25);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_table_set(uint32_t tableidx) {
        m_code.push_back(m_al, 0x26);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_i32_load(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x28);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x29);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_f32_load(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2A);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_f64_load(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2B);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_load8_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2C);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_load8_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2D);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_load16_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2E);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_load16_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x2F);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load8_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x30);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load8_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x31);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load16_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x32);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load16_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x33);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load32_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x34);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_load32_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x35);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_store(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x36);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_store(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x37);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_f32_store(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x38);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_f64_store(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x39);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_store8(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x3A);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_store16(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x3B);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_store8(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x3C);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_store16(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x3D);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i64_store32(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0x3E);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_i32_const(int32_t n) {
        m_code.push_back(m_al, 0x41);
        wasm::emit_i32(m_code, m_al, n);
    }

    void emit_i64_const(int64_t n) {
        m_code.push_back(m_al, 0x42);
        wasm::emit_i64(m_code, m_al, n);
    }

    void emit_f32_const(float z) {
        m_code.push_back(m_al, 0x43);
        wasm::emit_f32(m_code, m_al, z);
    }

    void emit_f64_const(double z) {
        m_code.push_back(m_al, 0x44);
        wasm::emit_f64(m_code, m_al, z);
    }

    void emit_i32_eqz() {
        m_code.push_back(m_al, 0x45);
    }

    void emit_i32_eq() {
        m_code.push_back(m_al, 0x46);
    }

    void emit_i32_ne() {
        m_code.push_back(m_al, 0x47);
    }

    void emit_i32_lt_s() {
        m_code.push_back(m_al, 0x48);
    }

    void emit_i32_lt_u() {
        m_code.push_back(m_al, 0x49);
    }

    void emit_i32_gt_s() {
        m_code.push_back(m_al, 0x4A);
    }

    void emit_i32_gt_u() {
        m_code.push_back(m_al, 0x4B);
    }

    void emit_i32_le_s() {
        m_code.push_back(m_al, 0x4C);
    }

    void emit_i32_le_u() {
        m_code.push_back(m_al, 0x4D);
    }

    void emit_i32_ge_s() {
        m_code.push_back(m_al, 0x4E);
    }

    void emit_i32_ge_u() {
        m_code.push_back(m_al, 0x4F);
    }

    void emit_i64_eqz() {
        m_code.push_back(m_al, 0x50);
    }

    void emit_i64_eq() {
        m_code.push_back(m_al, 0x51);
    }

    void emit_i64_ne() {
        m_code.push_back(m_al, 0x52);
    }

    void emit_i64_lt_s() {
        m_code.push_back(m_al, 0x53);
    }

    void emit_i64_lt_u() {
        m_code.push_back(m_al, 0x54);
    }

    void emit_i64_gt_s() {
        m_code.push_back(m_al, 0x55);
    }

    void emit_i64_gt_u() {
        m_code.push_back(m_al, 0x56);
    }

    void emit_i64_le_s() {
        m_code.push_back(m_al, 0x57);
    }

    void emit_i64_le_u() {
        m_code.push_back(m_al, 0x58);
    }

    void emit_i64_ge_s() {
        m_code.push_back(m_al, 0x59);
    }

    void emit_i64_ge_u() {
        m_code.push_back(m_al, 0x5A);
    }

    void emit_f32_eq() {
        m_code.push_back(m_al, 0x5B);
    }

    void emit_f32_ne() {
        m_code.push_back(m_al, 0x5C);
    }

    void emit_f32_lt() {
        m_code.push_back(m_al, 0x5D);
    }

    void emit_f32_gt() {
        m_code.push_back(m_al, 0x5E);
    }

    void emit_f32_le() {
        m_code.push_back(m_al, 0x5F);
    }

    void emit_f32_ge() {
        m_code.push_back(m_al, 0x60);
    }

    void emit_f64_eq() {
        m_code.push_back(m_al, 0x61);
    }

    void emit_f64_ne() {
        m_code.push_back(m_al, 0x62);
    }

    void emit_f64_lt() {
        m_code.push_back(m_al, 0x63);
    }

    void emit_f64_gt() {
        m_code.push_back(m_al, 0x64);
    }

    void emit_f64_le() {
        m_code.push_back(m_al, 0x65);
    }

    void emit_f64_ge() {
        m_code.push_back(m_al, 0x66);
    }

    void emit_i32_clz() {
        m_code.push_back(m_al, 0x67);
    }

    void emit_i32_ctz() {
        m_code.push_back(m_al, 0x68);
    }

    void emit_i32_popcnt() {
        m_code.push_back(m_al, 0x69);
    }

    void emit_i32_add() {
        m_code.push_back(m_al, 0x6A);
    }

    void emit_i32_sub() {
        m_code.push_back(m_al, 0x6B);
    }

    void emit_i32_mul() {
        m_code.push_back(m_al, 0x6C);
    }

    void emit_i32_div_s() {
        m_code.push_back(m_al, 0x6D);
    }

    void emit_i32_div_u() {
        m_code.push_back(m_al, 0x6E);
    }

    void emit_i32_rem_s() {
        m_code.push_back(m_al, 0x6F);
    }

    void emit_i32_rem_u() {
        m_code.push_back(m_al, 0x70);
    }

    void emit_i32_and() {
        m_code.push_back(m_al, 0x71);
    }

    void emit_i32_or() {
        m_code.push_back(m_al, 0x72);
    }

    void emit_i32_xor() {
        m_code.push_back(m_al, 0x73);
    }

    void emit_i32_shl() {
        m_code.push_back(m_al, 0x74);
    }

    void emit_i32_shr_s() {
        m_code.push_back(m_al, 0x75);
    }

    void emit_i32_shr_u() {
        m_code.push_back(m_al, 0x76);
    }

    void emit_i32_rotl() {
        m_code.push_back(m_al, 0x77);
    }

    void emit_i32_rotr() {
        m_code.push_back(m_al, 0x78);
    }

    void emit_i64_clz() {
        m_code.push_back(m_al, 0x79);
    }

    void emit_i64_ctz() {
        m_code.push_back(m_al, 0x7A);
    }

    void emit_i64_popcnt() {
        m_code.push_back(m_al, 0x7B);
    }

    void emit_i64_add() {
        m_code.push_back(m_al, 0x7C);
    }

    void emit_i64_sub() {
        m_code.push_back(m_al, 0x7D);
    }

    void emit_i64_mul() {
        m_code.push_back(m_al, 0x7E);
    }

    void emit_i64_div_s() {
        m_code.push_back(m_al, 0x7F);
    }

    void emit_i64_div_u() {
        m_code.push_back(m_al, 0x80);
    }

    void emit_i64_rem_s() {
        m_code.push_back(m_al, 0x81);
    }

    void emit_i64_rem_u() {
        m_code.push_back(m_al, 0x82);
    }

    void emit_i64_and() {
        m_code.push_back(m_al, 0x83);
    }

    void emit_i64_or() {
        m_code.push_back(m_al, 0x84);
    }

    void emit_i64_xor() {
        m_code.push_back(m_al, 0x85);
    }

    void emit_i64_shl() {
        m_code.push_back(m_al, 0x86);
    }

    void emit_i64_shr_s() {
        m_code.push_back(m_al, 0x87);
    }

    void emit_i64_shr_u() {
        m_code.push_back(m_al, 0x88);
    }

    void emit_i64_rotl() {
        m_code.push_back(m_al, 0x89);
    }

    void emit_i64_rotr() {
        m_code.push_back(m_al, 0x8A);
    }

    void emit_f32_abs() {
        m_code.push_back(m_al, 0x8B);
    }

    void emit_f32_neg() {
        m_code.push_back(m_al, 0x8C);
    }

    void emit_f32_ceil() {
        m_code.push_back(m_al, 0x8D);
    }

    void emit_f32_floor() {
        m_code.push_back(m_al, 0x8E);
    }

    void emit_f32_trunc() {
        m_code.push_back(m_al, 0x8F);
    }

    void emit_f32_nearest() {
        m_code.push_back(m_al, 0x90);
    }

    void emit_f32_sqrt() {
        m_code.push_back(m_al, 0x91);
    }

    void emit_f32_add() {
        m_code.push_back(m_al, 0x92);
    }

    void emit_f32_sub() {
        m_code.push_back(m_al, 0x93);
    }

    void emit_f32_mul() {
        m_code.push_back(m_al, 0x94);
    }

    void emit_f32_div() {
        m_code.push_back(m_al, 0x95);
    }

    void emit_f32_min() {
        m_code.push_back(m_al, 0x96);
    }

    void emit_f32_max() {
        m_code.push_back(m_al, 0x97);
    }

    void emit_f32_copysign() {
        m_code.push_back(m_al, 0x98);
    }

    void emit_f64_abs() {
        m_code.push_back(m_al, 0x99);
    }

    void emit_f64_neg() {
        m_code.push_back(m_al, 0x9A);
    }

    void emit_f64_ceil() {
        m_code.push_back(m_al, 0x9B);
    }

    void emit_f64_floor() {
        m_code.push_back(m_al, 0x9C);
    }

    void emit_f64_trunc() {
        m_code.push_back(m_al, 0x9D);
    }

    void emit_f64_nearest() {
        m_code.push_back(m_al, 0x9E);
    }

    void emit_f64_sqrt() {
        m_code.push_back(m_al, 0x9F);
    }

    void emit_f64_add() {
        m_code.push_back(m_al, 0xA0);
    }

    void emit_f64_sub() {
        m_code.push_back(m_al, 0xA1);
    }

    void emit_f64_mul() {
        m_code.push_back(m_al, 0xA2);
    }

    void emit_f64_div() {
        m_code.push_back(m_al, 0xA3);
    }

    void emit_f64_min() {
        m_code.push_back(m_al, 0xA4);
    }

    void emit_f64_max() {
        m_code.push_back(m_al, 0xA5);
    }

    void emit_f64_copysign() {
        m_code.push_back(m_al, 0xA6);
    }

    void emit_i32_wrap_i64() {
        m_code.push_back(m_al, 0xA7);
    }

    void emit_i32_trunc_f32_s() {
        m_code.push_back(m_al, 0xA8);
    }

    void emit_i32_trunc_f32_u() {
        m_code.push_back(m_al, 0xA9);
    }

    void emit_i32_trunc_f64_s() {
        m_code.push_back(m_al, 0xAA);
    }

    void emit_i32_trunc_f64_u() {
        m_code.push_back(m_al, 0xAB);
    }

    void emit_i64_extend_i32_s() {
        m_code.push_back(m_al, 0xAC);
    }

    void emit_i64_extend_i32_u() {
        m_code.push_back(m_al, 0xAD);
    }

    void emit_i64_trunc_f32_s() {
        m_code.push_back(m_al, 0xAE);
    }

    void emit_i64_trunc_f32_u() {
        m_code.push_back(m_al, 0xAF);
    }

    void emit_i64_trunc_f64_s() {
        m_code.push_back(m_al, 0xB0);
    }

    void emit_i64_trunc_f64_u() {
        m_code.push_back(m_al, 0xB1);
    }

    void emit_f32_convert_i32_s() {
        m_code.push_back(m_al, 0xB2);
    }

    void emit_f32_convert_i32_u() {
        m_code.push_back(m_al, 0xB3);
    }

    void emit_f32_convert_i64_s() {
        m_code.push_back(m_al, 0xB4);
    }

    void emit_f32_convert_i64_u() {
        m_code.push_back(m_al, 0xB5);
    }

    void emit_f32_demote_f64() {
        m_code.push_back(m_al, 0xB6);
    }

    void emit_f64_convert_i32_s() {
        m_code.push_back(m_al, 0xB7);
    }

    void emit_f64_convert_i32_u() {
        m_code.push_back(m_al, 0xB8);
    }

    void emit_f64_convert_i64_s() {
        m_code.push_back(m_al, 0xB9);
    }

    void emit_f64_convert_i64_u() {
        m_code.push_back(m_al, 0xBA);
    }

    void emit_f64_promote_f32() {
        m_code.push_back(m_al, 0xBB);
    }

    void emit_i32_reinterpret_f32() {
        m_code.push_back(m_al, 0xBC);
    }

    void emit_i64_reinterpret_f64() {
        m_code.push_back(m_al, 0xBD);
    }

    void emit_f32_reinterpret_i32() {
        m_code.push_back(m_al, 0xBE);
    }

    void emit_f64_reinterpret_i64() {
        m_code.push_back(m_al, 0xBF);
    }

    void emit_i32_extend8_s() {
        m_code.push_back(m_al, 0xC0);
    }

    void emit_i32_extend16_s() {
        m_code.push_back(m_al, 0xC1);
    }

    void emit_i64_extend8_s() {
        m_code.push_back(m_al, 0xC2);
    }

    void emit_i64_extend16_s() {
        m_code.push_back(m_al, 0xC3);
    }

    void emit_i64_extend32_s() {
        m_code.push_back(m_al, 0xC4);
    }

    void emit_table_init(uint32_t elemidx, uint32_t tableidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 12);
        wasm::emit_u32(m_code, m_al, elemidx);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_elem_drop(uint32_t elemidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 13);
        wasm::emit_u32(m_code, m_al, elemidx);
    }

    void emit_table_copy(uint32_t des_tableidx, uint32_t src_tableidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 14);
        wasm::emit_u32(m_code, m_al, des_tableidx);
        wasm::emit_u32(m_code, m_al, src_tableidx);
    }

    void emit_table_grow(uint32_t tableidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 15);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_table_size(uint32_t tableidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 16);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_table_fill(uint32_t tableidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 17);
        wasm::emit_u32(m_code, m_al, tableidx);
    }

    void emit_data_drop(uint32_t dataidx) {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 9);
        wasm::emit_u32(m_code, m_al, dataidx);
    }

    void emit_i32_trunc_sat_f32_s() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 0);
    }

    void emit_i32_trunc_sat_f32_u() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 1);
    }

    void emit_i32_trunc_sat_f64_s() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 2);
    }

    void emit_i32_trunc_sat_f64_u() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 3);
    }

    void emit_i64_trunc_sat_f32_s() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 4);
    }

    void emit_i64_trunc_sat_f32_u() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 5);
    }

    void emit_i64_trunc_sat_f64_s() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 6);
    }

    void emit_i64_trunc_sat_f64_u() {
        m_code.push_back(m_al, 0xFC);
        wasm::emit_u32(m_code, m_al, 7);
    }

    void emit_v128_load(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 0);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load8x8_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 1);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load8x8_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 2);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load16x4_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 3);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load16x4_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 4);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load32x2_s(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 5);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load32x2_u(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 6);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load8_splat(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 7);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load16_splat(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 8);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load32_splat(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 9);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load64_splat(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 10);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load32_zero(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 92);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load64_zero(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 93);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_store(uint32_t mem_align, uint32_t mem_offset) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 11);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
    }

    void emit_v128_load8_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 84);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_load16_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 85);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_load32_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 86);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_load64_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 87);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_store8_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 88);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_store16_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 89);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_store32_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 90);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_v128_store64_lane(uint32_t mem_align, uint32_t mem_offset, uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 91);
        wasm::emit_u32(m_code, m_al, mem_align);
        wasm::emit_u32(m_code, m_al, mem_offset);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i8x16_extract_lane_s(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 21);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i8x16_extract_lane_u(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 22);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i8x16_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 23);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i16x8_extract_lane_s(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 24);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i16x8_extract_lane_u(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 25);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i16x8_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 26);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i32x4_extract_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 27);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i32x4_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 28);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i64x2_extract_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 29);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i64x2_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 30);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_f32x4_extract_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 31);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_f32x4_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 32);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_f64x2_extract_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 33);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_f64x2_replace_lane(uint8_t laneidx) {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 34);
        wasm::emit_b8(m_code, m_al, laneidx);
    }

    void emit_i8x16_swizzle() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 14);
    }

    void emit_i8x16_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 15);
    }

    void emit_i16x8_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 16);
    }

    void emit_i32x4_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 17);
    }

    void emit_i64x2_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 18);
    }

    void emit_f32x4_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 19);
    }

    void emit_f64x2_splat() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 20);
    }

    void emit_i8x16_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 35);
    }

    void emit_i8x16_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 36);
    }

    void emit_i8x16_lt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 37);
    }

    void emit_i8x16_lt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 38);
    }

    void emit_i8x16_gt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 39);
    }

    void emit_i8x16_gt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 40);
    }

    void emit_i8x16_le_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 41);
    }

    void emit_i8x16_le_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 42);
    }

    void emit_i8x16_ge_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 43);
    }

    void emit_i8x16_ge_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 44);
    }

    void emit_i16x8_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 45);
    }

    void emit_i16x8_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 46);
    }

    void emit_i16x8_lt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 47);
    }

    void emit_i16x8_lt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 48);
    }

    void emit_i16x8_gt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 49);
    }

    void emit_i16x8_gt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 50);
    }

    void emit_i16x8_le_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 51);
    }

    void emit_i16x8_le_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 52);
    }

    void emit_i16x8_ge_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 53);
    }

    void emit_i16x8_ge_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 54);
    }

    void emit_i32x4_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 55);
    }

    void emit_i32x4_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 56);
    }

    void emit_i32x4_lt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 57);
    }

    void emit_i32x4_lt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 58);
    }

    void emit_i32x4_gt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 59);
    }

    void emit_i32x4_gt_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 60);
    }

    void emit_i32x4_le_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 61);
    }

    void emit_i32x4_le_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 62);
    }

    void emit_i32x4_ge_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 63);
    }

    void emit_i32x4_ge_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 64);
    }

    void emit_i64x2_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 214);
    }

    void emit_i64x2_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 215);
    }

    void emit_i64x2_lt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 216);
    }

    void emit_i64x2_gt_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 217);
    }

    void emit_i64x2_le_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 218);
    }

    void emit_i64x2_ge_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 219);
    }

    void emit_f32x4_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 65);
    }

    void emit_f32x4_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 66);
    }

    void emit_f32x4_lt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 67);
    }

    void emit_f32x4_gt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 68);
    }

    void emit_f32x4_le() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 69);
    }

    void emit_f32x4_ge() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 70);
    }

    void emit_f64x2_eq() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 71);
    }

    void emit_f64x2_ne() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 72);
    }

    void emit_f64x2_lt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 73);
    }

    void emit_f64x2_gt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 74);
    }

    void emit_f64x2_le() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 75);
    }

    void emit_f64x2_ge() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 76);
    }

    void emit_v128_not() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 77);
    }

    void emit_v128_and() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 78);
    }

    void emit_v128_andnot() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 79);
    }

    void emit_v128_or() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 80);
    }

    void emit_v128_xor() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 81);
    }

    void emit_v128_bitselect() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 82);
    }

    void emit_v128_any_true() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 83);
    }

    void emit_i8x16_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 96);
    }

    void emit_i8x16_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 97);
    }

    void emit_i8x16_popcnt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 98);
    }

    void emit_i8x16_all_true() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 99);
    }

    void emit_i8x16_bitmask() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 100);
    }

    void emit_i8x16_narrow_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 101);
    }

    void emit_i8x16_narrow_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 102);
    }

    void emit_i8x16_shl() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 107);
    }

    void emit_i8x16_shr_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 108);
    }

    void emit_i8x16_shr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 109);
    }

    void emit_i8x16_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 110);
    }

    void emit_i8x16_add_sat_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 111);
    }

    void emit_i8x16_add_sat_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 112);
    }

    void emit_i8x16_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 113);
    }

    void emit_i8x16_sub_sat_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 114);
    }

    void emit_i8x16_sub_sat_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 115);
    }

    void emit_i8x16_min_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 118);
    }

    void emit_i8x16_min_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 119);
    }

    void emit_i8x16_max_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 120);
    }

    void emit_i8x16_max_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 121);
    }

    void emit_i8x16_avgr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 123);
    }

    void emit_i16x8_extadd_pairwise_i8x16_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 124);
    }

    void emit_i16x8_extadd_pairwise_i8x16_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 125);
    }

    void emit_i16x8_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 128);
    }

    void emit_i16x8_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 129);
    }

    void emit_i16x8_q15mulr_sat_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 130);
    }

    void emit_i16x8_all_true() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 131);
    }

    void emit_i16x8_bitmask() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 132);
    }

    void emit_i16x8_narrow_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 133);
    }

    void emit_i16x8_narrow_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 134);
    }

    void emit_i16x8_extend_low_i8x16_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 135);
    }

    void emit_i16x8_extend_high_i8x16_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 136);
    }

    void emit_i16x8_extend_low_i8x16_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 137);
    }

    void emit_i16x8_extend_high_i8x16_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 138);
    }

    void emit_i16x8_shl() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 139);
    }

    void emit_i16x8_shr_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 140);
    }

    void emit_i16x8_shr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 141);
    }

    void emit_i16x8_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 142);
    }

    void emit_i16x8_add_sat_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 143);
    }

    void emit_i16x8_add_sat_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 144);
    }

    void emit_i16x8_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 145);
    }

    void emit_i16x8_sub_sat_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 146);
    }

    void emit_i16x8_sub_sat_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 147);
    }

    void emit_i16x8_mul() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 149);
    }

    void emit_i16x8_min_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 150);
    }

    void emit_i16x8_min_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 151);
    }

    void emit_i16x8_max_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 152);
    }

    void emit_i16x8_max_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 153);
    }

    void emit_i16x8_avgr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 155);
    }

    void emit_i16x8_extmul_low_i8x16_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 156);
    }

    void emit_i16x8_extmul_high_i8x16_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 157);
    }

    void emit_i16x8_extmul_low_i8x16_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 158);
    }

    void emit_i16x8_extmul_high_i8x16_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 159);
    }

    void emit_i32x4_extadd_pairwise_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 126);
    }

    void emit_i32x4_extadd_pairwise_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 127);
    }

    void emit_i32x4_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 160);
    }

    void emit_i32x4_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 161);
    }

    void emit_i32x4_all_true() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 163);
    }

    void emit_i32x4_bitmask() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 164);
    }

    void emit_i32x4_extend_low_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 167);
    }

    void emit_i32x4_extend_high_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 168);
    }

    void emit_i32x4_extend_low_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 169);
    }

    void emit_i32x4_extend_high_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 170);
    }

    void emit_i32x4_shl() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 171);
    }

    void emit_i32x4_shr_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 172);
    }

    void emit_i32x4_shr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 173);
    }

    void emit_i32x4_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 174);
    }

    void emit_i32x4_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 177);
    }

    void emit_i32x4_mul() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 181);
    }

    void emit_i32x4_min_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 182);
    }

    void emit_i32x4_min_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 183);
    }

    void emit_i32x4_max_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 184);
    }

    void emit_i32x4_max_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 185);
    }

    void emit_i32x4_dot_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 186);
    }

    void emit_i32x4_extmul_low_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 188);
    }

    void emit_i32x4_extmul_high_i16x8_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 189);
    }

    void emit_i32x4_extmul_low_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 190);
    }

    void emit_i32x4_extmul_high_i16x8_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 191);
    }

    void emit_i64x2_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 192);
    }

    void emit_i64x2_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 193);
    }

    void emit_i64x2_all_true() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 195);
    }

    void emit_i64x2_bitmask() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 196);
    }

    void emit_i64x2_extend_low_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 199);
    }

    void emit_i64x2_extend_high_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 200);
    }

    void emit_i64x2_extend_low_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 201);
    }

    void emit_i64x2_extend_high_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 202);
    }

    void emit_i64x2_shl() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 203);
    }

    void emit_i64x2_shr_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 204);
    }

    void emit_i64x2_shr_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 205);
    }

    void emit_i64x2_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 206);
    }

    void emit_i64x2_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 209);
    }

    void emit_i64x2_mul() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 213);
    }

    void emit_i64x2_extmul_low_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 220);
    }

    void emit_i64x2_extmul_high_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 221);
    }

    void emit_i64x2_extmul_low_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 222);
    }

    void emit_i64x2_extmul_high_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 223);
    }

    void emit_f32x4_ceil() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 103);
    }

    void emit_f32x4_floor() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 104);
    }

    void emit_f32x4_trunc() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 105);
    }

    void emit_f32x4_nearest() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 106);
    }

    void emit_f32x4_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 224);
    }

    void emit_f32x4_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 225);
    }

    void emit_f32x4_sqrt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 227);
    }

    void emit_f32x4_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 228);
    }

    void emit_f32x4_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 229);
    }

    void emit_f32x4_mul() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 230);
    }

    void emit_f32x4_div() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 231);
    }

    void emit_f32x4_min() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 232);
    }

    void emit_f32x4_max() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 233);
    }

    void emit_f32x4_pmin() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 234);
    }

    void emit_f32x4_pmax() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 235);
    }

    void emit_f64x2_ceil() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 116);
    }

    void emit_f64x2_floor() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 117);
    }

    void emit_f64x2_trunc() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 122);
    }

    void emit_f64x2_nearest() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 148);
    }

    void emit_f64x2_abs() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 236);
    }

    void emit_f64x2_neg() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 237);
    }

    void emit_f64x2_sqrt() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 239);
    }

    void emit_f64x2_add() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 240);
    }

    void emit_f64x2_sub() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 241);
    }

    void emit_f64x2_mul() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 242);
    }

    void emit_f64x2_div() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 243);
    }

    void emit_f64x2_min() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 244);
    }

    void emit_f64x2_max() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 245);
    }

    void emit_f64x2_pmin() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 246);
    }

    void emit_f64x2_pmax() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 247);
    }

    void emit_i32x4_trunc_sat_f32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 248);
    }

    void emit_i32x4_trunc_sat_f32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 249);
    }

    void emit_f32x4_convert_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 250);
    }

    void emit_f32x4_convert_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 251);
    }

    void emit_i32x4_trunc_sat_f64x2_s_zero() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 252);
    }

    void emit_i32x4_trunc_sat_f64x2_u_zero() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 253);
    }

    void emit_f64x2_convert_low_i32x4_s() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 254);
    }

    void emit_f64x2_convert_low_i32x4_u() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 255);
    }

    void emit_f32x4_demote_f64x2_zero() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 94);
    }

    void emit_f64x2_promote_low_f32x4() {
        m_code.push_back(m_al, 0xFD);
        wasm::emit_u32(m_code, m_al, 95);
    }

};


} // namespace WASM_INSTS_VISITOR

} // namespace LCompilers

#endif // LFORTRAN_WASM_INSTS_VISITOR_H
