/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmspecglobscan.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief compute specglob alignment on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *https://visio.numerique.gouv.fr/
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "../cborscanmapbase.h"
#include "psmspecglob.h"

namespace pappso::cbor::psm
{
/**
 * @todo write docs
 */
class PsmSpecGlobScan : public CborScanMapBase
{
  public:
  /**
   * Default constructor
   */
  PsmSpecGlobScan(const PsmSpecGlob &psm_specgloc,
                  pappso::PrecisionPtr fragment_tolerance);

  /**
   * Destructor
   */
  virtual ~PsmSpecGlobScan();

  protected:
  void process() override;

  private:
  const PsmSpecGlob *mp_psmSpecGlob;
  pappso::PrecisionPtr m_fragmentTolerance;
  bool m_checkMutations = false;
};
} // namespace pappso::cbor::psm
