import QtQuick
import QtQuick.Controls
import PappsoMS 1.0

ApplicationWindow {
    width: 400
    height: 400
    visible: true
    title: "DataPoint QML Test"

    // --- Test 1: Create a DataPoint and verify properties ---
    DataPoint {
        id: testPoint
        x: 10.5
        y: 20.3

        Component.onCompleted: {
            testPoint.x = 21;  // Works (imperative JS)
            testPoint.setY(40.6);
        }
    }

    DataPoint {
        id: otherTestPoint
        x: testPoint.x
        y: testPoint.y
    }

    // --- Test 2: Bind properties to UI elements ---
    Column {
        anchors.centerIn: parent
        spacing: 10

        Text {
            text: `Initial Values: (${testPoint.x}, ${testPoint.y})`
            color: "green"
        }

        // --- Test 3: Modify properties dynamically ---
        Button {
            text: "Randomize DataPoint"
            onClicked: {
                testPoint.x = Math.random() * 100;
                testPoint.y = Math.random() * 100;
            }
        }

        // --- Test 4: Verify property bindings ---
        Text {
            text: `Current Values: (${testPoint.x}, ${testPoint.y})`
            color: testPoint.x > 50 ? "red" : "blue"  // Binding test
        }

        // --- Test 5: Log changes (verify signals) ---
        Connections {
            target: testPoint
            function onXChanged() {
                console.log("X changed to:", testPoint.x);
            }
            function onYChanged() {
                console.log("Y changed to:", testPoint.y);
            }
        }
        Connections {
            target: otherTestPoint
            function onXChanged() {
                console.log("X other changed to:", otherTestPoint.x);
            }
            function onYChanged() {
                console.log("Y other changed to:", otherTestPoint.y);
            }
        }
    }

    // --- Test 6: Create from C++ (if applicable) ---
    Component.onCompleted: {
        console.log("DataPoint test initialized");
        // Optional: Verify C++-created instances (if your library provides them)
        if (typeof cppApi !== "undefined" && cppApi.createDataPoint) {
            const cppPoint = cppApi.createDataPoint(99.9, 88.8);
            console.log("C++-created point:", cppPoint.x, cppPoint.y);
        }
    }
}
