/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QDialog>
#include <QtQml>

/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/jsclassregistrar.h"

namespace Ui
{
class MassDataClientServerConfigDlg;
}

namespace MsXpS
{
namespace libXpertMassGui
{

/*  BEGIN CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassGui
 *  class name: MassDataClientServerConfigDlg
 */

class DECLSPEC MassDataClientServerConfigDlg: public QDialog
{
  Q_OBJECT

  Q_PROPERTY(std::pair<QString, int> serverIpConfig MEMBER m_serverIpConfig)
  Q_PROPERTY(std::pair<QString, int> clientIpConfig MEMBER m_clientIpConfig)

  public:
  MassDataClientServerConfigDlg(QWidget *parent,
                                const QString &applicationName,
                                const QString &description,
                                std::pair<QString, int> server_ip_config = std::pair("",
                                                                           0));

  virtual ~MassDataClientServerConfigDlg();

  void updateServerIpData(std::pair<QString, int> server_ip_config);
  void updateClientIpData(std::pair<QString, int> client_ip_config);

  void updateClientConfigurationData(const QString &ip_address,
                                     int port_number);
  void clientFailingFeedback(const QString &error);
  void message(const QString &message, int timeout = 3000);

  static void registerJsConstructor(QJSEngine *engine);

  signals:
  void startServerSignal();
  void startClientSignal(const QString ip_address, int port_number);
  void stopServerSignal();
  void stopClientSignal();

  private slots:
  void startClient();

  protected:
  QString m_applicationName;
  QWidget *mp_programWindow = nullptr;

  // Describes the connection data for any client to connect to the server that
  // is started in this dialog window.
  std::pair<QString, int> m_serverIpConfig = std::pair<QString, int>("", 0);

  // Described the connection data for the client started in this dialog window
  // to connect to the server.
  QPair<QString, int> m_clientIpConfig = std::pair<QString, int>("", 0);

  Ui::MassDataClientServerConfigDlg *mp_ui;

  void closeEvent(QCloseEvent *event);
  void writeSettings(const QString &configSettingsFilePath);
  void readSettings(const QString &configSettingsFilePath);
};

/*  END CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassGui
 *  class name: MassDataClientServerConfigDlg
 */
} // namespace libXpertMassGui
MSXPS_REGISTER_JS_CLASS(MsXpS::libXpertMassGui, MassDataClientServerConfigDlg)
} // namespace MsXpS
