from typing import Any, ClassVar, Dict, List

from typing import overload
import mrpt.pymrpt.mrpt.bayes
import mrpt.pymrpt.mrpt.bayes.CParticleFilter
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.maps
import mrpt.pymrpt.mrpt.maps.CMultiMetricMapPDF
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.opengl
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.mrpt.system
import mrpt.pymrpt.mrpt.tfest
import mrpt.pymrpt.mrpt.vision
import mrpt.pymrpt.mrpt.vision.CFeatureExtraction
assocJCBB: TDataAssociationMethod
assocNN: TDataAssociationMethod
icpClassic: TICPAlgorithm
icpCovFiniteDifferences: TICPCovarianceMethod
icpCovLinealMSE: TICPCovarianceMethod
icpLevenbergMarquardt: TICPAlgorithm
metricML: TDataAssociationMetric
metricMaha: TDataAssociationMetric
smCUSTOM_FUNCTION: similarity_method_t
smMETRIC_MAP_MATCHING: similarity_method_t
smOBSERVATION_OVERLAP: similarity_method_t

class CGridMapAligner(CMetricMapsAlignmentAlgorithm):
    class TAlignerMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        amCorrelation: ClassVar[CGridMapAligner.TAlignerMethod] = ...
        amModifiedRANSAC: ClassVar[CGridMapAligner.TAlignerMethod] = ...
        amRobustMatch: ClassVar[CGridMapAligner.TAlignerMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TConfigParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        debug_save_map_pairs: bool
        featsPerSquareMeter: float
        feature_descriptor: mrpt.pymrpt.mrpt.vision.TDescriptorType
        feature_detector_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions
        maxKLd_for_merge: float
        max_ICP_mahadist: float
        methodSelection: CGridMapAligner.TAlignerMethod
        min_ICP_goodness: float
        ransac_SOG_sigma_m: float
        ransac_chi2_quantile: float
        ransac_mahalanobisDistanceThreshold: float
        ransac_minSetSizeRatio: float
        ransac_prob_good_inliers: float
        save_feat_coors: bool
        threshold_delta: float
        threshold_max: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CGridMapAligner.TConfigParams) -> None: ...
        @overload
        def __init__(self, arg0: CGridMapAligner.TConfigParams) -> None: ...
        def assign(self) -> CGridMapAligner.TConfigParams: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TReturnInfo(TMetricMapAlignmentResult):
        class TPairPlusDistance:
            dist: float
            idx_other: int
            idx_this: int
            def __init__(self, i1: int, i2: int, d: float) -> None: ...
        correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t
        correspondences_dists_maha: Any
        goodness: float
        icp_goodness_all_sog_modes: List[float]
        landmarks_map1: mrpt.pymrpt.mrpt.maps.CLandmarksMap
        landmarks_map2: mrpt.pymrpt.mrpt.maps.CLandmarksMap
        noRobustEstimation: mrpt.pymrpt.mrpt.poses.CPose2D
        sog1: Any
        sog2: Any
        sog3: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CGridMapAligner.TReturnInfo) -> None: ...
        def assign(self) -> CGridMapAligner.TReturnInfo: ...
    amCorrelation: ClassVar[CGridMapAligner.TAlignerMethod] = ...
    amModifiedRANSAC: ClassVar[CGridMapAligner.TAlignerMethod] = ...
    amRobustMatch: ClassVar[CGridMapAligner.TAlignerMethod] = ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CGridMapAligner) -> None: ...
    @overload
    def __init__(self, arg0: CGridMapAligner) -> None: ...
    def assign(self) -> CGridMapAligner: ...

class CICP(CMetricMapsAlignmentAlgorithm):
    class TConfigParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        ALFA: float
        Axy_aprox_derivatives: float
        ICP_algorithm: TICPAlgorithm
        ICP_covariance_method: TICPCovarianceMethod
        LM_initial_lambda: float
        corresponding_points_decimation: int
        covariance_varPoints: float
        doRANSAC: bool
        kernel_rho: float
        maxIterations: int
        minAbsStep_rot: float
        minAbsStep_trans: float
        normalizationStd: float
        onlyUniqueRobust: bool
        ransac_fuseByCorrsMatch: bool
        ransac_fuseMaxDiffPhi: float
        ransac_fuseMaxDiffXY: float
        ransac_mahalanobisDistanceThreshold: float
        ransac_maxSetSize: int
        ransac_minSetSize: int
        ransac_nSimulations: int
        skip_cov_calculation: bool
        skip_quality_calculation: bool
        smallestThresholdDist: float
        thresholdAng: float
        thresholdDist: float
        use_kernel: bool
        @overload
        def __init__(self, arg0: CICP.TConfigParams) -> None: ...
        @overload
        def __init__(self, arg0: CICP.TConfigParams) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def assign(self) -> CICP.TConfigParams: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TReturnInfo(TMetricMapAlignmentResult):
        goodness: float
        nIterations: int
        quality: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CICP.TReturnInfo) -> None: ...
        def assign(self) -> CICP.TReturnInfo: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, icpParams) -> None: ...
    @overload
    def __init__(self, arg0: CICP) -> None: ...
    @overload
    def __init__(self, arg0: CICP) -> None: ...
    def assign(self) -> CICP: ...

class CIncrementalMapPartitioner(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        forceBisectionOnly: bool
        maxKeyFrameDistanceToEval: int
        metricmap: mrpt.pymrpt.mrpt.maps.TSetOfMetricMapInitializers
        minimumNumberElementsEachCluster: int
        mrp: mrpt.pymrpt.mrpt.maps.TMatchingRatioParams
        partitionThreshold: float
        simil_method: similarity_method_t
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CIncrementalMapPartitioner.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CIncrementalMapPartitioner.TOptions) -> None: ...
        def assign(self) -> CIncrementalMapPartitioner.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, target: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CIncrementalMapPartitioner) -> None: ...
    @overload
    def __init__(self, arg0: CIncrementalMapPartitioner) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def addMapFrame(self, frame: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose3D: mrpt.pymrpt.mrpt.poses.CPose3DPDF) -> int: ...
    def assign(self) -> CIncrementalMapPartitioner: ...
    @overload
    def changeCoordinatesOrigin(self, newOrigin: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesOrigin(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesOriginPoseIndex(self, newOriginPose: int) -> None: ...
    @overload
    def changeCoordinatesOriginPoseIndex(unsignedint) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getAdjacencyMatrix(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t: ...
    @overload
    def getNodesCount(self) -> int: ...
    @overload
    def getNodesCount() -> size_t: ...
    def getSequenceOfFrames(self) -> mrpt.pymrpt.mrpt.maps.CSimpleMap: ...
    @overload
    def setSimilarityMethod(self, method: similarity_method_t) -> None: ...
    @overload
    def setSimilarityMethod(enummrpt) -> void: ...
    @overload
    def setSimilarityMethod(self, func) -> None: ...
    @overload
    def setSimilarityMethod(classstd) -> void: ...

class CMetricMapBuilder:
    class TOptions:
        alwaysInsertByClass: mrpt.pymrpt.mrpt.rtti.CListOfClasses
        debugForceInsertion: bool
        enableMapUpdating: bool
        def __init__(self, verb_level_ref: mrpt.pymrpt.mrpt.system.VerbosityLevel) -> None: ...
    def __init__(self) -> None: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def enableMapUpdating(self, enable: bool) -> None: ...
    @overload
    def enableMapUpdating(bool) -> void: ...
    def getCurrentPoseEstimation(self) -> mrpt.pymrpt.mrpt.poses.CPose3DPDF: ...
    @overload
    def getCurrentlyBuiltMap(self, out_map: mrpt.pymrpt.mrpt.maps.CSimpleMap) -> None: ...
    @overload
    def getCurrentlyBuiltMap(classmrpt) -> void: ...
    @overload
    def getCurrentlyBuiltMapSize(self) -> int: ...
    @overload
    def getCurrentlyBuiltMapSize() -> unsignedint: ...
    def getCurrentlyBuiltMetricMap(self) -> mrpt.pymrpt.mrpt.maps.CMultiMetricMap: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize(self, initialMap: mrpt.pymrpt.mrpt.maps.CSimpleMap) -> None: ...
    @overload
    def initialize(self, initialMap: mrpt.pymrpt.mrpt.maps.CSimpleMap, x0: mrpt.pymrpt.mrpt.poses.CPosePDF) -> None: ...
    @overload
    def loadCurrentMapFromFile(self, fileName: str) -> None: ...
    @overload
    def loadCurrentMapFromFile(conststd) -> void: ...
    def processActionObservation(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observations: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> None: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str) -> None: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str, formatEMF_BMP: bool) -> None: ...
    @overload
    def saveCurrentEstimationToImage(conststd, bool) -> void: ...
    @overload
    def saveCurrentMapToFile(self, fileName: str) -> None: ...
    @overload
    def saveCurrentMapToFile(self, fileName: str, compressGZ: bool) -> None: ...
    @overload
    def saveCurrentMapToFile(conststd, bool) -> void: ...

class CMetricMapBuilderICP(CMetricMapBuilder):
    class TConfigParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        insertionAngDistance: float
        insertionLinDistance: float
        localizationAngDistance: float
        localizationLinDistance: float
        mapInitializers: mrpt.pymrpt.mrpt.maps.TSetOfMetricMapInitializers
        matchAgainstTheGrid: bool
        minICPgoodnessToAccept: float
        @overload
        def __init__(self, parent_verbosity_level: mrpt.pymrpt.mrpt.system.VerbosityLevel) -> None: ...
        @overload
        def __init__(self, arg0: CMetricMapBuilderICP.TConfigParams) -> None: ...
        @overload
        def __init__(self, arg0: CMetricMapBuilderICP.TConfigParams) -> None: ...
        def assign(self, other: CMetricMapBuilderICP.TConfigParams) -> CMetricMapBuilderICP.TConfigParams: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    ICP_options: Any
    ICP_params: CICP.TConfigParams
    def __init__(self) -> None: ...
    def getCurrentPoseEstimation(self) -> mrpt.pymrpt.mrpt.poses.CPose3DPDF: ...
    @overload
    def getCurrentlyBuiltMap(self, out_map: mrpt.pymrpt.mrpt.maps.CSimpleMap) -> None: ...
    @overload
    def getCurrentlyBuiltMap(classmrpt) -> void: ...
    @overload
    def getCurrentlyBuiltMapSize(self) -> int: ...
    @overload
    def getCurrentlyBuiltMapSize() -> unsignedint: ...
    def getCurrentlyBuiltMetricMap(self) -> mrpt.pymrpt.mrpt.maps.CMultiMetricMap: ...
    def initialize(self, *args, **kwargs) -> Any: ...
    def processActionObservation(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, in_SF: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> None: ...
    def processObservation(self, *args, **kwargs) -> Any: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str) -> None: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str, formatEMF_BMP: bool) -> None: ...
    @overload
    def saveCurrentEstimationToImage(conststd, bool) -> void: ...
    def setCurrentMapFile(self, mapFile: str) -> None: ...

class CMetricMapBuilderRBPF(CMetricMapBuilder):
    class TConstructionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions
        insertionAngDistance: float
        insertionLinDistance: float
        localizeAngDistance: float
        localizeLinDistance: float
        mapsInitializers: mrpt.pymrpt.mrpt.maps.TSetOfMetricMapInitializers
        predictionOptions: mrpt.pymrpt.mrpt.maps.CMultiMetricMapPDF.TPredictionParams
        verbosity_level: mrpt.pymrpt.mrpt.system.VerbosityLevel
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CMetricMapBuilderRBPF.TConstructionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CMetricMapBuilderRBPF.TConstructionOptions) -> None: ...
        def assign(self) -> CMetricMapBuilderRBPF.TConstructionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TStats:
        observationsInserted: bool
        def __init__(self) -> None: ...
    m_statsLastIteration: Any
    mapPDF: mrpt.pymrpt.mrpt.maps.CMultiMetricMapPDF
    @overload
    def __init__(self, initializationOptions) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self, src: CMetricMapBuilderRBPF) -> CMetricMapBuilderRBPF: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def drawCurrentEstimationToImage(self, img: mrpt.pymrpt.mrpt.img.CCanvas) -> None: ...
    @overload
    def drawCurrentEstimationToImage(classmrpt) -> void: ...
    @overload
    def getCurrentJointEntropy(self) -> float: ...
    @overload
    def getCurrentJointEntropy() -> double: ...
    @overload
    def getCurrentMostLikelyPath(self, outPath: List[mrpt.pymrpt.mrpt.math.TPose3D]) -> None: ...
    @overload
    def getCurrentMostLikelyPath(classstd) -> void: ...
    def getCurrentPoseEstimation(self) -> mrpt.pymrpt.mrpt.poses.CPose3DPDF: ...
    @overload
    def getCurrentlyBuiltMap(self, out_map: mrpt.pymrpt.mrpt.maps.CSimpleMap) -> None: ...
    @overload
    def getCurrentlyBuiltMap(classmrpt) -> void: ...
    @overload
    def getCurrentlyBuiltMapSize(self) -> int: ...
    @overload
    def getCurrentlyBuiltMapSize() -> unsignedint: ...
    def getCurrentlyBuiltMetricMap(self) -> mrpt.pymrpt.mrpt.maps.CMultiMetricMap: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize(self, initialMap: mrpt.pymrpt.mrpt.maps.CSimpleMap) -> None: ...
    @overload
    def initialize(self, initialMap: mrpt.pymrpt.mrpt.maps.CSimpleMap, x0: mrpt.pymrpt.mrpt.poses.CPosePDF) -> None: ...
    def processActionObservation(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observations: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> None: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str) -> None: ...
    @overload
    def saveCurrentEstimationToImage(self, file: str, formatEMF_BMP: bool) -> None: ...
    @overload
    def saveCurrentEstimationToImage(conststd, bool) -> void: ...
    @overload
    def saveCurrentPathEstimationToTextFile(self, fil: str) -> None: ...
    @overload
    def saveCurrentPathEstimationToTextFile(conststd) -> void: ...

class CMetricMapsAlignmentAlgorithm:
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> CMetricMapsAlignmentAlgorithm: ...

class CMonteCarloLocalization2D(mrpt.pymrpt.mrpt.poses.CPosePDFParticles, PF_implementation_mrpt_math_TPose2D_mrpt_slam_CMonteCarloLocalization2D_mrpt_bayes_particle_storage_mode_VALUE_t):
    options: TMonteCarloLocalizationParams
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, M: int) -> None: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData: mrpt.pymrpt.mrpt.math.TPose2D, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(structmrpt, conststructmrpt) -> void: ...
    def assign(self) -> CMonteCarloLocalization2D: ...
    def getLastPose(self, i: int, is_valid_pose: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    def getVisualization(self) -> mrpt.pymrpt.mrpt.opengl.CSetOfObjects: ...
    def prediction_and_update_pfAuxiliaryPFOptimal(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...
    def prediction_and_update_pfAuxiliaryPFStandard(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...
    def prediction_and_update_pfStandardProposal(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float, x_max: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float, x_max: float, y_min: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float, x_max: float, y_min: float, y_max: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float, x_max: float, y_min: float, y_max: float, phi_min: float) -> None: ...
    @overload
    def resetUniformFreeSpace(self, theMap: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, freeCellsThreshold: float, particlesCount: int, x_min: float, x_max: float, y_min: float, y_max: float, phi_min: float, phi_max: float) -> None: ...

class CMonteCarloLocalization3D(mrpt.pymrpt.mrpt.poses.CPose3DPDFParticles, PF_implementation_mrpt_math_TPose3D_mrpt_slam_CMonteCarloLocalization3D_mrpt_bayes_particle_storage_mode_VALUE_t):
    options: TMonteCarloLocalizationParams
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, M: int) -> None: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData: mrpt.pymrpt.mrpt.math.TPose3D, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(structmrpt, conststructmrpt) -> void: ...
    def assign(self) -> CMonteCarloLocalization3D: ...
    def getLastPose(self, i: int, is_valid_pose: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    def getVisualization(self) -> mrpt.pymrpt.mrpt.opengl.CSetOfObjects: ...
    def prediction_and_update_pfAuxiliaryPFOptimal(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...
    def prediction_and_update_pfAuxiliaryPFStandard(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...
    def prediction_and_update_pfStandardProposal(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions) -> None: ...

class COccupancyGridMapFeatureExtractor(mrpt.pymrpt.mrpt.system.CObserver):
    @overload
    def __init__(self, arg0: COccupancyGridMapFeatureExtractor) -> None: ...
    @overload
    def __init__(self, arg0: COccupancyGridMapFeatureExtractor) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> COccupancyGridMapFeatureExtractor: ...
    @overload
    def extractFeatures(self, grid: mrpt.pymrpt.mrpt.maps.COccupancyGridMap2D, outMap: mrpt.pymrpt.mrpt.maps.CLandmarksMap, number_of_features: int, descriptors: mrpt.pymrpt.mrpt.vision.TDescriptorType, feat_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions) -> None: ...
    @overload
    def extractFeatures(constclassmrpt, classmrpt, size_t, constenummrpt, conststructmrpt) -> void: ...
    def uncached_extractFeatures(self, *args, **kwargs) -> Any: ...

class CRangeBearingKFSLAM(mrpt.pymrpt.mrpt.bayes.CKalmanFilterCapable_7UL_3UL_3UL_7UL_double_t):
    class TDataAssocInfo:
        Y_pred_covs: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
        Y_pred_means: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
        newly_inserted_landmarks: Dict[int,int]
        predictions_IDs: List[int]
        results: TDataAssociationResults
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM.TDataAssocInfo) -> None: ...
        def assign(self) -> CRangeBearingKFSLAM.TDataAssocInfo: ...
        @overload
        def clear(self) -> None: ...
        @overload
        def clear() -> void: ...

    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        create_simplemap: bool
        data_assoc_IC_chi2_thres: float
        data_assoc_IC_metric: TDataAssociationMetric
        data_assoc_IC_ml_threshold: float
        data_assoc_method: TDataAssociationMethod
        data_assoc_metric: TDataAssociationMetric
        doPartitioningExperiment: bool
        force_ignore_odometry: bool
        partitioningMethod: int
        quantiles_3D_representation: float
        std_odo_z_additional: float
        std_sensor_pitch: float
        std_sensor_range: float
        std_sensor_yaw: float
        stds_Q_no_odo: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM.TOptions) -> None: ...
        def assign(self) -> CRangeBearingKFSLAM.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRangeBearingKFSLAM) -> None: ...
    @overload
    def __init__(self, arg0: CRangeBearingKFSLAM) -> None: ...
    @overload
    def getAs3DObject(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getAs3DObject(classstd) -> void: ...
    @overload
    def getCurrentRobotPose(self, out_robotPose: mrpt.pymrpt.mrpt.poses.CPose3DQuatPDFGaussian) -> None: ...
    @overload
    def getCurrentRobotPose(classmrpt) -> void: ...
    @overload
    def getCurrentRobotPose(self, out_robotPose: mrpt.pymrpt.mrpt.poses.CPose3DPDFGaussian) -> None: ...
    @overload
    def getCurrentRobotPose(classmrpt) -> void: ...
    def getCurrentRobotPoseMean(self) -> mrpt.pymrpt.mrpt.poses.CPose3DQuat: ...
    def getLastDataAssociation(self, *args, **kwargs) -> Any: ...
    @overload
    def loadOptions(self, ini: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadOptions(constclassmrpt) -> void: ...
    def mapPartitionOptions(self) -> CIncrementalMapPartitioner.TOptions: ...
    def processActionObservation(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, SF: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> None: ...
    def reconsiderPartitionsNow(self, *args, **kwargs) -> Any: ...
    @overload
    def reset(self) -> None: ...
    @overload
    def reset() -> void: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str, stylePath: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str, stylePath: str, styleRobot: str) -> None: ...

class CRangeBearingKFSLAM2D(mrpt.pymrpt.mrpt.bayes.CKalmanFilterCapable_3UL_2UL_2UL_3UL_double_t):
    class TDataAssocInfo:
        Y_pred_covs: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
        Y_pred_means: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
        newly_inserted_landmarks: Dict[int,int]
        predictions_IDs: List[int]
        results: TDataAssociationResults
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM2D.TDataAssocInfo) -> None: ...
        def assign(self) -> CRangeBearingKFSLAM2D.TDataAssocInfo: ...
        @overload
        def clear(self) -> None: ...
        @overload
        def clear() -> void: ...

    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        create_simplemap: bool
        data_assoc_IC_chi2_thres: float
        data_assoc_IC_metric: TDataAssociationMetric
        data_assoc_IC_ml_threshold: float
        data_assoc_method: TDataAssociationMethod
        data_assoc_metric: TDataAssociationMetric
        quantiles_3D_representation: float
        std_sensor_range: float
        std_sensor_yaw: float
        stds_Q_no_odo: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM2D.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CRangeBearingKFSLAM2D.TOptions) -> None: ...
        def assign(self) -> CRangeBearingKFSLAM2D.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRangeBearingKFSLAM2D) -> None: ...
    @overload
    def __init__(self, arg0: CRangeBearingKFSLAM2D) -> None: ...
    @overload
    def getAs3DObject(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getAs3DObject(classstd) -> void: ...
    @overload
    def getCurrentRobotPose(self, out_robotPose: mrpt.pymrpt.mrpt.poses.CPosePDFGaussian) -> None: ...
    @overload
    def getCurrentRobotPose(classmrpt) -> void: ...
    def getLastDataAssociation(self, *args, **kwargs) -> Any: ...
    @overload
    def loadOptions(self, ini: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadOptions(constclassmrpt) -> void: ...
    def processActionObservation(self, action: mrpt.pymrpt.mrpt.obs.CActionCollection, SF: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> None: ...
    @overload
    def reset(self) -> None: ...
    @overload
    def reset() -> void: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str, stylePath: str) -> None: ...
    @overload
    def saveMapAndPath2DRepresentationAsMATLABFile(self, fil: str, stdCount: float, styleLandmarks: str, stylePath: str, styleRobot: str) -> None: ...

class CRejectionSamplingRangeOnlyLocalization(mrpt.pymrpt.mrpt.bayes.CRejectionSamplingCapable_mrpt_poses_CPose2D_mrpt_bayes_particle_storage_mode_POINTER_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRejectionSamplingRangeOnlyLocalization) -> None: ...
    @overload
    def __init__(self, arg0: CRejectionSamplingRangeOnlyLocalization) -> None: ...
    def assign(self) -> CRejectionSamplingRangeOnlyLocalization: ...
    @overload
    def setParams(self, beaconsMap: mrpt.pymrpt.mrpt.maps.CLandmarksMap, observation: mrpt.pymrpt.mrpt.obs.CObservationBeaconRanges, sigmaRanges: float, oldPose: mrpt.pymrpt.mrpt.poses.CPose2D) -> bool: ...
    @overload
    def setParams(self, beaconsMap: mrpt.pymrpt.mrpt.maps.CLandmarksMap, observation: mrpt.pymrpt.mrpt.obs.CObservationBeaconRanges, sigmaRanges: float, oldPose: mrpt.pymrpt.mrpt.poses.CPose2D, robot_z: float) -> bool: ...
    @overload
    def setParams(self, beaconsMap: mrpt.pymrpt.mrpt.maps.CLandmarksMap, observation: mrpt.pymrpt.mrpt.obs.CObservationBeaconRanges, sigmaRanges: float, oldPose: mrpt.pymrpt.mrpt.poses.CPose2D, robot_z: float, autoCheckAngleRanges: bool) -> bool: ...

class PF_implementation_mrpt_maps_CRBPFParticleData_mrpt_maps_CMultiMetricMapPDF_mrpt_bayes_particle_storage_mode_POINTER_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: PF_implementation_mrpt_maps_CRBPFParticleData_mrpt_maps_CMultiMetricMapPDF_mrpt_bayes_particle_storage_mode_POINTER_t) -> None: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(classmrpt, conststructmrpt) -> void: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(self, particles, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(constclassstd, mrpt, constclassmrpt) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement(self) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement() -> bool: ...
    def assign(self) -> PF_implementation_mrpt_maps_CRBPFParticleData_mrpt_maps_CMultiMetricMapPDF_mrpt_bayes_particle_storage_mode_POINTER_t: ...
    def getLastPose(self, i: int, is_valid_pose: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...

class PF_implementation_mrpt_math_TPose2D_mrpt_slam_CMonteCarloLocalization2D_mrpt_bayes_particle_storage_mode_VALUE_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: PF_implementation_mrpt_math_TPose2D_mrpt_slam_CMonteCarloLocalization2D_mrpt_bayes_particle_storage_mode_VALUE_t) -> None: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData: mrpt.pymrpt.mrpt.math.TPose2D, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(structmrpt, conststructmrpt) -> void: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(self, particles, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(constclassstd, mrpt, constclassmrpt) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement(self) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement() -> bool: ...
    def assign(self) -> PF_implementation_mrpt_math_TPose2D_mrpt_slam_CMonteCarloLocalization2D_mrpt_bayes_particle_storage_mode_VALUE_t: ...
    def getLastPose(self, i: int, is_valid_pose: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...

class PF_implementation_mrpt_math_TPose3D_mrpt_slam_CMonteCarloLocalization3D_mrpt_bayes_particle_storage_mode_VALUE_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: PF_implementation_mrpt_math_TPose3D_mrpt_slam_CMonteCarloLocalization3D_mrpt_bayes_particle_storage_mode_VALUE_t) -> None: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData: mrpt.pymrpt.mrpt.math.TPose3D, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(structmrpt, conststructmrpt) -> void: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(self, particles, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(constclassstd, mrpt, constclassmrpt) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement(self) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement() -> bool: ...
    def assign(self) -> PF_implementation_mrpt_math_TPose3D_mrpt_slam_CMonteCarloLocalization3D_mrpt_bayes_particle_storage_mode_VALUE_t: ...
    def getLastPose(self, i: int, is_valid_pose: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...

class TDataAssociationMethod:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    assocJCBB: ClassVar[TDataAssociationMethod] = ...
    assocNN: ClassVar[TDataAssociationMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TDataAssociationMetric:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    metricML: ClassVar[TDataAssociationMetric] = ...
    metricMaha: ClassVar[TDataAssociationMetric] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TDataAssociationResults:
    associations: Dict[int,int]
    distance: float
    indiv_compatibility: Any
    indiv_compatibility_counts: List[int]
    indiv_distances: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
    nNodesExploredInJCBB: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TDataAssociationResults) -> None: ...
    def assign(self) -> TDataAssociationResults: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...

class TICPAlgorithm:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    icpClassic: ClassVar[TICPAlgorithm] = ...
    icpLevenbergMarquardt: ClassVar[TICPAlgorithm] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TICPCovarianceMethod:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    icpCovFiniteDifferences: ClassVar[TICPCovarianceMethod] = ...
    icpCovLinealMSE: ClassVar[TICPCovarianceMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TKLDParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    KLD_binSize_PHI: float
    KLD_binSize_XY: float
    KLD_delta: float
    KLD_epsilon: float
    KLD_maxSampleSize: int
    KLD_minSampleSize: int
    KLD_minSamplesPerBin: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TKLDParams) -> None: ...
    @overload
    def __init__(self, arg0: TKLDParams) -> None: ...
    def assign(self) -> TKLDParams: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

class TMetricMapAlignmentResult:
    executionTime: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMetricMapAlignmentResult) -> None: ...
    def assign(self) -> TMetricMapAlignmentResult: ...

class TMonteCarloLocalizationParams:
    KLD_params: TKLDParams
    metricMap: mrpt.pymrpt.mrpt.maps.CMetricMap
    metricMaps: List[mrpt.pymrpt.mrpt.maps.CMetricMap]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMonteCarloLocalizationParams) -> None: ...
    def assign(self) -> TMonteCarloLocalizationParams: ...

class map_keyframe_t:
    kf_id: int
    metric_map: mrpt.pymrpt.mrpt.maps.CMultiMetricMap
    raw_observations: mrpt.pymrpt.mrpt.obs.CSensoryFrame
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: map_keyframe_t) -> None: ...
    def assign(self) -> map_keyframe_t: ...

class similarity_method_t:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    smCUSTOM_FUNCTION: ClassVar[similarity_method_t] = ...
    smMETRIC_MAP_MATCHING: ClassVar[similarity_method_t] = ...
    smOBSERVATION_OVERLAP: ClassVar[similarity_method_t] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

@overload
def observationsOverlap(o1: mrpt.pymrpt.mrpt.obs.CObservation, o2: mrpt.pymrpt.mrpt.obs.CObservation) -> float: ...
@overload
def observationsOverlap(o1: mrpt.pymrpt.mrpt.obs.CObservation, o2: mrpt.pymrpt.mrpt.obs.CObservation, pose_o2_wrt_o1: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
@overload
def observationsOverlap(o1: mrpt.pymrpt.mrpt.obs.CObservation, o2: mrpt.pymrpt.mrpt.obs.CObservation) -> float: ...
@overload
def observationsOverlap(o1: mrpt.pymrpt.mrpt.obs.CObservation, o2: mrpt.pymrpt.mrpt.obs.CObservation, pose_o2_wrt_o1: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
@overload
def observationsOverlap(sf1: mrpt.pymrpt.mrpt.obs.CSensoryFrame, sf2: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> float: ...
@overload
def observationsOverlap(sf1: mrpt.pymrpt.mrpt.obs.CSensoryFrame, sf2: mrpt.pymrpt.mrpt.obs.CSensoryFrame, pose_sf2_wrt_sf1: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
@overload
def observationsOverlap(sf1: mrpt.pymrpt.mrpt.obs.CSensoryFrame, sf2: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> float: ...
@overload
def observationsOverlap(sf1: mrpt.pymrpt.mrpt.obs.CSensoryFrame, sf2: mrpt.pymrpt.mrpt.obs.CSensoryFrame, pose_sf2_wrt_sf1: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
